/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

public class SearchManager
implements Startable,
ItemsPersistenceListener {
    private static final Log log = ExoLogger.getLogger(SearchManager.class);
    protected final QueryHandlerEntry config;
    protected final DocumentReaderService extractor;
    protected QueryHandler handler;
    protected final ItemDataConsumer itemMgr;
    protected final NamespaceRegistryImpl nsReg;
    protected final NodeTypeManagerImpl ntReg;
    protected final SearchManager parentSearchManager;
    protected QPath indexingRoot;
    protected List<QPath> excludedPaths = new ArrayList<QPath>();
    private final ConfigurationManager cfm;

    public SearchManager(QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeManagerImpl ntReg, WorkspacePersistentDataManager itemMgr, SystemSearchManagerHolder parentSearchManager, DocumentReaderService extractor, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        this.extractor = extractor;
        this.config = config;
        this.ntReg = ntReg;
        this.nsReg = nsReg;
        this.itemMgr = itemMgr;
        this.cfm = cfm;
        this.parentSearchManager = parentSearchManager != null ? parentSearchManager.get() : null;
        itemMgr.addItemPersistenceListener(this);
        this.initializeQueryHandler();
        log.info((Object)(config.getIndexDir() + "  !" + config));
    }

    public Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, Node node) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.handler.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, node);
        return query;
    }

    public Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, String statement, String language) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.handler.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, statement, language);
        return query;
    }

    public QueryHandler getHandler() {
        return this.handler;
    }

    public void onSaveItems(ItemStateChangesLog changesLog) {
        if (this.handler == null) {
            return;
        }
        long time = System.currentTimeMillis();
        final HashSet<String> removedNodes = new HashSet<String>();
        final HashSet<String> addedNodes = new HashSet<String>();
        ArrayList<ItemState> propEvents = new ArrayList<ItemState>();
        List<ItemState> itemStates = changesLog.getAllStates();
        for (ItemState itemState : itemStates) {
            if (this.isExcluded(itemState)) continue;
            if (itemState.isNode()) {
                if (itemState.isAdded() || itemState.isRenamed()) {
                    addedNodes.add(itemState.getData().getIdentifier());
                    continue;
                }
                if (itemState.isDeleted()) {
                    addedNodes.remove(itemState.getData().getIdentifier());
                    removedNodes.add(itemState.getData().getIdentifier());
                    continue;
                }
                if (!itemState.isMixinChanged()) continue;
                removedNodes.add(itemState.getData().getIdentifier());
                addedNodes.add(itemState.getData().getIdentifier());
                continue;
            }
            propEvents.add(itemState);
        }
        for (int i = 0; i < propEvents.size(); ++i) {
            ItemState event = (ItemState)propEvents.get(i);
            String nodeId = event.getData().getParentIdentifier();
            if (event.isAdded()) {
                if (addedNodes.contains(nodeId)) continue;
                addedNodes.add(nodeId);
                removedNodes.add(nodeId);
                continue;
            }
            if (event.isRenamed() || event.isUpdated()) {
                addedNodes.add(nodeId);
                removedNodes.add(nodeId);
                continue;
            }
            if (!event.isDeleted()) continue;
            addedNodes.remove(nodeId);
            removedNodes.add(nodeId);
        }
        Iterator<NodeData> addedStates = new Iterator<NodeData>(){
            private final Iterator<String> iter;
            {
                this.iter = addedNodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public NodeData next() {
                do {
                    String id = this.iter.next();
                    try {
                        ItemData item = SearchManager.this.itemMgr.getItemData(id);
                        if (item != null) {
                            if (item.isNode()) {
                                return (NodeData)item;
                            }
                            log.warn((Object)("Node not found, but property " + id + ", " + item.getQPath().getAsString() + " found. "));
                            continue;
                        }
                        log.warn((Object)("Unable to index node with id " + id + ", node does not exist."));
                    }
                    catch (RepositoryException e) {
                        log.error((Object)("Can't read next node data " + id), (Throwable)e);
                    }
                } while (this.iter.hasNext());
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        Iterator<String> removedIds = new Iterator<String>(){
            private final Iterator<String> iter;
            {
                this.iter = removedNodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public String next() {
                return this.nextNodeId();
            }

            public String nextNodeId() throws NoSuchElementException {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (removedNodes.size() > 0 || addedNodes.size() > 0) {
            try {
                this.handler.updateNodes(removedIds, addedStates);
            }
            catch (RepositoryException e) {
                log.error((Object)("Error indexing changes " + (Object)((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("Error indexing changes " + e), (Throwable)e);
                try {
                    this.handler.logErrorChanges(removedNodes, addedNodes);
                    Thread.sleep(1000L);
                }
                catch (IOException ioe) {
                    log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
                }
                catch (InterruptedException ie) {
                    log.warn((Object)("Exception occure when wait for errorLog" + ie), (Throwable)ie);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("onEvent: indexing finished in " + String.valueOf(System.currentTimeMillis() - time) + " ms."));
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start");
        }
        this.excludedPaths.add(Constants.JCR_SYSTEM_PATH);
        if (this.config.getExcludedNodeIdentifers() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.config.getExcludedNodeIdentifers());
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    ItemData excludeData = this.itemMgr.getItemData(stringTokenizer.nextToken());
                    if (excludeData == null) continue;
                    this.excludedPaths.add(excludeData.getQPath());
                }
                catch (RepositoryException e) {
                    log.warn((Object)e.getLocalizedMessage());
                }
            }
        }
        this.indexingRoot = Constants.ROOT_PATH;
        if (this.config.getRootNodeIdentifer() != null) {
            try {
                ItemData indexingRootData = this.itemMgr.getItemData(this.config.getRootNodeIdentifer());
                if (indexingRootData != null && indexingRootData.isNode()) {
                    this.indexingRoot = indexingRootData.getQPath();
                }
            }
            catch (RepositoryException e) {
                log.warn((Object)(e.getLocalizedMessage() + " Indexing root set to " + this.indexingRoot.getAsString()));
            }
        }
        this.handler.init();
    }

    public void stop() {
        this.handler.close();
        log.info((Object)"Search manager stopped");
    }

    protected boolean isExcluded(ItemState event) {
        for (QPath excludedPath : this.excludedPaths) {
            if (!event.getData().getQPath().isDescendantOf(excludedPath) && !event.getData().getQPath().equals(excludedPath)) continue;
            return true;
        }
        return !event.getData().getQPath().isDescendantOf(this.indexingRoot) && !event.getData().getQPath().equals(this.indexingRoot);
    }

    protected QueryHandlerContext createQueryHandlerContext(QueryHandler parentHandler) throws RepositoryConfigurationException {
        QueryHandlerContext context = new QueryHandlerContext(this.itemMgr, this.config.getRootNodeIdentifer() != null ? this.config.getRootNodeIdentifer() : "00exo0jcr0root0uuid0000000000000", this.ntReg, this.nsReg, parentHandler, this.config.getIndexDir(), this.extractor);
        return context;
    }

    private void initializeQueryHandler() throws RepositoryException, RepositoryConfigurationException {
        String className = this.config.getType();
        if (className == null) {
            throw new RepositoryConfigurationException("Content hanler       configuration fail");
        }
        try {
            Class<?> qHandlerClass = Class.forName(className, true, this.getClass().getClassLoader());
            Constructor<?> constuctor = qHandlerClass.getConstructor(QueryHandlerEntry.class, ConfigurationManager.class);
            this.handler = (QueryHandler)constuctor.newInstance(this.config, this.cfm);
            QueryHandler parentHandler = this.parentSearchManager != null ? this.parentSearchManager.getHandler() : null;
            QueryHandlerContext context = this.createQueryHandlerContext(parentHandler);
            this.handler.setContext(context);
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }
}

