/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;

class DescendantSelfAxisQuery
extends Query {
    private final Query contextQuery;
    private Scorer contextScorer;
    private final Query subQuery;
    private final boolean includeSelf;
    private Scorer subScorer;

    public DescendantSelfAxisQuery(Query context, Query sub) {
        this(context, sub, true);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, boolean includeSelf) {
        this.contextQuery = context;
        this.subQuery = sub;
        this.includeSelf = includeSelf;
    }

    protected Weight createWeight(Searcher searcher) {
        return new DescendantSelfAxisWeight(searcher);
    }

    public String toString(String field) {
        return "(DescendantSelfAxisQuery " + this.contextQuery.toString() + "->" + this.subQuery.toString() + ")";
    }

    public void extractTerms(Set terms) {
        this.contextQuery.extractTerms(terms);
        this.subQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.contextQuery.rewrite(reader);
        Query sQuery = this.subQuery.rewrite(reader);
        if (cQuery == this.contextQuery && sQuery == this.subQuery) {
            return this;
        }
        return new DescendantSelfAxisQuery(cQuery, sQuery, this.includeSelf);
    }

    private class DescendantSelfAxisScorer
    extends Scorer {
        private final HierarchyResolver hResolver;
        private final BitSet contextHits;
        private boolean contextHitsCalculated;
        private int[] ancestorDocs;

        protected DescendantSelfAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.contextHitsCalculated = false;
            this.ancestorDocs = new int[2];
            this.hResolver = hResolver;
            this.contextHits = new BitSet(reader.maxDoc());
        }

        public boolean next() throws IOException {
            this.collectContextHits();
            if (!DescendantSelfAxisQuery.this.subScorer.next() || this.contextHits.isEmpty()) {
                return false;
            }
            int nextDoc = DescendantSelfAxisQuery.this.subScorer.doc();
            while (nextDoc > -1) {
                if (this.isValid(nextDoc)) {
                    return true;
                }
                nextDoc = DescendantSelfAxisQuery.this.subScorer.next() ? DescendantSelfAxisQuery.this.subScorer.doc() : -1;
            }
            return false;
        }

        public int doc() {
            return DescendantSelfAxisQuery.this.subScorer.doc();
        }

        public float score() throws IOException {
            return DescendantSelfAxisQuery.this.subScorer.score();
        }

        public boolean skipTo(int target) throws IOException {
            boolean match = DescendantSelfAxisQuery.this.subScorer.skipTo(target);
            if (match) {
                this.collectContextHits();
                if (this.isValid(DescendantSelfAxisQuery.this.subScorer.doc())) {
                    return true;
                }
                return this.next();
            }
            return true;
        }

        private void collectContextHits() throws IOException {
            if (!this.contextHitsCalculated) {
                DescendantSelfAxisQuery.this.contextScorer.score(new HitCollector(){

                    public void collect(int doc, float score) {
                        DescendantSelfAxisScorer.this.contextHits.set(doc);
                    }
                });
                this.contextHitsCalculated = true;
            }
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        private boolean isValid(int doc) throws IOException {
            if (DescendantSelfAxisQuery.this.includeSelf && this.contextHits.get(doc)) {
                return true;
            }
            int parentDoc = this.hResolver.getParent(doc);
            int ancestorCount = 0;
            this.ancestorDocs[ancestorCount++] = parentDoc;
            while (parentDoc != -1 && !this.contextHits.get(parentDoc)) {
                parentDoc = this.hResolver.getParent(parentDoc);
                if (ancestorCount == this.ancestorDocs.length) {
                    int[] copy = new int[this.ancestorDocs.length * 2];
                    System.arraycopy(this.ancestorDocs, 0, copy, 0, this.ancestorDocs.length);
                    this.ancestorDocs = copy;
                }
                this.ancestorDocs[ancestorCount++] = parentDoc;
            }
            if (parentDoc != -1) {
                for (int i = 0; i < ancestorCount; ++i) {
                    this.contextHits.set(this.ancestorDocs[i]);
                }
                return true;
            }
            return false;
        }
    }

    private class DescendantSelfAxisWeight
    implements Weight {
        private final Searcher searcher;

        private DescendantSelfAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DescendantSelfAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            DescendantSelfAxisQuery.this.contextScorer = DescendantSelfAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            DescendantSelfAxisQuery.this.subScorer = DescendantSelfAxisQuery.this.subQuery.weight(this.searcher).scorer(reader);
            HierarchyResolver resolver = (HierarchyResolver)reader;
            return new DescendantSelfAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

