/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRule;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRuleImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrStandartAnalyzer;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingConfigurationImpl
implements IndexingConfiguration {
    private static final Log log = ExoLogger.getLogger(IndexingConfigurationImpl.class);
    private LocationFactory resolver;
    private ItemDataConsumer ism;
    private Map<InternalQName, List<IndexingRule>> configElements = new HashMap<InternalQName, List<IndexingRule>>();
    private AggregateRule[] aggregateRules;
    private Map<String, Analyzer> analyzers = new HashMap<String, Analyzer>();

    public void addAggregateRules(AggregateRule[] rules) {
        AggregateRule[] newRules = new AggregateRule[this.aggregateRules.length + rules.length];
        System.arraycopy(this.aggregateRules, 0, newRules, 0, this.aggregateRules.length);
        System.arraycopy(rules, 0, newRules, this.aggregateRules.length, rules.length);
        this.aggregateRules = newRules;
    }

    public void addAggregateRule(Node configNode) throws Exception {
        AggregateRule[] rules = new AggregateRule[]{new AggregateRuleImpl(configNode, this.resolver, this.ism)};
        this.addAggregateRules(rules);
    }

    public void removeLastAggregateRule() {
        if (this.aggregateRules != null && this.aggregateRules.length > 0) {
            AggregateRule[] newRules = new AggregateRule[this.aggregateRules.length - 1];
            System.arraycopy(this.aggregateRules, 0, newRules, 0, this.aggregateRules.length - 1);
            this.aggregateRules = newRules;
        }
    }

    public void addIndexigRules(InternalQName name, List<IndexingRule> rules) {
        List<IndexingRule> namedRules = this.configElements.get((Object)name);
        if (namedRules == null) {
            this.configElements.put(name, rules);
        } else {
            namedRules.addAll(rules);
        }
    }

    public Analyzer setPropertyAnalyzer(String propertyName, Analyzer analyzer) {
        return this.analyzers.put(propertyName, analyzer);
    }

    @Override
    public AggregateRule[] getAggregateRules() {
        return this.aggregateRules;
    }

    @Override
    public float getNodeBoost(NodeData state) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.getNodeBoost();
        }
        return 1.0f;
    }

    @Override
    public Analyzer getPropertyAnalyzer(String fieldName) {
        if (this.analyzers.containsKey(fieldName)) {
            return this.analyzers.get(fieldName);
        }
        return null;
    }

    @Override
    public float getPropertyBoost(NodeData state, InternalQName propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.getBoost(propertyName);
        }
        return 1.0f;
    }

    @Override
    public void init(Element config, QueryHandlerContext context, NamespaceMappings nsMappings) throws RepositoryException, IllegalNameException {
        this.ism = context.getItemStateManager();
        this.resolver = new LocationFactory(context.getNamespaceRegistry());
        NodeTypeManagerImpl ntReg = context.getNodeTypeRegistry();
        ArrayList<AggregateRuleImpl> idxAggregates = new ArrayList<AggregateRuleImpl>();
        NodeList indexingConfigs = config.getChildNodes();
        for (int i = 0; i < indexingConfigs.getLength(); ++i) {
            NodeTypeIterator nTypes = ntReg.getAllNodeTypes();
            Node configNode = indexingConfigs.item(i);
            if (configNode.getNodeName().equals("index-rule")) {
                IndexingRule element = new IndexingRule(configNode);
                while (nTypes.hasNext()) {
                    ExtendedNodeType nodeType = (ExtendedNodeType)nTypes.nextNodeType();
                    if (!nodeType.isNodeType(element.getNodeTypeName())) continue;
                    List<IndexingRule> perNtConfig = this.configElements.get((Object)nodeType.getQName());
                    if (perNtConfig == null) {
                        perNtConfig = new ArrayList<IndexingRule>();
                        this.configElements.put(nodeType.getQName(), perNtConfig);
                    }
                    perNtConfig.add(element);
                }
                continue;
            }
            if (configNode.getNodeName().equals("aggregate")) {
                idxAggregates.add(new AggregateRuleImpl(configNode, this.resolver, this.ism));
                continue;
            }
            if (!configNode.getNodeName().equals("analyzers")) continue;
            NodeList childNodes = configNode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node analyzerNode = childNodes.item(j);
                if (!analyzerNode.getNodeName().equals("analyzer")) continue;
                String analyzerClassName = analyzerNode.getAttributes().getNamedItem("class").getNodeValue();
                try {
                    Class<?> clazz = Class.forName(analyzerClassName);
                    if (clazz == JcrStandartAnalyzer.class) {
                        log.warn((Object)("Not allowed to configure " + JcrStandartAnalyzer.class.getName() + " for a property. " + "Using default analyzer for that property."));
                        continue;
                    }
                    if (Analyzer.class.isAssignableFrom(clazz)) {
                        Analyzer analyzer;
                        try {
                            analyzer = (Analyzer)clazz.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        NodeList propertyChildNodes = analyzerNode.getChildNodes();
                        for (int k = 0; k < propertyChildNodes.getLength(); ++k) {
                            Node propertyNode = propertyChildNodes.item(k);
                            if (!propertyNode.getNodeName().equals("property")) continue;
                            InternalQName propName = this.resolver.parseJCRName(IndexingConfigurationImpl.getTextContent(propertyNode)).getInternalName();
                            String fieldName = nsMappings.translatePropertyName(propName);
                            int idx = fieldName.indexOf(58);
                            Analyzer prevAnalyzer = this.setPropertyAnalyzer(fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1), analyzer);
                            if (prevAnalyzer == null) continue;
                            log.warn((Object)("Property " + propName.getAsString() + " has been configured for multiple analyzers. " + " Last configured analyzer is used"));
                        }
                        continue;
                    }
                    log.warn((Object)("org.apache.lucene.analysis.Analyzer is not a superclass of " + analyzerClassName + ". Ignoring this configure analyzer"));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Analyzer class not found: " + analyzerClassName), (Throwable)e);
                }
            }
        }
        this.aggregateRules = idxAggregates.toArray(new AggregateRule[idxAggregates.size()]);
    }

    @Override
    public boolean isIncludedInNodeScopeIndex(NodeData state, InternalQName propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.isIncludedInNodeScopeIndex(propertyName);
        }
        return true;
    }

    @Override
    public boolean isIndexed(NodeData state, InternalQName propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.isIndexed(propertyName);
        }
        return true;
    }

    private IndexingRule getApplicableIndexingRule(NodeData state) {
        InternalQName[] mixTypes;
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.configElements.get((Object)state.getPrimaryTypeName());
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        for (InternalQName mixType : mixTypes = state.getMixinTypeNames()) {
            r = this.configElements.get((Object)mixType);
            if (r == null) continue;
            if (rules == null) {
                rules = new ArrayList();
            }
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule ir : rules) {
                if (!ir.appliesTo(state)) continue;
                return ir;
            }
        }
        return null;
    }

    private PathExpression getCondition(Node config) throws PathNotFoundException, RepositoryException {
        String propertyValue;
        InternalQName propertyName;
        int idx;
        int axis;
        Node conditionAttr = config.getAttributes().getNamedItem("condition");
        if (conditionAttr == null) {
            return null;
        }
        String conditionString = conditionAttr.getNodeValue();
        InternalQName elementTest = null;
        InternalQName nameTest = null;
        if (conditionString.startsWith("ancestor::")) {
            axis = 2;
            idx = "ancestor::".length();
        } else if (conditionString.startsWith("parent::")) {
            axis = 3;
            idx = "parent::".length();
        } else if (conditionString.startsWith("@")) {
            axis = 0;
            idx = "@".length();
        } else {
            axis = 1;
            idx = 0;
        }
        try {
            String name;
            if (conditionString.startsWith("element(", idx)) {
                int colon = conditionString.indexOf(44, idx + "element(".length());
                name = conditionString.substring(idx + "element(".length(), colon).trim();
                if (!name.equals("*")) {
                    nameTest = this.resolver.parseJCRName(ISO9075.decode(name)).getInternalName();
                }
                idx = conditionString.indexOf(")/@", colon);
                String type = conditionString.substring(colon + 1, idx).trim();
                elementTest = this.resolver.parseJCRName(ISO9075.decode(type)).getInternalName();
                idx += ")/@".length();
            } else if (axis == 2 || axis == 1 || axis == 3) {
                String name2 = conditionString.substring(idx, conditionString.indexOf(47, idx));
                if (!name2.equals("*")) {
                    nameTest = this.resolver.parseJCRName(ISO9075.decode(name2)).getInternalName();
                }
                idx += name2.length() + "/@".length();
            }
            int eq = conditionString.indexOf(61, idx);
            name = conditionString.substring(idx, eq).trim();
            propertyName = this.resolver.parseJCRName(ISO9075.decode(name)).getInternalName();
            int quote = conditionString.indexOf(39, eq) + 1;
            propertyValue = conditionString.substring(quote, conditionString.indexOf(39, quote));
        }
        catch (IndexOutOfBoundsException e) {
            throw new RepositoryException(conditionString);
        }
        return new PathExpression(axis, elementTest, nameTest, propertyName, propertyValue);
    }

    private Map<InternalQName, PropertyConfig> getPropertyConfigs(Node config) throws PathNotFoundException, RepositoryException {
        HashMap<InternalQName, PropertyConfig> configs = new HashMap<InternalQName, PropertyConfig>();
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("property")) continue;
            NamedNodeMap attributes = n.getAttributes();
            float boost = 1.0f;
            Node boostAttr = attributes.getNamedItem("boost");
            if (boostAttr != null) {
                try {
                    boost = Float.parseFloat(boostAttr.getNodeValue());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            boolean nodeScopeIndex = true;
            Node nsIndex = attributes.getNamedItem("nodeScopeIndex");
            if (nsIndex != null) {
                nodeScopeIndex = Boolean.valueOf(nsIndex.getNodeValue());
            }
            InternalQName propName = this.resolver.parseJCRName(IndexingConfigurationImpl.getTextContent(n)).getInternalName();
            configs.put(propName, new PropertyConfig(boost, nodeScopeIndex));
        }
        return configs;
    }

    private static String getTextContent(Node node) {
        StringBuffer content = new StringBuffer();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    public class PropertyConfig {
        final float boost;
        final boolean nodeScopeIndex;

        PropertyConfig(float boost, boolean nodeScopeIndex) {
            this.boost = boost;
            this.nodeScopeIndex = nodeScopeIndex;
        }
    }

    public class PathExpression {
        static final int SELF = 0;
        static final int CHILD = 1;
        static final int ANCESTOR = 2;
        static final int PARENT = 3;
        private final int axis;
        private final InternalQName elementTest;
        private final InternalQName nameTest;
        private final InternalQName propertyName;
        private final String propertyValue;

        PathExpression(int axis, InternalQName elementTest, InternalQName nameTest, InternalQName propertyName, String propertyValue) {
            this.axis = axis;
            this.elementTest = elementTest;
            this.nameTest = nameTest;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        boolean evaluate(final NodeData context) {
            Iterator<NodeData> nodeStates;
            block22: {
                if (this.axis == 0) {
                    nodeStates = Collections.singletonList(context).iterator();
                } else if (this.axis == 1) {
                    try {
                        List<NodeData> childs = IndexingConfigurationImpl.this.ism.getChildNodesData(context);
                        nodeStates = childs.iterator();
                    }
                    catch (RepositoryException e) {
                        nodeStates = Collections.emptyList().iterator();
                    }
                } else if (this.axis == 2) {
                    try {
                        nodeStates = new Iterator<NodeData>(){
                            private NodeData next;
                            {
                                this.next = (NodeData)IndexingConfigurationImpl.this.ism.getItemData(context.getParentIdentifier());
                            }

                            @Override
                            public boolean hasNext() {
                                return this.next != null;
                            }

                            @Override
                            public NodeData next() {
                                NodeData tmp = this.next;
                                try {
                                    this.next = this.next.getParentIdentifier() != null ? (NodeData)IndexingConfigurationImpl.this.ism.getItemData(this.next.getParentIdentifier()) : null;
                                }
                                catch (RepositoryException e) {
                                    this.next = null;
                                }
                                return tmp;
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    catch (RepositoryException e) {
                        nodeStates = Collections.emptyList().iterator();
                    }
                } else if (this.axis == 3) {
                    try {
                        if (context.getParentIdentifier() != null) {
                            NodeData state = (NodeData)IndexingConfigurationImpl.this.ism.getItemData(context.getParentIdentifier());
                            nodeStates = Collections.singletonList(state).iterator();
                            break block22;
                        }
                        nodeStates = Collections.emptyList().iterator();
                    }
                    catch (RepositoryException e) {
                        nodeStates = Collections.emptyList().iterator();
                    }
                } else {
                    nodeStates = Collections.emptyList().iterator();
                }
            }
            while (nodeStates.hasNext()) {
                try {
                    NodeData current = nodeStates.next();
                    if (this.elementTest != null && !current.getPrimaryTypeName().equals((Object)this.elementTest) || this.nameTest != null && !current.getQPath().getName().equals((Object)this.nameTest)) continue;
                    List<PropertyData> childProps = IndexingConfigurationImpl.this.ism.getChildPropertiesData(current);
                    PropertyData propState = null;
                    for (PropertyData propertyData : childProps) {
                        if (!propertyData.getQPath().getName().equals((Object)this.propertyName)) continue;
                        propState = propertyData;
                        break;
                    }
                    if (propState == null) continue;
                    List<ValueData> values = propState.getValues();
                    if (propState.getType() == 2) continue;
                    try {
                        for (int i = 0; i < values.size(); ++i) {
                            byte[] bytes = values.get(i).getAsByteArray();
                            String val = new String(bytes, "UTF-8");
                            if (!val.equals(this.propertyValue)) continue;
                            return true;
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)e.getLocalizedMessage());
                    }
                }
                catch (RepositoryException e) {
                    log.error((Object)e.getLocalizedMessage());
                }
            }
            return false;
        }
    }

    public class IndexingRule {
        private final InternalQName nodeTypeName;
        private final Map<InternalQName, PropertyConfig> propConfigs;
        private final PathExpression condition;
        private final float boost;

        IndexingRule(Node config) throws PathNotFoundException, RepositoryException {
            this.nodeTypeName = this.getNodeTypeName(config);
            this.propConfigs = IndexingConfigurationImpl.this.getPropertyConfigs(config);
            this.condition = IndexingConfigurationImpl.this.getCondition(config);
            this.boost = this.getNodeBoost(config);
        }

        public boolean appliesTo(NodeData state) {
            if (!this.nodeTypeName.equals((Object)state.getPrimaryTypeName())) {
                return false;
            }
            if (this.condition == null) {
                return true;
            }
            return this.condition.evaluate(state);
        }

        public float getBoost(InternalQName propertyName) {
            PropertyConfig config = this.propConfigs.get((Object)propertyName);
            if (config != null) {
                return config.boost;
            }
            return 1.0f;
        }

        public float getNodeBoost() {
            return this.boost;
        }

        public InternalQName getNodeTypeName() {
            return this.nodeTypeName;
        }

        public boolean isIncludedInNodeScopeIndex(InternalQName propertyName) {
            PropertyConfig config = this.propConfigs.get((Object)propertyName);
            if (config != null) {
                return config.nodeScopeIndex;
            }
            return false;
        }

        public boolean isIndexed(InternalQName propertyName) {
            return this.propConfigs.containsKey((Object)propertyName);
        }

        private float getNodeBoost(Node config) {
            Node boost = config.getAttributes().getNamedItem("boost");
            if (boost != null) {
                try {
                    return Float.parseFloat(boost.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 1.0f;
        }

        private InternalQName getNodeTypeName(Node config) throws PathNotFoundException, RepositoryException {
            String ntString = config.getAttributes().getNamedItem("nodeType").getNodeValue();
            return IndexingConfigurationImpl.this.resolver.parseJCRName(ntString).getInternalName();
        }
    }
}

