/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

class IndexingQueueStore {
    private static final Log log = ExoLogger.getLogger(IndexingQueueStore.class);
    private static final String ENCODING = "UTF-8";
    private static final String ADD = "ADD";
    private static final String REMOVE = "REMOVE";
    private final Set pending = new HashSet();
    private final File indexDir;
    private final String fileName;
    private Writer out;
    private File fileStore;

    IndexingQueueStore(File roodDir, String fileName) throws IOException {
        this.indexDir = roodDir;
        this.fileName = fileName;
        this.readStore();
    }

    public String[] getPending() {
        return this.pending.toArray(new String[this.pending.size()]);
    }

    public void addUUID(String uuid) throws IOException {
        IndexingQueueStore.writeEntry(ADD, uuid, this.getLog());
        this.pending.add(uuid);
    }

    public void removeUUID(String uuid) throws IOException {
        IndexingQueueStore.writeEntry(REMOVE, uuid, this.getLog());
        this.pending.remove(uuid);
    }

    public void commit() throws IOException {
        if (this.out != null) {
            this.out.flush();
            if (this.pending.size() == 0) {
                this.out.close();
                this.out = null;
            }
        }
    }

    public void close() throws IOException {
        this.commit();
        if (this.out != null) {
            this.out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStore() throws IOException {
        this.fileStore = new File(this.indexDir, this.fileName);
        if (this.fileStore.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.fileStore));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, ENCODING));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int idx = line.indexOf(32);
                    if (idx == -1) {
                        log.warn((Object)("invalid line in " + this.fileName + ":" + line));
                        continue;
                    }
                    String cmd = line.substring(0, idx);
                    String uuid = line.substring(idx + 1, line.length());
                    if (ADD.equals(cmd)) {
                        this.pending.add(uuid);
                        continue;
                    }
                    if (REMOVE.equals(cmd)) {
                        this.pending.remove(uuid);
                        continue;
                    }
                    log.warn((Object)("invalid line in " + this.fileName + ":" + line));
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
    }

    private static void writeEntry(String op, String uuid, Writer writer) throws IOException {
        StringBuffer buf = new StringBuffer(op);
        buf.append(' ').append(uuid).append('\n');
        writer.write(buf.toString());
    }

    private Writer getLog() throws IOException {
        if (this.out == null) {
            try {
                FileOutputStream os = new FileOutputStream(this.fileStore, true);
                this.out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), ENCODING);
            }
            catch (IOException e) {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        return this.out;
    }
}

