/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;

public class NSRegistryBasedNamespaceMappings
implements NamespaceMappings {
    private final NamespaceRegistryImpl nsReg;
    private final LocationFactory nameResolver;

    NSRegistryBasedNamespaceMappings(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
        this.nameResolver = new LocationFactory(nsReg);
    }

    public String translatePropertyName(InternalQName qName) throws IllegalNameException {
        try {
            return this.nameResolver.createJCRName(qName).getAsString();
        }
        catch (RepositoryException e) {
            throw new IllegalNameException("Internal error.", e);
        }
    }

    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.nsReg.getPrefixes();
    }

    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.nsReg.getPrefix(uri);
    }

    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException, RepositoryException {
        try {
            return this.nsReg.getURI(prefix);
        }
        catch (NumberFormatException e) {
            throw new NamespaceException("Unknown prefix: " + prefix);
        }
    }
}

