/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.DBInitializer;

public class IngresSQLDBInitializer
extends DBInitializer {
    public IngresSQLDBInitializer(String containerName, Connection connection, String scriptPath, boolean multiDb) throws IOException {
        super(containerName, connection, scriptPath, multiDb);
    }

    protected boolean isIndexExists(Connection conn, String tableName, String indexName) throws SQLException {
        return super.isIndexExists(conn, tableName.toUpperCase().toLowerCase(), indexName.toUpperCase().toLowerCase());
    }

    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        return super.isTableExists(conn, tableName.toUpperCase().toLowerCase());
    }

    protected boolean isSequenceExists(Connection conn, String sequenceName) throws SQLException {
        String seqName = sequenceName.toUpperCase().toLowerCase();
        try {
            ResultSet srs = conn.createStatement().executeQuery("SELECT NEXT VALUE FOR " + seqName);
            if (srs.next()) {
                return true;
            }
            srs.close();
            return false;
        }
        catch (SQLException e) {
            if (e.getMessage().indexOf("DEFINE CURSOR") >= 0 && e.getMessage().indexOf("Sequence") >= 0) {
                return false;
            }
            throw new SQLException(e.getMessage()){

                public Throwable getCause() {
                    return e;
                }
            };
        }
    }
}

