/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableIOSupport;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileDigestOutputStream;
import org.exoplatform.services.jcr.impl.storage.value.fs.TreeFileIOChannel;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class CASableTreeFileIOChannel
extends TreeFileIOChannel {
    private final ValueContentAddressStorage vcas;
    private final CASableIOSupport cas;

    CASableTreeFileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueContentAddressStorage vcas, String digestAlgo) {
        super(rootDir, cleaner, storageId);
        this.vcas = vcas;
        this.cas = new CASableIOSupport(this, digestAlgo);
    }

    protected File getFile(String propertyId, int orderNumber) throws IOException {
        return super.getFile(this.vcas.getIdentifier(propertyId, orderNumber), 0);
    }

    protected File[] getFiles(String propertyId) throws IOException {
        List<String> hids = this.vcas.getIdentifiers(propertyId, true);
        File[] files = new File[hids.size()];
        for (int i = 0; i < hids.size(); ++i) {
            files[i] = super.getFile(hids.get(i), 0);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String propertyId) throws IOException {
        boolean bl;
        try {
            bl = super.delete(propertyId);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.vcas.delete(propertyId);
            throw throwable;
        }
        this.vcas.delete(propertyId);
        return bl;
    }

    public void write(String propertyId, ValueData value) throws IOException {
        FileDigestOutputStream out = this.cas.openFile(new File(this.rootDir, propertyId + value.getOrderNumber() + ".cas-temp"));
        this.writeOutput(out, value);
        out.close();
        this.cas.saveFile(out);
        this.vcas.add(propertyId, value.getOrderNumber(), out.getDigestHash());
    }
}

