/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.IOException;
import java.util.Properties;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableTreeFileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.TreeFileValueStorage;

public class CASableTreeFileValueStorage
extends TreeFileValueStorage {
    private ValueContentAddressStorage vcas;
    private String digestAlgo;

    public void init(Properties props) throws IOException, RepositoryConfigurationException {
        super.init(props);
        this.digestAlgo = props.getProperty("digest-algo");
        String vcasType = props.getProperty("vcas-type");
        try {
            this.vcas = (ValueContentAddressStorage)Class.forName(vcasType).newInstance();
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("VCAS Storage class load error " + e, e);
        }
        this.vcas.init(props);
    }

    public FileIOChannel openIOChannel() throws IOException {
        return new CASableTreeFileIOChannel(this.rootDir, this.cleaner, this.getId(), this.vcas, this.digestAlgo);
    }
}

