/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.value;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.jcr.rmi.api.value.BaseNonStreamValue;
import org.exoplatform.services.jcr.rmi.api.value.StatefulValue;

public class DateValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 7158448867450810873L;
    private final Calendar value;

    protected DateValue(Calendar value) {
        this.value = value;
    }

    protected DateValue(String value) throws ValueFormatException {
        this(DateValue.toCalendar(value));
    }

    protected static Calendar toCalendar(String value) throws ValueFormatException {
        Calendar time = ISO8601.parse((String)value);
        if (null == time) {
            throw new ValueFormatException();
        }
        return time;
    }

    public int getType() {
        return 5;
    }

    public double getDouble() {
        return this.value.getTimeInMillis();
    }

    public String getString() throws ValueFormatException {
        if (this.value != null) {
            return ISO8601.format((Calendar)this.getDate());
        }
        throw new ValueFormatException("empty value");
    }

    public long getLong() {
        return this.value.getTimeInMillis();
    }

    public Calendar getDate() {
        return (Calendar)this.value.clone();
    }

    public long getLength() {
        try {
            return this.getString().length();
        }
        catch (ValueFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public int getOrderNumber() {
        return 0;
    }
}

