/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.lucene.search.Query;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.JiBX_MungeAdapter;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.DefaultHTMLExcerpt;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfigurationEntityResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfigurationImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrStandartAnalyzer;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellChecker;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.log.ExoLogger;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class QueryHandlerEntry
extends MappedParametrizedObjectEntry {
    public static final int DEFAULT_EXTRACTOR_BACKLOG = 100;
    public static final int DEFAULT_EXTRACTOR_POOLSIZE = 0;
    public static final long DEFAULT_EXTRACTOR_TIMEOUT = 100L;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MIN_MERGE_DOCS = 100;
    public static final String NS_MAPPING_FILE = "ns_mappings.properties";
    private static final String DEDAULT_EXCERPTPROVIDER_CLASS = DefaultHTMLExcerpt.class.getName();
    private static final String DEDAULT_INDEXINGCONFIGURATIONCLASS = IndexingConfigurationImpl.class.getName();
    private static final boolean DEFAULT_AUTOREPAIR = true;
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private static final boolean DEFAULT_CONSISTENCYCHECKENABLED = false;
    private static final boolean DEFAULT_DOCUMENTORDER = true;
    private static final boolean DEFAULT_FORCECONSISTENCYCHECK = false;
    private static final String DEFAULT_QUERY_HANDLER_CLASS = SearchIndex.class.getName();
    private static final String DEFAULT_QUERY_IMPL_CLASS = QueryImpl.class.getName();
    private static final int DEFAULT_RESULTFETCHSIZE = Integer.MAX_VALUE;
    private static final boolean DEFAULT_SUPPORTHIGHLIGHTING = false;
    private static final boolean DEFAULT_USECOMPOUNDFILE = false;
    private static final int DEFAULT_VOLATILEIDLETIME = 3;
    private static final Log log = ExoLogger.getLogger(QueryHandlerEntry.class);
    private static final String PARAM_AUTO_REPAIR = "auto-repair";
    private static final String PARAM_BUFFER_SIZE = "buffer-size";
    private static final String PARAM_CACHE_SIZE = "cache-size";
    private static final String PARAM_CONSISTENCY_CHECK_ENABLED = "consistency-check-enabled";
    private static final String PARAM_DOCUMENT_ORDER = "document-order";
    private static final String PARAM_EXCERPTPROVIDER_CLASS = "excerptprovider-class";
    private static final String PARAM_EXCLUDED_NODE_IDENTIFERS = "excluded-node-identifers";
    private static final String PARAM_EXTRACTOR_BACKLOG = "extractor-backlog";
    private static final String PARAM_EXTRACTOR_POOLSIZE = "extractor-pool-size";
    private static final String PARAM_EXTRACTOR_TIMEOUT = "extractor-timeout";
    private static final String PARAM_FORCE_CONSISTENCYCHECK = "force-consistencycheck";
    private static final String PARAM_ERRORLOG_SIZE = "errorlog-size";
    private static final String PARAM_INDEX_DIR = "index-dir";
    private static final String OLD_PARAM_INDEX_DIR = "indexDir";
    private static final String PARAM_INDEXING_CONFIGURATION_PATH = "indexing-configuration-path";
    private static final String PARAM_INDEXING_CONFIGURATION_CLASS = "indexing-configuration-class";
    private static final String PARAM_MAX_FIELD_LENGTH = "max-field-length";
    private static final String PARAM_MAX_MERGE_DOCS = "max-merge-docs";
    private static final String PARAM_MERGE_FACTOR = "merge-factor";
    private static final String PARAM_MIN_MERGE_DOCS = "min-merge-docs";
    private static final String PARAM_QUERY_CLASS = "query-class";
    private static final String PARAM_RESULT_FETCH_SIZE = "result-fetch-size";
    private static final String PARAM_ROOT_NODE_ID = "root-node-id";
    private static final String PARAM_SPELLCHECKER_CLASS = "spellchecker-class";
    private static final String PARAM_SUPPORT_HIGHLIGHTING = "support-highlighting";
    private static final String PARAM_SYNONYMPROVIDER_CLASS = "synonymprovider-class";
    private static final String PARAM_SYNONYMPROVIDER_CONFIG_PATH = "synonymprovider-config-path";
    private static final String PARAM_USE_COMPOUNDFILE = "use-compoundfile";
    private static final String PARAM_VOLATILE_IDLE_TIME = "volatile-idle-time";
    public QueryHandlerEntry queryHandler;
    public Integer volatileIdleTime;
    private JcrStandartAnalyzer analyzer;
    private String queryHandlerClass = DEFAULT_QUERY_HANDLER_CLASS;

    public QueryHandlerEntry() {
        this.analyzer = new JcrStandartAnalyzer();
    }

    public QueryHandlerEntry(String type, List params) {
        super(type, params);
        this.analyzer = new JcrStandartAnalyzer();
    }

    public ExcerptProvider createExcerptProvider(Query query) throws IOException {
        ExcerptProvider ep;
        try {
            Class<?> excerptProviderClass = Class.forName(this.getExcerptProviderClass(), true, this.getClass().getClassLoader());
            ep = (ExcerptProvider)excerptProviderClass.newInstance();
        }
        catch (Exception e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return ep;
    }

    public IndexingConfiguration createIndexingConfiguration(NamespaceMappings namespaceMappings, QueryHandlerContext context, ConfigurationManager cfm) throws IOException, RepositoryConfigurationException {
        Element docElement = this.getIndexingConfigurationDOM(cfm);
        if (docElement == null) {
            return null;
        }
        IndexingConfiguration idxCfg = null;
        try {
            Class<?> indexingConfigurationClass = Class.forName(this.getIndexingConfigurationClass(), true, this.getClass().getClassLoader());
            idxCfg = (IndexingConfiguration)indexingConfigurationClass.newInstance();
            idxCfg.init(docElement, context, namespaceMappings);
        }
        catch (InstantiationException e) {
            log.warn((Object)("Exception initializing indexing configuration from: " + this.getIndexingConfigurationPath()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Exception initializing indexing configuration from: " + this.getIndexingConfigurationPath()), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.warn((Object)("Exception initializing indexing configuration from: " + this.getIndexingConfigurationPath()), (Throwable)e);
        }
        catch (IllegalNameException e) {
            log.warn((Object)("Exception initializing indexing configuration from: " + this.getIndexingConfigurationPath()), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Exception initializing indexing configuration from: " + this.getIndexingConfigurationPath()), (Throwable)e);
        }
        return idxCfg;
    }

    public SpellChecker createSpellChecker(QueryHandler handler) {
        SpellChecker spCheck = null;
        if (this.getSpellCheckerClass() != null) {
            try {
                Class<?> spellCheckerClass = Class.forName(this.getSpellCheckerClass(), true, this.getClass().getClassLoader());
                spCheck = (SpellChecker)spellCheckerClass.newInstance();
                spCheck.init(handler);
            }
            catch (Exception e) {
                log.warn((Object)("Exception initializing spell checker: " + this.getSpellCheckerClass()), (Throwable)e);
            }
        }
        return spCheck;
    }

    public SynonymProvider createSynonymProvider(ConfigurationManager cfm) {
        SynonymProvider sp = null;
        if (this.getSynonymProviderClass() != null) {
            try {
                Class<?> synonymProviderClass = Class.forName(this.getSynonymProviderClass(), true, this.getClass().getClassLoader());
                sp = (SynonymProvider)synonymProviderClass.newInstance();
                sp.initialize(this.createSynonymProviderConfigResource(cfm));
            }
            catch (Exception e) {
                log.warn((Object)("Exception initializing synonym provider: " + this.getSynonymProviderClass()), (Throwable)e);
                sp = null;
            }
        }
        return sp;
    }

    public JcrStandartAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean getAutoRepair() {
        return this.getParameterBoolean(PARAM_AUTO_REPAIR, true);
    }

    public int getBufferSize() {
        return this.getParameterInteger(PARAM_BUFFER_SIZE, 10);
    }

    public int getCacheSize() {
        return this.getParameterInteger(PARAM_CACHE_SIZE, 1000);
    }

    public boolean getDocumentOrder() {
        return this.getParameterBoolean(PARAM_DOCUMENT_ORDER, true);
    }

    public String getExcerptProviderClass() {
        return this.getParameterValue(PARAM_EXCERPTPROVIDER_CLASS, DEDAULT_EXCERPTPROVIDER_CLASS);
    }

    public String getExcludedNodeIdentifers() {
        return this.getParameterValue(PARAM_EXCLUDED_NODE_IDENTIFERS, null);
    }

    public int getExtractorBackLogSize() {
        return this.getParameterInteger(PARAM_EXTRACTOR_BACKLOG, 100);
    }

    public int getExtractorPoolSize() {
        return this.getParameterInteger(PARAM_EXTRACTOR_POOLSIZE, 0);
    }

    public long getExtractorTimeout() {
        return this.getParameterTime(PARAM_EXTRACTOR_TIMEOUT, 100L);
    }

    public String getIndexDir() throws RepositoryConfigurationException {
        String indexDir;
        try {
            indexDir = this.getParameterValue(PARAM_INDEX_DIR);
        }
        catch (RepositoryConfigurationException e) {
            indexDir = this.getParameterValue(OLD_PARAM_INDEX_DIR);
        }
        indexDir = indexDir.replace("${java.io.tmpdir}", System.getProperty("java.io.tmpdir"));
        return indexDir;
    }

    public String getIndexingConfigurationClass() {
        return this.getParameterValue(PARAM_INDEXING_CONFIGURATION_CLASS, DEDAULT_INDEXINGCONFIGURATIONCLASS);
    }

    public String getIndexingConfigurationPath() {
        return this.getParameterValue(PARAM_INDEXING_CONFIGURATION_PATH, null);
    }

    public int getMaxFieldLength() {
        return this.getParameterInteger(PARAM_MAX_FIELD_LENGTH, 10000);
    }

    public int getMaxMergeDocs() {
        return this.getParameterInteger(PARAM_MAX_MERGE_DOCS, Integer.MAX_VALUE);
    }

    public int getMergeFactor() {
        return this.getParameterInteger(PARAM_MERGE_FACTOR, 10);
    }

    public int getMinMergeDocs() {
        return this.getParameterInteger(PARAM_MIN_MERGE_DOCS, 100);
    }

    public String getQueryClass() {
        return this.getParameterValue(PARAM_QUERY_CLASS, DEFAULT_QUERY_IMPL_CLASS);
    }

    public QueryHandlerEntry getQueryHandler() {
        return this.queryHandler;
    }

    public int getResultFetchSize() {
        return this.getParameterInteger(PARAM_RESULT_FETCH_SIZE, Integer.MAX_VALUE);
    }

    public String getRootNodeIdentifer() {
        return this.getParameterValue(PARAM_ROOT_NODE_ID, "00exo0jcr0root0uuid0000000000000");
    }

    public String getSpellCheckerClass() {
        return this.getParameterValue(PARAM_SPELLCHECKER_CLASS, null);
    }

    public boolean getSupportHighlighting() {
        return this.getParameterBoolean(PARAM_SUPPORT_HIGHLIGHTING, false);
    }

    public String getSynonymProviderClass() {
        return this.getParameterValue(PARAM_SYNONYMPROVIDER_CLASS, null);
    }

    public String getSynonymProviderConfigPath() {
        return this.getParameterValue(PARAM_SYNONYMPROVIDER_CONFIG_PATH, null);
    }

    public boolean getUseCompoundFile() {
        return this.getParameterBoolean(PARAM_USE_COMPOUNDFILE, false);
    }

    public int getVolatileIdleTime() {
        if (this.volatileIdleTime == null) {
            this.volatileIdleTime = this.getParameterInteger(PARAM_VOLATILE_IDLE_TIME, 3);
        }
        return this.volatileIdleTime;
    }

    public boolean isConsistencyCheckEnabled() {
        return this.getParameterBoolean(PARAM_CONSISTENCY_CHECK_ENABLED, false);
    }

    public boolean isForceConsistencyCheck() {
        return this.getParameterBoolean(PARAM_FORCE_CONSISTENCYCHECK, false);
    }

    protected InputStream createSynonymProviderConfigResource(ConfigurationManager cfm) throws Exception {
        if (this.getSynonymProviderConfigPath() != null) {
            return cfm.getInputStream(this.getSynonymProviderConfigPath());
        }
        return null;
    }

    protected Element getIndexingConfigurationDOM(ConfigurationManager cfm) throws IOException, RepositoryConfigurationException {
        String indexingConfigPath = this.getIndexingConfigurationPath();
        Element indexingConfiguration = null;
        if (indexingConfigPath != null) {
            InputStream is;
            try {
                is = cfm.getInputStream(indexingConfigPath);
            }
            catch (Exception e1) {
                throw new IOException(e1.getLocalizedMessage());
            }
            if (is == null) {
                throw new IOException("Resource does not exist: " + indexingConfigPath);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new IndexingConfigurationEntityResolver());
                indexingConfiguration = builder.parse(is).getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryConfigurationException(e.getLocalizedMessage(), e);
            }
            catch (SAXException e) {
                throw new RepositoryConfigurationException(e.getLocalizedMessage(), e);
            }
        }
        return indexingConfiguration;
    }

    public int getErrorLogSize() {
        String size = this.getParameterValue(PARAM_ERRORLOG_SIZE, null);
        if (size == null || size.equals("")) {
            return 50;
        }
        return new Integer(size);
    }

    public static /* synthetic */ QueryHandlerEntry JiBX_binding_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return new QueryHandlerEntry();
    }

    public final /* synthetic */ QueryHandlerEntry JiBX_binding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        QueryHandlerEntry queryHandlerEntry = this;
        String string = arg1.attributeText(null, "class");
        if (string == null) {
            string = null;
        }
        this.type = string;
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ QueryHandlerEntry JiBX_binding_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        QueryHandlerEntry queryHandlerEntry = this;
        if (arg1.isAt(null, "properties")) {
            arg1.parsePastStartTag(null, "properties");
            List list = this.parameters;
            if (list == null) {
                list = JiBX_MungeAdapter.JiBX_binding_newinstance_1_0(arg1);
            }
            this.parameters = JiBX_MungeAdapter.JiBX_binding_unmarshal_1_2(list, arg1);
            arg1.parsePastCurrentEndTag(null, "properties");
        } else {
            this.parameters = null;
        }
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_binding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1.attribute(0, "class", this.type);
        arg1.popObject();
    }

    public final /* synthetic */ void JiBX_binding_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        if (this.parameters != null) {
            arg1.startTag(0, "properties");
            JiBX_MungeAdapter.JiBX_binding_marshal_1_4(this.parameters, arg1);
            arg1.endTag(0, "properties");
        }
        arg1.popObject();
    }
}

