/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionableResourceManager {
    private Map<String, List<SoftReference<XASessionImpl>>> txManagers = new HashMap<String, List<SoftReference<XASessionImpl>>>();

    public synchronized void add(XASessionImpl userSession) {
        List<SoftReference<XASessionImpl>> joinedList = this.txManagers.get(userSession.getUserID());
        if (joinedList != null) {
            Iterator<SoftReference<XASessionImpl>> siter = joinedList.iterator();
            while (siter.hasNext()) {
                try {
                    XASessionImpl xaSession = siter.next().get();
                    if (xaSession != null && xaSession.isLive()) continue;
                    siter.remove();
                }
                catch (ConcurrentModificationException e) {
                    e.printStackTrace();
                    System.err.println("same user >>> " + e);
                }
            }
            joinedList.add(new SoftReference<XASessionImpl>(userSession));
            this.putIfAbsent(userSession.getUserID(), joinedList);
        } else {
            ArrayList<SoftReference<XASessionImpl>> newJoinedList = new ArrayList<SoftReference<XASessionImpl>>();
            List<SoftReference<XASessionImpl>> previous = this.putIfAbsent(userSession.getUserID(), newJoinedList);
            if (previous != null) {
                previous.add(new SoftReference<XASessionImpl>(userSession));
            } else {
                newJoinedList.add(new SoftReference<XASessionImpl>(userSession));
            }
        }
    }

    public synchronized void remove(XASessionImpl userSession) {
        List<SoftReference<XASessionImpl>> joinedList = this.txManagers.get(userSession.getUserID());
        if (joinedList != null) {
            Iterator<SoftReference<XASessionImpl>> siter = joinedList.iterator();
            while (siter.hasNext()) {
                XASessionImpl xaSession = siter.next().get();
                if (xaSession != null && xaSession.isLive() && xaSession != userSession) continue;
                siter.remove();
            }
            if (joinedList.size() <= 0) {
                this.txManagers.remove(userSession.getUserID());
            }
        }
    }

    public synchronized void commit(XASessionImpl userSession) throws TransactionException {
        List<SoftReference<XASessionImpl>> joinedList = this.txManagers.remove(userSession.getUserID());
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.commit();
            }
        }
    }

    public synchronized void start(XASessionImpl userSession) {
        List<SoftReference<XASessionImpl>> joinedList = this.txManagers.get(userSession.getUserID());
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.start();
            }
        }
    }

    public synchronized void rollback(XASessionImpl userSession) {
        List<SoftReference<XASessionImpl>> joinedList = this.txManagers.remove(userSession.getUserID());
        if (joinedList != null) {
            for (SoftReference<XASessionImpl> sr : joinedList) {
                XASessionImpl xaSession = sr.get();
                if (xaSession == null || !xaSession.isLive()) continue;
                TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                txManager.rollback();
            }
        }
    }

    private List<SoftReference<XASessionImpl>> putIfAbsent(String key, List<SoftReference<XASessionImpl>> value) {
        if (!this.txManagers.containsKey(key)) {
            return this.txManagers.put(key, value);
        }
        return this.txManagers.get(key);
    }
}

