/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataMoveVisitor
extends ItemDataTraversingVisitor {
    protected List<ItemState> deleteStates = new ArrayList<ItemState>();
    private InternalQName destNodeName;
    protected Stack<NodeData> parents;
    protected List<ItemState> addStates = new ArrayList<ItemState>();
    protected boolean keepIdentifiers;
    protected NodeTypeManagerImpl ntManager;
    protected QPath ancestorToSave = null;

    public ItemDataMoveVisitor(NodeData parent, InternalQName dstNodeName, NodeTypeManagerImpl nodeTypeManager, SessionDataManager srcDataManager, boolean keepIdentifiers) {
        super(srcDataManager);
        this.keepIdentifiers = keepIdentifiers;
        this.ntManager = nodeTypeManager;
        this.destNodeName = dstNodeName;
        this.parents = new Stack();
        this.parents.add(parent);
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        int destOrderNum;
        int destIndex;
        InternalQName qname;
        if (this.ancestorToSave == null) {
            this.ancestorToSave = QPath.getCommonAncestorPath(this.curParent().getQPath(), node.getQPath());
        }
        NodeData parent = this.curParent();
        if (level == 0) {
            NodeData srcParent;
            List<NodeData> srcChilds;
            qname = this.destNodeName;
            List<NodeData> destChilds = this.dataManager.getChildNodesData(parent);
            destIndex = 1;
            int n = destOrderNum = destChilds.size() > 0 ? destChilds.get(destChilds.size() - 1).getOrderNumber() + 1 : 0;
            if (parent.getIdentifier().equals(node.getParentIdentifier())) {
                srcChilds = destChilds;
                srcParent = parent;
            } else {
                for (NodeData dchild : destChilds) {
                    if (!dchild.getQPath().getName().equals((Object)qname)) continue;
                    ++destIndex;
                }
                srcParent = (NodeData)this.dataManager.getItemData(node.getParentIdentifier());
                if (srcParent == null) {
                    throw new RepositoryException("FATAL: parent Node not for " + node.getQPath().getAsString() + ", parent id: " + node.getParentIdentifier());
                }
                srcChilds = this.dataManager.getChildNodesData(srcParent);
            }
            int srcOrderNum = 0;
            int srcIndex = 1;
            for (int i = 0; i < srcChilds.size(); ++i) {
                NodeData child = srcChilds.get(i);
                if (child.getIdentifier().equals(node.getIdentifier())) continue;
                if (child.getQPath().getName().equals((Object)qname)) {
                    QPath siblingPath = QPath.makeChildPath(srcParent.getQPath(), child.getQPath().getName(), srcIndex);
                    TransientNodeData sibling = new TransientNodeData(siblingPath, child.getIdentifier(), child.getPersistedVersion() + 1, child.getPrimaryTypeName(), child.getMixinTypeNames(), srcOrderNum, child.getParentIdentifier(), child.getACL());
                    this.addStates.add(new ItemState(sibling, 2, true, this.ancestorToSave, false, true));
                    ++srcIndex;
                }
                ++srcOrderNum;
            }
            if (srcChilds == destChilds) {
                destIndex = srcIndex;
                destOrderNum = srcOrderNum;
            }
        } else {
            qname = node.getQPath().getName();
            destIndex = node.getQPath().getIndex();
            destOrderNum = node.getOrderNumber();
        }
        String id = this.keepIdentifiers ? node.getIdentifier() : IdGenerator.generate();
        QPath qpath = QPath.makeChildPath(parent.getQPath(), qname, destIndex);
        TransientNodeData newNode = new TransientNodeData(qpath, id, -1, node.getPrimaryTypeName(), node.getMixinTypeNames(), destOrderNum, parent.getIdentifier(), node.getACL());
        this.parents.push(newNode);
        this.addStates.add(new ItemState(newNode, 32, level == 0, this.ancestorToSave, false, level == 0));
        this.deleteStates.add(new ItemState(node, 4, level == 0, this.ancestorToSave, false, false));
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        List<ValueData> values;
        InternalQName qname = property.getQPath().getName();
        if (this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, this.curParent().getPrimaryTypeName(), this.curParent().getMixinTypeNames()) && qname.equals((Object)Constants.JCR_UUID)) {
            values = new ArrayList<ValueData>(1);
            values.add(new TransientValueData(this.curParent().getIdentifier()));
        } else {
            values = property.getValues();
        }
        TransientPropertyData newProperty = new TransientPropertyData(QPath.makeChildPath(this.curParent().getQPath(), qname), this.keepIdentifiers ? property.getIdentifier() : IdGenerator.generate(), -1, property.getType(), this.curParent().getIdentifier(), property.isMultiValued());
        newProperty.setValues(values);
        this.addStates.add(new ItemState(newProperty, 32, false, this.ancestorToSave, false, false));
        this.deleteStates.add(new ItemState(property, 4, false, this.ancestorToSave, false, false));
    }

    public List<ItemState> getAllStates() {
        List<ItemState> list = this.getItemDeletedStates(true);
        list.addAll(this.getItemAddStates());
        return list;
    }

    public List<ItemState> getItemDeletedStates(boolean isInverse) {
        if (isInverse) {
            Collections.reverse(this.deleteStates);
        }
        return this.deleteStates;
    }

    protected NodeData curParent() {
        return this.parents.peek();
    }

    @Override
    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    @Override
    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }

    public List<ItemState> getItemAddStates() {
        return this.addStates;
    }
}

