/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.itemfilters.NamePatternFilter;
import org.exoplatform.services.jcr.impl.core.lock.LockImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.version.ItemDataMergeVisitor;
import org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
extends ItemImpl
implements ExtendedNode {
    protected static Log log = ExoLogger.getLogger((String)"jcr.NodeImpl");
    protected LocationFactory sysLocFactory;
    private NodeDefinition definition;

    public NodeImpl(NodeData data, SessionImpl session) throws RepositoryException {
        super(data, session);
        this.sysLocFactory = session.getSystemLocationFactory();
        this.loadData(data);
    }

    @Override
    public void loadData(ItemData data) throws RepositoryException, InvalidItemStateException, ConstraintViolationException {
        if (data == null) {
            throw new InvalidItemStateException("Data is null for " + this.getPath() + " Probably was deleted by another session and can not be loaded from container ");
        }
        if (!data.isNode()) {
            throw new RepositoryException("Load data failed: Node expected");
        }
        NodeData nodeData = (NodeData)data;
        if (nodeData.getPrimaryTypeName() == null) {
            throw new RepositoryException("Load data: NodeData has no primaryTypeName. Null value found. " + (nodeData.getQPath() != null ? nodeData.getQPath().getAsString() : "[null path node]") + " " + nodeData);
        }
        if (nodeData.getMixinTypeNames() == null) {
            throw new RepositoryException("Load data: NodeData has no mixinTypeNames. Null value found. " + (nodeData.getQPath() != null ? nodeData.getQPath().getAsString() : "[null path node]"));
        }
        if (nodeData.getACL() == null) {
            throw new RepositoryException("ACL is NULL " + nodeData.getQPath().getAsString());
        }
        this.data = nodeData;
        this.location = this.session.getLocationFactory().createJCRPath(this.getData().getQPath());
    }

    private void initDefinition() throws RepositoryException, ConstraintViolationException {
        if (this.isRoot()) {
            NodeDefinitionImpl defNodeDef = new NodeDefinitionImpl(null, null);
            defNodeDef.setRequiredNodeTypes(new NodeType[]{this.nodeType(Constants.NT_BASE)});
            this.definition = defNodeDef;
            return;
        }
        NodeData parent = (NodeData)this.dataManager.getItemData(this.getParentIdentifier());
        this.definition = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(this.getInternalName(), parent.getPrimaryTypeName(), parent.getMixinTypeNames());
        if (this.definition == null) {
            throw new ConstraintViolationException("NodeImpl.getDefinition failed. Definition not found for " + this.getPath());
        }
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        this.checkValid();
        JCRPath itemPath = this.locationFactory.parseRelPath(relPath);
        ItemImpl node = this.dataManager.getItem(this.nodeData(), itemPath.getInternalPath().getEntries(), true);
        if (node == null || !node.isNode()) {
            throw new PathNotFoundException("Node not found " + (this.isRoot() ? "" : this.getLocation().getAsString(false)) + "/" + itemPath.getAsString(false));
        }
        return (NodeImpl)node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeIterator getNodes() throws RepositoryException {
        EntityCollection entityCollection;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"getNodes() >>>>>");
        }
        this.checkValid();
        try {
            entityCollection = new EntityCollection(this.childNodes());
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_4 = null;
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("getNodes() <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodes() <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return entityCollection;
    }

    public List<NodeImpl> childNodes() throws RepositoryException, AccessDeniedException {
        List<NodeImpl> storedNodes = this.dataManager.getChildNodes(this.nodeData(), true);
        Collections.sort(storedNodes, new NodesOrderComparator());
        return storedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        EntityCollection entityCollection;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"getNodes(String) >>>>>");
        }
        this.checkValid();
        try {
            NamePatternFilter filter = new NamePatternFilter(namePattern);
            ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
            for (NodeImpl item : this.childNodes()) {
                if (!filter.accept(item)) continue;
                list.add(item);
            }
            entityCollection = new EntityCollection(list);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var9_8 = null;
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("getNodes(String) <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodes(String) <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return entityCollection;
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        ItemImpl prop;
        this.checkValid();
        JCRPath itemPath = this.locationFactory.parseRelPath(relPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getProperty() " + this.getLocation().getAsString(false) + " " + relPath));
        }
        if ((prop = this.dataManager.getItem(this.nodeData(), itemPath.getInternalPath().getEntries(), true)) == null || prop.isNode()) {
            throw new PathNotFoundException("Property not found " + itemPath.getAsString(false));
        }
        return (Property)prop;
    }

    protected PropertyImpl property(InternalQName name) throws IllegalPathException, PathNotFoundException, RepositoryException {
        PropertyImpl prop = (PropertyImpl)this.dataManager.getItem(this.nodeData(), new QPathEntry(name, 1), false);
        if (prop == null || prop.isNode()) {
            throw new PathNotFoundException("Property not found " + (Object)((Object)name));
        }
        return prop;
    }

    private boolean hasProperty(InternalQName name) {
        try {
            ItemData pdata = this.dataManager.getItemData(this.nodeData(), new QPathEntry(name, 1));
            if (pdata != null && !pdata.isNode()) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyIterator getProperties() throws RepositoryException {
        EntityCollection entityCollection;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"getProperties() >>>>>");
        }
        this.checkValid();
        try {
            entityCollection = new EntityCollection(this.childProperties());
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_4 = null;
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("getProperties() <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getProperties() <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return entityCollection;
    }

    public List<PropertyImpl> childProperties() throws RepositoryException, AccessDeniedException {
        List<PropertyImpl> storedProperties = this.dataManager.getChildProperties(this.nodeData(), true);
        Collections.sort(storedProperties, new PropertiesOrderComparator());
        return storedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        EntityCollection entityCollection;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"getProperties(String) >>>>>");
        }
        this.checkValid();
        try {
            NamePatternFilter filter = new NamePatternFilter(namePattern);
            ArrayList<PropertyImpl> list = new ArrayList<PropertyImpl>();
            for (PropertyImpl item : this.childProperties()) {
                if (!filter.accept(item)) continue;
                list.add(item);
            }
            entityCollection = new EntityCollection(list);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var9_8 = null;
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("getProperties(String) <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getProperties(String) <<<<< " + (double)(System.currentTimeMillis() - start) / 1000.0 + "sec"));
        }
        return entityCollection;
    }

    public int getIndex() throws RepositoryException {
        this.checkValid();
        return this.getInternalPath().getIndex();
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        this.checkValid();
        ExtendedNodeType[] types = this.getAllNodeTypes();
        for (int i = 0; i < types.length; ++i) {
            ItemImpl primaryItem;
            if (types[i].getPrimaryItemName() == null || (primaryItem = this.dataManager.getItem(this.nodeData(), new QPathEntry(this.locationFactory.parseJCRName(types[i].getPrimaryItemName()).getInternalName(), 0), true)) == null) continue;
            return primaryItem;
        }
        throw new ItemNotFoundException("Primary item not found for " + this.getPath());
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        if (this.isNodeType(Constants.MIX_REFERENCEABLE)) {
            return this.getInternalIdentifier();
        }
        throw new UnsupportedRepositoryOperationException("Node " + this.getPath() + " is not referenceable");
    }

    public PropertyIterator getReferences() throws RepositoryException {
        this.checkValid();
        return new EntityCollection(this.dataManager.getReferences(this.getInternalIdentifier()));
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        this.checkValid();
        JCRPath itemPath = this.locationFactory.parseRelPath(relPath);
        ItemData node = this.dataManager.getItemData(this.nodeData(), itemPath.getInternalPath().getEntries());
        return node != null && node.isNode();
    }

    public boolean hasNodes() throws RepositoryException {
        this.checkValid();
        return this.dataManager.getChildNodesData(this.nodeData()).size() > 0;
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        this.checkValid();
        JCRPath itemPath = this.locationFactory.parseRelPath(relPath);
        ItemData prop = this.dataManager.getItemData(this.nodeData(), itemPath.getInternalPath().getEntries());
        return prop != null && !prop.isNode();
    }

    public boolean hasProperties() throws RepositoryException {
        this.checkValid();
        return this.dataManager.listChildPropertiesData(this.nodeData()).size() > 0;
    }

    public Node addNode(String relPath) throws PathNotFoundException, ConstraintViolationException, RepositoryException, VersionException, LockException {
        this.checkValid();
        if (".".equals(relPath)) {
            throw new RepositoryException("Can't add node to the path '" + relPath + "'");
        }
        JCRPath itemPath = this.locationFactory.parseRelPath(relPath);
        if (itemPath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + itemPath.getAsString(false));
        }
        ItemImpl parentItem = this.dataManager.getItem(this.nodeData(), itemPath.makeParentPath().getInternalPath().getEntries(), false);
        if (parentItem == null) {
            throw new PathNotFoundException("Parent not found for " + itemPath.getAsString(true));
        }
        if (!parentItem.isNode()) {
            throw new ConstraintViolationException("Parent item is not a node " + parentItem.getPath());
        }
        NodeImpl parent = (NodeImpl)parentItem;
        InternalQName name = itemPath.getName().getInternalName();
        JCRName nodeTypeName = parent.findNodeType(itemPath.getName().getAsString());
        return this.doAddNode(parent, name, nodeTypeName.getInternalName());
    }

    private JCRName findNodeType(String name) throws RepositoryException, ConstraintViolationException {
        ExtendedNodeType[] nodeTypes = this.getAllNodeTypes();
        String residualNodeTypeName = null;
        for (int j = 0; j < nodeTypes.length; ++j) {
            NodeDefinition[] nodeDefs = nodeTypes[j].getChildNodeDefinitions();
            for (int i = 0; i < nodeDefs.length; ++i) {
                NodeDefinition nodeDef = nodeDefs[i];
                if (nodeDef.getName().equals(name)) {
                    return this.sysLocFactory.parseJCRName(nodeDef.getDefaultPrimaryType().getName());
                }
                if (!nodeDef.getName().equals("*")) continue;
                residualNodeTypeName = nodeDef.getDefaultPrimaryType().getName();
            }
        }
        if (residualNodeTypeName == null) {
            throw new ConstraintViolationException("Can not define node type for " + name);
        }
        return this.sysLocFactory.parseJCRName(residualNodeTypeName);
    }

    public Node addNode(String relPath, String nodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, ConstraintViolationException, RepositoryException, VersionException, LockException {
        this.checkValid();
        if (".".equals(relPath)) {
            throw new RepositoryException("Can't add node to the path '" + relPath + "'");
        }
        JCRPath itemPath = this.locationFactory.parseRelPath(relPath);
        if (itemPath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + itemPath.getAsString(false));
        }
        ItemImpl parentItem = this.dataManager.getItem(this.nodeData(), itemPath.makeParentPath().getInternalPath().getEntries(), false);
        if (parentItem == null) {
            throw new PathNotFoundException("Parent not found for " + itemPath.getAsString(true));
        }
        if (!parentItem.isNode()) {
            throw new ConstraintViolationException("Parent item is not a node " + parentItem.getPath());
        }
        NodeImpl parent = (NodeImpl)parentItem;
        InternalQName name = itemPath.getName().getInternalName();
        InternalQName ptName = this.locationFactory.parseJCRName(nodeTypeName).getInternalName();
        return this.doAddNode(parent, name, ptName);
    }

    public void validateChildNode(InternalQName name, InternalQName primaryTypeName) throws ItemExistsException, RepositoryException, ConstraintViolationException, VersionException, LockException {
        ExtendedNodeType t;
        String ptStr = this.sysLocFactory.createJCRName(primaryTypeName).getAsString();
        if (this.nodeType(primaryTypeName).isMixin()) {
            throw new ConstraintViolationException("Add Node failed: Node Type <" + ptStr + "> is MIXIN type!");
        }
        ExtendedNodeType[] types = this.getAllNodeTypes();
        for (int i = 0; i < types.length && !(t = types[i]).isChildNodePrimaryTypeAllowed(ptStr); ++i) {
            if (i != types.length - 1) continue;
            throw new ConstraintViolationException("Can't add node " + name.getAsString() + " to " + this.getPath() + " node type " + primaryTypeName.getAsString() + " is not allowed as child's node type for parent node type ");
        }
        if (this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(name, this.nodeData().getPrimaryTypeName(), this.nodeData().getMixinTypeNames()).isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + name.getAsString() + " to " + this.getPath());
        }
        if (!this.checkedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NodeImpl doAddNode(NodeImpl parentNode, InternalQName name, InternalQName primaryTypeName) throws ItemExistsException, RepositoryException, ConstraintViolationException, VersionException, LockException {
        NodeDefinitionImpl def;
        block9: {
            ExtendedNodeType t;
            if (this.nodeType(primaryTypeName).isMixin()) {
                throw new ConstraintViolationException("Can not add node to " + parentNode.getPath() + " node type " + primaryTypeName.getAsString() + " is mixin ");
            }
            String ptStr = this.sysLocFactory.createJCRName(primaryTypeName).getAsString();
            ExtendedNodeType[] types = this.getAllNodeTypes();
            for (int i = 0; i < types.length && !(t = types[i]).isChildNodePrimaryTypeAllowed(ptStr); ++i) {
                if (i != types.length - 1) continue;
                throw new ConstraintViolationException("Can't add node " + name.getAsString() + " to " + this.getPath() + " node type " + primaryTypeName.getAsString() + " is not allowed as child's node type for parent node type ");
            }
            def = null;
            try {
                def = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(name, parentNode.nodeData().getPrimaryTypeName(), parentNode.nodeData().getMixinTypeNames());
                Object var9_9 = null;
                if (def != null) break block9;
                throw new ConstraintViolationException("Can't add node " + name.getAsString() + " to " + this.getPath() + ". Node type " + primaryTypeName.getAsString() + " is not allowed as child's node  " + ptStr + " for parent node type ");
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (def != null) throw throwable;
                throw new ConstraintViolationException("Can't add node " + name.getAsString() + " to " + this.getPath() + ". Node type " + primaryTypeName.getAsString() + " is not allowed as child's node  " + ptStr + " for parent node type ");
            }
        }
        if (def.isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + name.getAsString() + " to " + parentNode.getPath());
        }
        if (!this.checkedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        InternalQName[] mixinTypeNames = new InternalQName[]{};
        String identifier = IdGenerator.generate();
        int orderNum = parentNode.getNextChildOrderNum();
        int index = parentNode.getNextChildIndex(name, parentNode.nodeData());
        QPath path = QPath.makeChildPath(parentNode.getInternalPath(), name, index);
        AccessControlList acl = parentNode.getACL();
        TransientNodeData nodeData = new TransientNodeData(path, identifier, -1, primaryTypeName, mixinTypeNames, orderNum, parentNode.getInternalIdentifier(), acl);
        ItemState state = ItemState.createAddedState(nodeData, false);
        NodeImpl node = (NodeImpl)this.dataManager.update(state, true);
        this.addAutoCreatedItems(node.nodeData(), primaryTypeName, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new node : " + node.getPath() + " name: " + " primaryType: " + node.getPrimaryNodeType().getName() + " index: " + node.getIndex() + " parent: " + parentNode));
        }
        this.session.getActionHandler().postAddNode(node);
        return node;
    }

    private int getNextChildIndex(InternalQName nameToAdd, List<NodeData> siblings, NodeData parentNode) throws RepositoryException, ItemExistsException {
        int ind = 0;
        for (NodeData sibling : siblings) {
            if (!sibling.getQPath().getName().equals((Object)nameToAdd)) continue;
            NodeDefinitionImpl def = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(nameToAdd, parentNode.getPrimaryTypeName(), parentNode.getMixinTypeNames());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculate index for " + (Object)((Object)nameToAdd) + " " + sibling.getQPath().getAsString()));
            }
            if (def.allowsSameNameSiblings()) {
                ++ind;
                continue;
            }
            throw new ItemExistsException("The node " + (Object)((Object)nameToAdd) + " already exists in " + this.getPath() + " and same name sibling is not allowed ");
        }
        return ind + 1;
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), values, true, type);
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), values, true, 0);
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        Value[] val = null;
        if (values != null) {
            val = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                val[i] = this.valueFactory.createValue(values[i]);
            }
        }
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), val, true, 0);
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        Value[] val = null;
        if (values != null) {
            val = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                val[i] = this.valueFactory.createValue(values[i], type);
            }
        }
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), val, true, type);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), value, false, 0);
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), value, false, type);
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value, type), false, type);
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        this.checkValid();
        return this.nodeType(this.nodeData().getPrimaryTypeName());
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.checkValid();
        if (this.nodeData().getMixinTypeNames() == null) {
            throw new RepositoryException("Data Container implementation error getMixinTypeNames == null");
        }
        NodeType[] mixinNodeTypes = new ExtendedNodeType[this.nodeData().getMixinTypeNames().length];
        for (int i = 0; i < mixinNodeTypes.length; ++i) {
            mixinNodeTypes[i] = this.nodeType(this.nodeData().getMixinTypeNames()[i]);
        }
        return mixinNodeTypes;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.isNodeType(this.locationFactory.parseJCRName(nodeTypeName).getInternalName());
    }

    @Override
    public boolean isNodeType(InternalQName qName) throws RepositoryException {
        return this.session.getWorkspace().getNodeTypeManager().isNodeType(qName, this.nodeData().getPrimaryTypeName(), this.nodeData().getMixinTypeNames());
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        this.checkValid();
        if (this.definition == null) {
            this.initDefinition();
        }
        return this.definition;
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        this.checkValid();
        SessionImpl corrSession = ((RepositoryImpl)this.session.getRepository()).internalLogin(this.session.getUserState(), workspaceName);
        return corrSession.getLocationFactory().createJCRPath(this.getCorrespondingNodeData(corrSession).getQPath()).getAsString(false);
    }

    public NodeData getCorrespondingNodeData(SessionImpl corrSession) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        NodeData corrNode;
        QPath myPath = this.nodeData().getQPath();
        SessionDataManager corrDataManager = corrSession.getTransientNodesManager();
        if (this.isNodeType(Constants.MIX_REFERENCEABLE)) {
            corrNode = (NodeData)corrDataManager.getItemData(this.getUUID());
            if (corrNode != null) {
                return corrNode;
            }
        } else {
            NodeData ancestor = (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
            for (int i = 1; i < myPath.getDepth(); ++i) {
                ancestor = (NodeData)this.dataManager.getItemData(ancestor, myPath.getEntries()[i]);
                if (!corrSession.getWorkspace().getNodeTypeManager().isNodeType(Constants.MIX_REFERENCEABLE, ancestor.getPrimaryTypeName(), ancestor.getMixinTypeNames())) continue;
                NodeData corrAncestor = (NodeData)corrDataManager.getItemData(ancestor.getIdentifier());
                if (corrAncestor == null) {
                    throw new ItemNotFoundException("No corresponding path for ancestor " + ancestor.getQPath().getAsString() + " in " + corrSession.getWorkspace().getName());
                }
                NodeData corrNode2 = (NodeData)corrDataManager.getItemData(corrAncestor, myPath.getRelPath(myPath.getDepth() - i));
                if (corrNode2 == null) continue;
                return corrNode2;
            }
        }
        if ((corrNode = (NodeData)corrDataManager.getItemData(myPath)) != null) {
            return corrNode;
        }
        throw new ItemNotFoundException("No corresponding path for " + this.getPath() + " in " + corrSession.getWorkspace().getName());
    }

    public Node getCorrespondingNode(SessionImpl correspSession) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        if (this.isNodeType(Constants.MIX_REFERENCEABLE)) {
            try {
                return correspSession.getNodeByUUID(this.getUUID());
            }
            catch (ItemNotFoundException e) {
            }
        } else {
            for (int i = this.getDepth(); i >= 0; --i) {
                NodeImpl ancestor = (NodeImpl)this.getAncestor(i);
                if (!ancestor.isNodeType(Constants.MIX_REFERENCEABLE)) continue;
                NodeImpl correspAncestor = (NodeImpl)correspSession.getNodeByUUID(ancestor.getUUID());
                JCRPath.PathElement[] relJCRPath = this.getLocation().getRelPath(this.getDepth() - i);
                try {
                    return (NodeImpl)correspAncestor.getNode(this.getRelPath(relJCRPath));
                }
                catch (ItemNotFoundException e) {
                    // empty catch block
                }
            }
        }
        try {
            return (NodeImpl)correspSession.getItem(this.getPath());
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException("No corresponding path for " + this.getPath() + " in " + correspSession.getWorkspace().getName());
        }
    }

    private String getRelPath(JCRPath.PathElement[] relPath) throws RepositoryException {
        String path = "";
        for (int i = 0; i < relPath.length; ++i) {
            path = path + relPath[i].getAsString(false);
            if (i >= relPath.length - 1) continue;
            path = path + "/";
        }
        return path;
    }

    public void update(String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, InvalidItemStateException, LockException, RepositoryException {
        String srcPath;
        this.checkValid();
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        SessionChangesLog changes = new SessionChangesLog(this.session.getId());
        try {
            srcPath = this.getCorrespondingNodePath(srcWorkspaceName);
            ItemDataRemoveVisitor remover = new ItemDataRemoveVisitor(this.session.getTransientNodesManager(), null, this.session.getWorkspace().getNodeTypeManager(), this.session.getAccessManager(), this.session.getUserState());
            this.nodeData().accept(remover);
            changes.addAll(remover.getRemovedStates());
        }
        catch (ItemNotFoundException e) {
            log.debug((Object)("No corresponding node in workspace: " + srcWorkspaceName));
            return;
        }
        TransactionableDataManager pmanager = this.session.getTransientNodesManager().getTransactManager();
        this.session.getWorkspace().clone(srcWorkspaceName, srcPath, this.getPath(), true, changes);
        pmanager.save(changes);
        NodeData thisParent = (NodeData)this.session.getTransientNodesManager().getItemData(this.getParentIdentifier());
        QPathEntry[] qpath = this.getInternalPath().getEntries();
        NodeData thisNew = (NodeData)pmanager.getItemData(thisParent, qpath[qpath.length - 1]);
        this.session.getTransientNodesManager().getItemsPool().reload(this.getInternalIdentifier(), thisNew);
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.checkValid();
        InternalQName name = this.locationFactory.parseJCRName(mixinName).getInternalName();
        this.doAddMixin(name);
    }

    public void doAddMixin(InternalQName mixinName) throws NoSuchNodeTypeException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        ItemState state;
        ExtendedNodeType type = this.nodeType(mixinName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node.addMixin " + (Object)((Object)mixinName) + " " + this.getPath()));
        }
        if (type == null || !type.isMixin()) {
            throw new NoSuchNodeTypeException("Node Type " + (Object)((Object)mixinName) + " not found or not mixin type.");
        }
        if (this.hasSameOrSubtypeMixin(type)) {
            throw new ConstraintViolationException("Can not add mixin type " + (Object)((Object)mixinName) + " to " + this.getPath());
        }
        if (this.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can not add mixin type. Node is protected " + this.getPath());
        }
        if (!this.checkedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        InternalQName[] mixinTypes = this.nodeData().getMixinTypeNames();
        for (int i = 0; i < mixinTypes.length; ++i) {
            if (!type.equals(this.nodeType(mixinTypes[i]))) continue;
            log.warn((Object)("Node.addMixin node already has this mixin type " + (Object)((Object)mixinName) + " " + this.getPath()));
            return;
        }
        ArrayList<InternalQName> newMixin = new ArrayList<InternalQName>(mixinTypes.length + 1);
        ArrayList<ValueData> values = new ArrayList<ValueData>(mixinTypes.length + 1);
        for (int i = 0; i < mixinTypes.length; ++i) {
            InternalQName cn = mixinTypes[i];
            newMixin.add(cn);
            values.add(new TransientValueData(cn));
        }
        newMixin.add(mixinName);
        values.add(new TransientValueData(mixinName));
        TransientPropertyData prop = (TransientPropertyData)this.dataManager.getItemData((NodeData)this.getData(), new QPathEntry(Constants.JCR_MIXINTYPES, 0));
        if (prop != null) {
            prop = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
            prop.setValues(values);
            state = ItemState.createUpdatedState(prop);
        } else {
            prop = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_MIXINTYPES, 7, true, values);
            state = ItemState.createAddedState(prop);
        }
        this.updateMixin(newMixin);
        this.dataManager.update(state, false);
        this.addAutoCreatedItems(mixinName, false);
        this.session.getActionHandler().postAddMixin(this, mixinName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node.addMixin Property " + prop.getQPath().getAsString() + " values " + mixinTypes.length));
        }
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        InternalQName[] mixinTypes = this.nodeData().getMixinTypeNames();
        InternalQName name = this.locationFactory.parseJCRName(mixinName).getInternalName();
        InternalQName removedName = null;
        ArrayList<InternalQName> newMixin = new ArrayList<InternalQName>();
        ArrayList<ValueData> values = new ArrayList<ValueData>();
        for (InternalQName mt : mixinTypes) {
            if (mt.equals((Object)name)) {
                removedName = mt;
                continue;
            }
            newMixin.add(mt);
            values.add(new TransientValueData(mt));
        }
        if (removedName == null) {
            throw new NoSuchNodeTypeException("No mixin type found " + mixinName + " for node " + this.getPath());
        }
        if (!this.checkedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        this.session.getActionHandler().preRemoveMixin(this, name);
        TransientPropertyData prop = (TransientPropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_MIXINTYPES, 0));
        prop.setValues(values);
        if (this.session.getWorkspace().getNodeTypeManager().isNodeType(Constants.MIX_VERSIONABLE, removedName)) {
            this.removeVersionable();
        }
        if (this.session.getWorkspace().getNodeTypeManager().isNodeType(Constants.MIX_LOCKABLE, removedName)) {
            this.removeLockable();
        }
        this.updateMixin(newMixin);
        QPath ancestorToSave = this.nodeData().getQPath();
        ExtendedNodeType removed = this.session.getWorkspace().getNodeTypeManager().findNodeType(removedName);
        for (PropertyDefinition propertyDefinition : removed.getPropertyDefinitions()) {
            InternalQName pdName = ((PropertyDefinitionImpl)propertyDefinition).getQName();
            ItemData p = this.dataManager.getItemData(this.nodeData(), new QPathEntry(pdName, 1));
            if (p == null || p.isNode()) continue;
            this.dataManager.delete(p, ancestorToSave);
        }
        for (PropertyDefinition propertyDefinition : removed.getChildNodeDefinitions()) {
            InternalQName ndName = ((NodeDefinitionImpl)propertyDefinition).getQName();
            ItemData n = this.dataManager.getItemData(this.nodeData(), new QPathEntry(ndName, 1));
            if (n == null || !n.isNode()) continue;
            ItemDataRemoveVisitor remover = new ItemDataRemoveVisitor((ItemDataConsumer)this.dataManager, ancestorToSave);
            n.accept(remover);
            for (ItemState deleted : remover.getRemovedStates()) {
                this.dataManager.delete(deleted.getData(), ancestorToSave);
            }
        }
        if (newMixin.size() > 0) {
            this.dataManager.update(new ItemState(prop, 2, true, ancestorToSave), false);
        } else {
            this.dataManager.delete(prop, ancestorToSave);
        }
    }

    private void updateMixin(List<InternalQName> newMixin) throws RepositoryException {
        InternalQName[] mixins = new InternalQName[newMixin.size()];
        newMixin.toArray(mixins);
        ((TransientNodeData)this.data).setMixinTypeNames(mixins);
        this.dataManager.update(new ItemState(this.data, 16, false, null), false);
    }

    public boolean canAddMixin(String mixinName) throws RepositoryException {
        this.checkValid();
        if (this.hasSameOrSubtypeMixin(this.nodeType(this.locationFactory.parseJCRName(mixinName).getInternalName()))) {
            return false;
        }
        if (this.getDefinition().isProtected()) {
            return false;
        }
        if (!this.checkedOut()) {
            return false;
        }
        return this.checkLocking();
    }

    private boolean hasSameOrSubtypeMixin(ExtendedNodeType type) throws RepositoryException, ValueFormatException {
        InternalQName[] mixinTypes = this.nodeData().getMixinTypeNames();
        for (int i = 0; i < mixinTypes.length; ++i) {
            if (!NodeTypeImpl.isSameOrSubType(type, this.nodeType(mixinTypes[i]))) continue;
            return true;
        }
        return false;
    }

    protected void removeLockable() throws RepositoryException {
        if (this.session.getLockManager().holdsLock(this.nodeData())) {
            if (!this.session.getLockManager().isLockHolder(this)) {
                throw new LockException("There are no permission to unlock the node " + this.getPath());
            }
            this.doUnlock();
        }
    }

    protected void doOrderBefore(QPath srcPath, QPath destPath) throws RepositoryException {
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException("child node ordering not supported on node " + this.getPath());
        }
        if (srcPath.equals(destPath)) {
            return;
        }
        if (this.dataManager.getItemData(srcPath) == null) {
            throw new ItemNotFoundException(this.getPath() + " has no child node with name " + srcPath.getName().getAsString());
        }
        if (destPath != null && this.dataManager.getItemData(destPath) == null) {
            throw new ItemNotFoundException(this.getPath() + " has no child node with name " + destPath.getName().getAsString());
        }
        if (!this.checkedOut()) {
            throw new VersionException(" cannot change child node ordering of a checked-in node ");
        }
        if (destPath != null && srcPath.getDepth() != destPath.getDepth()) {
            throw new ItemNotFoundException("Source and destenation is not relative paths of depth one, i.e. is not a childs of same parent node");
        }
        List<NodeData> siblings = this.dataManager.getChildNodesData(this.nodeData());
        Collections.sort(siblings, new NodeDataOrderComparator());
        if (siblings.size() < 2) {
            throw new UnsupportedRepositoryOperationException("Nothing to order Count of child nodes " + siblings.size());
        }
        int srcInd = -1;
        int destInd = -1;
        for (int i = 0; i < siblings.size(); ++i) {
            NodeData nodeData = siblings.get(i);
            if (srcInd == -1 && nodeData.getQPath().getName().equals((Object)srcPath.getName()) && (nodeData.getQPath().getIndex() == srcPath.getIndex() || srcPath.getIndex() == 0 && nodeData.getQPath().getIndex() == 1)) {
                srcInd = i;
            }
            if (destInd == -1 && destPath != null) {
                if (!nodeData.getQPath().getName().equals((Object)destPath.getName()) || nodeData.getQPath().getIndex() != destPath.getIndex() && (destPath.getIndex() != 0 || nodeData.getQPath().getIndex() != 1)) continue;
                destInd = i;
                if (srcInd == -1) continue;
                break;
            }
            if (srcInd != -1) break;
        }
        if (destInd == -1 ? srcInd == siblings.size() - 1 : destInd - srcInd == 1) {
            return;
        }
        if (destInd == -1) {
            siblings.add(siblings.remove(srcInd));
        } else if (srcInd < destInd) {
            siblings.add(destInd, siblings.get(srcInd));
            siblings.remove(srcInd);
        } else {
            siblings.add(destInd, siblings.remove(srcInd));
        }
        int sameNameIndex = 0;
        ArrayList<ItemState> changes = new ArrayList<ItemState>();
        ItemState deleteState = null;
        for (int j = 0; j < siblings.size(); ++j) {
            NodeData sdata = siblings.get(j);
            if (sdata.getQPath().getName().equals((Object)srcPath.getName())) {
                ++sameNameIndex;
            }
            if (sdata.getOrderNumber() == j) continue;
            NodeData newData = sdata;
            if (sdata.getQPath().getName().equals((Object)srcPath.getName()) && sdata.getQPath().getIndex() != sameNameIndex) {
                newData = ((TransientNodeData)sdata).cloneAsSibling(sameNameIndex);
            }
            ((TransientNodeData)newData).setOrderNumber(j);
            if (sdata.getQPath().equals(srcPath)) {
                deleteState = new ItemState(sdata, 4, true, null, false, false);
                changes.add(new ItemState(newData, 2, true, null, false, true));
                continue;
            }
            ItemState state = ItemState.createUpdatedState(newData);
            state.eraseEventFire();
            changes.add(state);
        }
        this.dataManager.getChangesLog().add(deleteState);
        this.dataManager.getChangesLog().addAll(changes);
    }

    public void orderBefore(String srcName, String destName) throws UnsupportedRepositoryOperationException, ConstraintViolationException, ItemNotFoundException, RepositoryException {
        this.checkValid();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException("Node does not support child ordering " + this.getPrimaryNodeType().getName());
        }
        JCRPath sourcePath = this.locationFactory.createJCRPath(this.getLocation(), srcName);
        JCRPath destenationPath = destName != null ? this.locationFactory.createJCRPath(this.getLocation(), destName) : null;
        QPath srcPath = sourcePath.getInternalPath();
        QPath destPath = destenationPath != null ? destenationPath.getInternalPath() : null;
        this.doOrderBefore(srcPath, destPath);
    }

    private int getOrderNumber() {
        return this.nodeData().getOrderNumber();
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node.checkin() is not supported for not mix:versionable node ");
        }
        if (!this.checkedOut()) {
            return (Version)this.dataManager.getItemByIdentifier(this.property(Constants.JCR_BASEVERSION).getString(), false);
        }
        if (this.session.getTransientNodesManager().hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending changes " + this.getPath());
        }
        if (this.hasProperty(Constants.JCR_MERGEFAILED)) {
            throw new VersionException("Node has jcr:mergeFailed " + this.getPath());
        }
        if (!this.parent().checkLocking()) {
            throw new LockException("Node " + this.parent().getPath() + " is locked ");
        }
        String verIdentifier = IdGenerator.generate();
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        VersionHistoryImpl vh = this.versionHistory(false);
        vh.addVersion(this.nodeData(), verIdentifier, changesLog);
        changesLog.add(ItemState.createUpdatedState(this.updatePropertyData(Constants.JCR_ISCHECKEDOUT, new TransientValueData(false))));
        changesLog.add(ItemState.createUpdatedState(this.updatePropertyData(Constants.JCR_BASEVERSION, new TransientValueData(new Identifier(verIdentifier)))));
        changesLog.add(ItemState.createUpdatedState(this.updatePropertyData(Constants.JCR_PREDECESSORS, new ArrayList<ValueData>())));
        this.dataManager.getTransactManager().save(changesLog);
        VersionImpl version = (VersionImpl)this.dataManager.getItemByIdentifier(verIdentifier, true);
        this.session.getActionHandler().postCheckin(this);
        return version;
    }

    public void checkout() throws RepositoryException, UnsupportedRepositoryOperationException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node.checkout() is not supported for not mix:versionable node ");
        }
        if (this.checkedOut()) {
            return;
        }
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        changesLog.add(ItemState.createUpdatedState(this.updatePropertyData(Constants.JCR_ISCHECKEDOUT, new TransientValueData(true))));
        ValueData baseVersion = ((PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_BASEVERSION, 0))).getValues().get(0);
        changesLog.add(ItemState.createUpdatedState(this.updatePropertyData(Constants.JCR_PREDECESSORS, baseVersion)));
        this.dataManager.getTransactManager().save(changesLog);
        this.session.getActionHandler().postCheckout(this);
    }

    public boolean isCheckedOut() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        return this.checkedOut();
    }

    public boolean checkedOut() throws UnsupportedRepositoryOperationException, RepositoryException {
        NodeData vancestor = this.getVersionableAncestor();
        if (vancestor != null) {
            PropertyData isCheckedOut = (PropertyData)this.dataManager.getItemData(vancestor, new QPathEntry(Constants.JCR_ISCHECKEDOUT, 1));
            try {
                return ValueDataConvertor.readBoolean(isCheckedOut.getValues().get(0));
            }
            catch (IOException e) {
                throw new RepositoryException("Can't read property " + this.locationFactory.createJCRPath(vancestor.getQPath()).getAsString(false) + "/jcr:isCheckedOut. " + e, (Throwable)e);
            }
        }
        return true;
    }

    public NodeData getVersionableAncestor() throws RepositoryException {
        NodeData node = this.nodeData();
        NodeTypeManagerImpl ntman = this.session.getWorkspace().getNodeTypeManager();
        while (node.getParentIdentifier() != null) {
            if (ntman.isNodeType(Constants.MIX_VERSIONABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
                return node;
            }
            NodeData ancestor = (NodeData)this.dataManager.getItemData(node.getParentIdentifier());
            if (ancestor == null) {
                throw new RepositoryException("Parent not found for " + this.locationFactory.createJCRPath(node.getQPath()).getAsString(false) + ". Parent id " + node.getParentIdentifier());
            }
            node = ancestor;
        }
        return null;
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        return this.versionHistory(true);
    }

    public VersionHistoryImpl versionHistory(boolean pool) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node is not mix:versionable " + this.getPath());
        }
        PropertyData vhProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_VERSIONHISTORY, 1));
        if (vhProp == null) {
            throw new UnsupportedRepositoryOperationException("Node does not have jcr:versionHistory " + this.getPath());
        }
        try {
            return (VersionHistoryImpl)this.dataManager.getItemByIdentifier(new String(vhProp.getValues().get(0).getAsByteArray()), pool);
        }
        catch (IOException e) {
            throw new RepositoryException("Error of version history ID read " + e, (Throwable)e);
        }
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node is not versionable " + this.getPath());
        }
        PropertyData bvProp = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_BASEVERSION, 1));
        try {
            return (Version)this.session.getNodeByUUID(ValueDataConvertor.readString(bvProp.getValues().get(0)));
        }
        catch (IOException e) {
            throw new RepositoryException("jcr:baseVersion property error " + e, (Throwable)e);
        }
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node is not versionable " + this.getPath());
        }
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        if (((VersionImpl)version).getInternalName().equals((Object)Constants.JCR_ROOTVERSION)) {
            throw new VersionException("It is illegal to call restore() on jcr:rootVersion");
        }
        if (!this.versionHistory(false).isVersionBelongToThis(version)) {
            throw new VersionException("Bad version " + version.getPath());
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        NodeData destParent = (NodeData)this.dataManager.getItemData(this.nodeData().getParentIdentifier());
        ((VersionImpl)version).restore(this.getSession(), destParent, this.nodeData().getQPath().getName(), removeExisting);
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        VersionImpl version = (VersionImpl)this.versionHistory(false).version(versionName, false);
        this.restore(version, removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        if (".".equals(relPath)) {
            this.restore(version, removeExisting);
        } else {
            this.checkValid();
            if (this.session.hasPendingChanges()) {
                throw new InvalidItemStateException("Session has pending changes ");
            }
            if (((VersionImpl)version).getInternalName().equals((Object)Constants.JCR_ROOTVERSION)) {
                throw new VersionException("It is illegal to call restore() on jcr:rootVersion");
            }
            QPath destPath = this.locationFactory.parseRelPath(relPath).getInternalPath();
            NodeImpl destParent = (NodeImpl)this.dataManager.getItem(this.nodeData(), destPath.makeParentPath().getEntries(), false);
            if (destParent == null) {
                throw new PathNotFoundException("Parent not found for " + relPath);
            }
            if (!destParent.isNode()) {
                throw new ConstraintViolationException("Parent item is not a node. Rel path " + relPath);
            }
            NodeImpl destNode = (NodeImpl)this.dataManager.getItem(destParent.nodeData(), new QPathEntry(destPath.getName(), destPath.getIndex()), false);
            if (destNode != null) {
                if (!destNode.isNode()) {
                    throw new ConstraintViolationException("Item at relPath is not a node " + destNode.getPath());
                }
                if (!destNode.isNodeType(Constants.MIX_VERSIONABLE)) {
                    throw new UnsupportedRepositoryOperationException("Node at relPath is not versionable " + destNode.getPath());
                }
                if (!destNode.versionHistory(false).isVersionBelongToThis(version)) {
                    throw new VersionException("Bad version " + version.getPath());
                }
                if (!destNode.parent().checkLocking()) {
                    throw new LockException("Node " + destNode.getPath() + " is locked ");
                }
            } else if (!destParent.checkedOut()) {
                throw new VersionException("Parent of a node at relPath is versionable and checked-in " + destNode.getPath());
            }
            ((VersionImpl)version).restore(this.session, destParent.nodeData(), destPath.getName(), removeExisting);
        }
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        VersionImpl version = (VersionImpl)this.getVersionHistory().getVersionByLabel(versionLabel);
        this.restore(version, removeExisting);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws UnsupportedRepositoryOperationException, NoSuchWorkspaceException, AccessDeniedException, MergeException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        HashMap<String, String> failed = new HashMap<String, String>();
        SessionImpl corrSession = ((RepositoryImpl)this.session.getRepository()).internalLogin(this.session.getUserState(), srcWorkspace);
        ItemDataMergeVisitor visitor = new ItemDataMergeVisitor(this.session, corrSession, failed, bestEffort);
        this.nodeData().accept(visitor);
        SessionChangesLog changes = visitor.getMergeChanges();
        EntityCollection failedIter = this.createMergeFailed(failed, changes);
        if (changes.getSize() > 0) {
            this.dataManager.getTransactManager().save(changes);
        }
        return failedIter;
    }

    private EntityCollection createMergeFailed(Map<String, String> failed, SessionChangesLog changes) throws RepositoryException {
        EntityCollection res = new EntityCollection();
        TransientPropertyData mergeFailed = (TransientPropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_MERGEFAILED, 0));
        ArrayList<ValueData> mergeFailedRefs = null;
        int state = 0;
        if (mergeFailed != null) {
            mergeFailed = mergeFailed.clone();
            mergeFailedRefs = mergeFailed.getValues();
            state = 2;
        } else {
            mergeFailedRefs = new ArrayList();
            mergeFailed = TransientPropertyData.createPropertyData((NodeData)this.getData(), Constants.JCR_MERGEFAILED, 9, true, mergeFailedRefs);
            state = 1;
        }
        block2: for (String identifier : failed.keySet()) {
            NodeImpl versionable = (NodeImpl)this.session.getNodeByUUID(identifier);
            res.add(versionable);
            String offendingIdentifier = failed.get(identifier);
            for (ValueData vd : mergeFailedRefs) {
                try {
                    String mfIdentifier = new String(vd.getAsByteArray());
                    if (!mfIdentifier.equals(offendingIdentifier)) continue;
                    continue block2;
                }
                catch (IOException e) {
                    throw new RepositoryException("jcr:mergeFailed read error " + e, (Throwable)e);
                }
            }
            mergeFailedRefs.add(new TransientValueData(offendingIdentifier));
        }
        changes.add(new ItemState(mergeFailed, state, true, this.getInternalPath(), true));
        return res;
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl(this.session.getId());
        VersionImpl base = (VersionImpl)this.getBaseVersion();
        base.addPredecessor(version.getUUID(), changesLog);
        this.removeMergeFailed(version, changesLog);
        this.dataManager.getTransactManager().save(changesLog);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl(this.session.getId());
        this.removeMergeFailed(version, changesLog);
        this.dataManager.getTransactManager().save(changesLog);
    }

    private void removeMergeFailed(Version version, PlainChangesLog changesLog) throws RepositoryException {
        TransientPropertyData mergeFailed = (TransientPropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_MERGEFAILED, 0));
        if (mergeFailed == null) {
            return;
        }
        ArrayList<ValueData> mf = new ArrayList<ValueData>();
        for (ValueData mfvd : mergeFailed.getValues()) {
            try {
                String mfIdentifier = new String(mfvd.getAsByteArray());
                if (mfIdentifier.equals(version.getUUID())) continue;
                mf.add(mfvd);
            }
            catch (IOException e) {
                throw new RepositoryException("Remove jcr:mergeFailed error " + e, (Throwable)e);
            }
        }
        if (mf.size() > 0) {
            TransientPropertyData mergeFailedRef = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_MERGEFAILED, 9, true, mf);
            changesLog.add(ItemState.createUpdatedState(mergeFailedRef));
        } else {
            changesLog.add(ItemState.createDeletedState(mergeFailed.clone(), true));
        }
    }

    @Override
    public Lock lock(boolean isDeep, long timeOut) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_LOCKABLE)) {
            throw new LockException("Node is not lockable " + this.getPath());
        }
        if (this.dataManager.hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending unsaved changes " + this.getPath());
        }
        Lock newLock = this.session.getLockManager().addPendingLock(this, isDeep, false, timeOut);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), this.session.getId(), 0x400000);
        TransientPropertyData propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKOWNER, 1, false, new TransientValueData(this.session.getUserID()));
        changesLog.add(ItemState.createAddedState(propData));
        propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKISDEEP, 6, false, new TransientValueData(isDeep));
        changesLog.add(ItemState.createAddedState(propData));
        this.dataManager.getTransactManager().save(changesLog);
        this.session.getActionHandler().postLock(this);
        return newLock;
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_LOCKABLE)) {
            throw new LockException("Node is not lockable " + this.getPath());
        }
        if (this.dataManager.hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending unsaved changes " + this.getPath());
        }
        Lock newLock = this.session.getLockManager().addPendingLock(this, isDeep, isSessionScoped, -1L);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), this.session.getId(), 0x400000);
        TransientPropertyData propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKOWNER, 1, false, new TransientValueData(this.session.getUserID()));
        changesLog.add(ItemState.createAddedState(propData));
        propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKISDEEP, 6, false, new TransientValueData(isDeep));
        changesLog.add(ItemState.createAddedState(propData));
        this.dataManager.getTransactManager().save(changesLog);
        this.session.getActionHandler().postLock(this);
        return newLock;
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkValid();
        LockImpl lock = this.session.getLockManager().getLock(this);
        if (lock == null) {
            throw new LockException("Lock not found " + this.getPath());
        }
        return lock;
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkValid();
        if (!this.session.getLockManager().holdsLock((NodeData)this.getData())) {
            throw new LockException("The node not locked " + this.getPath());
        }
        if (!this.session.getLockManager().isLockHolder(this)) {
            throw new LockException("There are no permission to unlock the node " + this.getPath());
        }
        if (this.dataManager.hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending unsaved changes " + this.getPath());
        }
        this.doUnlock();
        this.session.getActionHandler().postUnlock(this);
    }

    protected void doUnlock() throws RepositoryException {
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), this.session.getId(), 0x800000);
        ItemData lockOwner = this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_LOCKOWNER, 0));
        changesLog.add(ItemState.createDeletedState(lockOwner));
        ItemData lockIsDeep = this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.JCR_LOCKISDEEP, 0));
        changesLog.add(ItemState.createDeletedState(lockIsDeep));
        this.dataManager.getTransactManager().save(changesLog);
    }

    public boolean holdsLock() throws RepositoryException {
        this.checkValid();
        return this.session.getLockManager().holdsLock((NodeData)this.getData());
    }

    public boolean isLocked() throws RepositoryException {
        this.checkValid();
        return this.session.getLockManager().isLocked((NodeData)this.getData());
    }

    boolean checkLocking() throws RepositoryException {
        return !this.isLocked() || this.session.getLockManager().isLockHolder(this) || this.session.getUserID().equals(SystemIdentity.SYSTEM);
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.checkValid();
        visitor.visit((Node)this);
    }

    public boolean isNode() {
        return true;
    }

    public void addAutoCreatedItems(InternalQName nodeTypeName, boolean avoidCheckExistedChildItems) throws RepositoryException, ConstraintViolationException {
        this.addAutoCreatedItems(this.nodeData(), nodeTypeName, avoidCheckExistedChildItems);
    }

    public void addAutoCreatedItems(NodeData parent, InternalQName nodeTypeName, boolean avoidCheckExistedChildItems) throws RepositoryException, ConstraintViolationException {
        int i;
        ExtendedNodeType type = this.nodeType(nodeTypeName);
        NodeDefinition[] nodeDefs = type.getChildNodeDefinitions();
        PropertyDefinition[] propDefs = type.getPropertyDefinitions();
        for (i = 0; i < propDefs.length; ++i) {
            ItemData pdata;
            if (propDefs[i] == null || !propDefs[i].isAutoCreated()) continue;
            PropertyDefinitionImpl pdImpl = (PropertyDefinitionImpl)propDefs[i];
            ItemData itemData = pdata = avoidCheckExistedChildItems ? null : this.dataManager.getItemData(parent, new QPathEntry(pdImpl.getQName(), 0));
            if (pdata == null || pdata.isNode()) {
                List<ValueData> listAutoCreateValue = this.autoCreatedValue(parent, type, pdImpl);
                if (listAutoCreateValue == null) continue;
                this.dataManager.update(ItemState.createAddedState(TransientPropertyData.createPropertyData(parent, pdImpl.getQName(), pdImpl.getRequiredType(), pdImpl.isMultiple(), listAutoCreateValue)), false);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Skipping existed property " + pdImpl.getName() + " in " + this.getPath() + "   during the automatic creation of items for " + nodeTypeName.getAsString() + " nodetype or mixin type"));
        }
        for (i = 0; i < nodeDefs.length; ++i) {
            if (!nodeDefs[i].isAutoCreated()) continue;
            NodeDefinitionImpl ndImpl = (NodeDefinitionImpl)nodeDefs[i];
            TransientNodeData childNodeData = TransientNodeData.createNodeData(parent, ndImpl.getQName(), ((ExtendedNodeType)ndImpl.getDefaultPrimaryType()).getQName(), IdGenerator.generate());
            this.dataManager.update(ItemState.createAddedState(childNodeData), false);
            this.addAutoCreatedItems(childNodeData, childNodeData.getPrimaryTypeName(), avoidCheckExistedChildItems);
        }
        if (type.isNodeType(Constants.MIX_VERSIONABLE)) {
            PlainChangesLogImpl changes = new PlainChangesLogImpl();
            new VersionHistoryDataHelper(parent, changes, this.dataManager, this.session.getWorkspace().getNodeTypeManager());
            for (ItemState istate : changes.getAllStates()) {
                this.dataManager.update(istate, false);
            }
        }
    }

    private List<ValueData> autoCreatedValue(NodeData parent, ExtendedNodeType type, PropertyDefinitionImpl def) throws RepositoryException {
        ArrayList<ValueData> vals = new ArrayList<ValueData>();
        if (type.isNodeType(Constants.NT_BASE) && def.getQName().equals((Object)Constants.JCR_PRIMARYTYPE)) {
            vals.add(new TransientValueData(parent.getPrimaryTypeName()));
        } else if (type.isNodeType(Constants.MIX_REFERENCEABLE) && def.getQName().equals((Object)Constants.JCR_UUID)) {
            vals.add(new TransientValueData(parent.getIdentifier()));
        } else if (type.isNodeType(Constants.NT_HIERARCHYNODE) && def.getQName().equals((Object)Constants.JCR_CREATED)) {
            vals.add(new TransientValueData(this.dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
        } else if (type.isNodeType(Constants.EXO_OWNEABLE) && def.getQName().equals((Object)Constants.EXO_OWNER)) {
            String owner = this.session.getUserID();
            vals.add(new TransientValueData(owner));
            this.setACL(new AccessControlList(owner, this.getACL().getPermissionEntries()));
        } else if (type.isNodeType(Constants.EXO_PRIVILEGEABLE) && def.getQName().equals((Object)Constants.EXO_PERMISSIONS)) {
            for (AccessControlEntry ace : parent.getACL().getPermissionEntries()) {
                vals.add(new TransientValueData(ace));
            }
        } else {
            Value[] propVal = def.getDefaultValues();
            if (propVal != null) {
                for (Value v : propVal) {
                    if (v != null) {
                        vals.add(((BaseValue)v).getInternalData());
                        continue;
                    }
                    vals.add(null);
                }
            } else {
                return null;
            }
        }
        return vals;
    }

    public String[] getMixinTypeNames() throws RepositoryException {
        NodeType[] mixinTypes = this.getMixinNodeTypes();
        String[] mtNames = new String[mixinTypes.length];
        for (int i = 0; i < mtNames.length; ++i) {
            mtNames[i] = mixinTypes[i].getName();
        }
        return mtNames;
    }

    public void validateMandatoryChildren() throws ConstraintViolationException, AccessDeniedException, RepositoryException {
        ArrayList<ItemDefinition> mandatoryItemDefs = ((ExtendedNodeType)this.getPrimaryNodeType()).getManadatoryItemDefs();
        NodeType[] mixinTypes = this.getMixinNodeTypes();
        for (int i = 0; i < mixinTypes.length; ++i) {
            mandatoryItemDefs.addAll(((ExtendedNodeType)mixinTypes[i]).getManadatoryItemDefs());
        }
        for (ItemDefinition def : mandatoryItemDefs) {
            InternalQName defName = null;
            defName = def instanceof NodeDefinitionImpl ? ((NodeDefinitionImpl)def).getQName() : ((PropertyDefinitionImpl)def).getQName();
            if (this.getSession().getTransientNodesManager().getItemData(this.nodeData(), new QPathEntry(defName, 0)) != null) continue;
            throw new ConstraintViolationException("Mandatory item " + def.getName() + " not found. Node [" + this.getPath() + " primary type: " + this.getPrimaryNodeType().getName() + "]");
        }
    }

    private int getNextChildOrderNum() throws RepositoryException {
        return this.dataManager.getChildNodesCount(this.nodeData());
    }

    private int getNextChildIndex(InternalQName nameToAdd, NodeData parentNode) throws RepositoryException, ItemExistsException {
        NodeDefinitionImpl def = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(nameToAdd, parentNode.getPrimaryTypeName(), parentNode.getMixinTypeNames());
        boolean allowSns = def.allowsSameNameSiblings();
        int ind = 1;
        NodeData sibling = (NodeData)this.dataManager.getItemData(parentNode, new QPathEntry(nameToAdd, ind));
        while (sibling != null) {
            if (allowSns) {
                sibling = (NodeData)this.dataManager.getItemData(parentNode, new QPathEntry(nameToAdd, ++ind));
                continue;
            }
            throw new ItemExistsException("The node " + (Object)((Object)nameToAdd) + " already exists in " + this.getPath() + " and same name sibling is not allowed ");
        }
        return ind;
    }

    public void setPermissions(Map permissions) throws RepositoryException, AccessDeniedException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        if (permissions.size() == 0) {
            throw new RepositoryException("Permission map size cannot be 0");
        }
        this.checkPermission("add_node,set_property,remove");
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
        for (String identity : permissions.keySet()) {
            if (identity == null) {
                throw new RepositoryException("Identity cannot be null");
            }
            String[] perm = (String[])permissions.get(identity);
            if (perm == null) {
                throw new RepositoryException("Permissions cannot be null");
            }
            for (int j = 0; j < perm.length; ++j) {
                AccessControlEntry ace = new AccessControlEntry(identity, perm[j]);
                aces.add(ace);
            }
        }
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), aces);
        this.updatePermissions(acl);
        this.setACL(acl);
    }

    private void updatePermissions(AccessControlList acl) throws RepositoryException {
        ArrayList<ValueData> permValues = new ArrayList<ValueData>();
        List<AccessControlEntry> aces = acl.getPermissionEntries();
        for (AccessControlEntry ace : aces) {
            TransientValueData vd = new TransientValueData(ace);
            permValues.add(vd);
        }
        TransientPropertyData permProp = (TransientPropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(Constants.EXO_PERMISSIONS, 0));
        permProp = new TransientPropertyData(permProp.getQPath(), permProp.getIdentifier(), permProp.getPersistedVersion(), permProp.getType(), permProp.getParentIdentifier(), permProp.isMultiValued());
        permProp.setValues(permValues);
        this.dataManager.update(new ItemState(this.data, 16, false, null, true), false);
        this.dataManager.update(ItemState.createUpdatedState(permProp, true), false);
    }

    @Override
    public AccessControlList getACL() throws RepositoryException {
        this.checkValid();
        ArrayList<AccessControlEntry> listEntry = new ArrayList<AccessControlEntry>();
        for (AccessControlEntry aEntry : this.nodeData().getACL().getPermissionEntries()) {
            listEntry.add(new AccessControlEntry(aEntry.getIdentity(), aEntry.getPermission()));
        }
        return new AccessControlList(this.nodeData().getACL().getOwner(), listEntry);
    }

    private void setACL(AccessControlList acl) {
        ((NodeData)this.data).setACL(acl);
    }

    @Override
    public void clearACL() throws RepositoryException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        this.checkPermission("add_node,set_property,remove");
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
        for (String perm : PermissionType.ALL) {
            AccessControlEntry ace = new AccessControlEntry(SystemIdentity.ANY, perm);
            aces.add(ace);
        }
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), aces);
        this.setACL(acl);
    }

    @Override
    public void removePermission(String identity) throws RepositoryException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        this.checkPermission("add_node,set_property,remove");
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), this.getACL().getPermissionEntries());
        acl.removePermissions(identity);
        this.updatePermissions(acl);
        this.setACL(acl);
    }

    @Override
    public void removePermission(String identity, String permission) throws RepositoryException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        this.checkPermission("add_node,set_property,remove");
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), this.getACL().getPermissionEntries());
        acl.removePermissions(identity, permission);
        this.updatePermissions(acl);
        this.setACL(acl);
    }

    @Override
    public void setPermission(String identity, String[] permission) throws RepositoryException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        if (identity == null) {
            throw new RepositoryException("Identity cannot be null");
        }
        if (permission == null) {
            throw new RepositoryException("Permission cannot be null");
        }
        this.checkPermission("add_node,set_property,remove");
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), this.getACL().getPermissionEntries());
        acl.removePermissions(identity);
        acl.addPermissions(identity, permission);
        this.updatePermissions(acl);
        this.setACL(acl);
    }

    @Override
    public void checkPermission(String actions) throws AccessControlException, RepositoryException {
        this.checkValid();
        if (!this.session.getAccessManager().hasPermission(this.getACL(), actions, this.session.getUserState().getIdentity())) {
            throw new AccessControlException("Permission denied " + this.getPath() + " : " + actions);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NodeImpl) {
            NodeImpl otherNode = (NodeImpl)obj;
            if (!otherNode.isValid() || !this.isValid()) {
                return false;
            }
            try {
                if (otherNode.isNodeType("mix:referenceable") && this.isNodeType("mix:referenceable")) {
                    return this.getInternalIdentifier().equals(otherNode.getInternalIdentifier());
                }
                return this.getLocation().equals(otherNode.getLocation());
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return false;
    }

    private ExtendedNodeType nodeType(InternalQName qName) throws NoSuchNodeTypeException, RepositoryException {
        return this.session.getWorkspace().getNodeTypeManager().getNodeType(qName);
    }

    public ExtendedNodeType[] getAllNodeTypes() throws RepositoryException {
        return this.nodeTypes(this.nodeData());
    }

    protected NodeData nodeData() {
        return (NodeData)this.data;
    }

    protected PropertyData updatePropertyData(InternalQName name, ValueData value) throws RepositoryException {
        PropertyData existed = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(name, 0));
        if (existed == null) {
            throw new RepositoryException("Property data is not found " + name.getAsString() + " for node " + this.nodeData().getQPath().getAsString());
        }
        TransientPropertyData tdata = new TransientPropertyData(QPath.makeChildPath(this.getInternalPath(), name), existed.getIdentifier(), existed.getPersistedVersion(), existed.getType(), existed.getParentIdentifier(), existed.isMultiValued());
        tdata.setValue(value);
        return tdata;
    }

    protected PropertyData updatePropertyData(InternalQName name, List<ValueData> values) throws RepositoryException {
        PropertyData existed = (PropertyData)this.dataManager.getItemData(this.nodeData(), new QPathEntry(name, 0));
        if (existed == null) {
            throw new RepositoryException("Property data is not found " + name.getAsString() + " for node " + this.nodeData().getQPath().getAsString());
        }
        TransientPropertyData tdata = new TransientPropertyData(QPath.makeChildPath(this.getInternalPath(), name), existed.getIdentifier(), existed.getPersistedVersion(), existed.getType(), existed.getParentIdentifier(), existed.isMultiValued());
        if (!existed.isMultiValued()) {
            throw new ValueFormatException("An existed property is single-valued " + name.getAsString());
        }
        tdata.setValues(values);
        return tdata;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeDataOrderComparator
    implements Comparator<NodeData> {
        private NodeDataOrderComparator() {
        }

        @Override
        public int compare(NodeData n1, NodeData n2) {
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertiesOrderComparator
    implements Comparator<PropertyImpl> {
        private PropertiesOrderComparator() {
        }

        @Override
        public int compare(PropertyImpl p1, PropertyImpl p2) {
            int r = 0;
            try {
                InternalQName qname1 = p1.getLocation().getName().getInternalName();
                InternalQName qname2 = p2.getLocation().getName().getInternalName();
                r = qname1.equals((Object)Constants.JCR_PRIMARYTYPE) ? Integer.MIN_VALUE : (qname2.equals((Object)Constants.JCR_PRIMARYTYPE) ? Integer.MAX_VALUE : (qname1.equals((Object)Constants.JCR_MIXINTYPES) ? -2147483647 : (qname2.equals((Object)Constants.JCR_MIXINTYPES) ? 0x7FFFFFFE : (qname1.equals((Object)Constants.JCR_UUID) ? -2147483646 : (qname2.equals((Object)Constants.JCR_UUID) ? 0x7FFFFFFD : qname1.getAsString().compareTo(qname2.getAsString()))))));
            }
            catch (Exception e) {
                log.error((Object)("PropertiesOrderComparator error: " + e), (Throwable)e);
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodesOrderComparator
    implements Comparator<NodeImpl> {
        private NodesOrderComparator() {
        }

        @Override
        public int compare(NodeImpl n1, NodeImpl n2) {
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }
}

