/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.NamingHelper;

public class DatasourceConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private String user;
    private String pass;
    private static final Log log = LogFactory.getLog((Class)DatasourceConnectionProvider.class);

    protected DataSource getDataSource() {
        return this.ds;
    }

    protected void setDataSource(DataSource ds) {
        this.ds = ds;
    }

    public void configure(Properties props) throws HibernateException {
        String jndiName = props.getProperty("hibernate.connection.datasource");
        if (jndiName == null) {
            String msg = "datasource JNDI name was not specified by property hibernate.connection.datasource";
            log.fatal((Object)msg);
            throw new HibernateException(msg);
        }
        this.user = props.getProperty("hibernate.connection.username");
        this.pass = props.getProperty("hibernate.connection.password");
        try {
            this.ds = (DataSource)NamingHelper.getInitialContext(props).lookup(jndiName);
        }
        catch (Exception e) {
            log.fatal((Object)("Could not find datasource: " + jndiName), (Throwable)e);
            throw new HibernateException("Could not find datasource", e);
        }
        if (this.ds == null) {
            throw new HibernateException("Could not find datasource: " + jndiName);
        }
        log.info((Object)("Using datasource: " + jndiName));
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null || this.pass != null) {
            return this.ds.getConnection(this.user, this.pass);
        }
        return this.ds.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void close() {
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

