/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.document.impl.BaseDocumentReader;

public class TextPlainDocumentReader
extends BaseDocumentReader {
    public static final String DEFAULT_ENCODING = "defaultEncoding";
    private String defaultEncoding;

    public TextPlainDocumentReader(InitParams params) {
        ValuesParam encoding = (ValuesParam)params.getParameter(DEFAULT_ENCODING);
        this.defaultEncoding = encoding != null && encoding.getValue() != null && !encoding.getValue().equalsIgnoreCase("") ? encoding.getValue() : null;
    }

    public String[] getMimeTypes() {
        return new String[]{"text/plain"};
    }

    public String getContentAsText(InputStream is) throws Exception {
        int len;
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) > 0) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        if (this.defaultEncoding != null) {
            return new String(bos.toByteArray(), this.defaultEncoding);
        }
        return new String(bos.toByteArray());
    }

    public String getContentAsText(InputStream is, String encoding) throws Exception {
        int len;
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) > 0) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return new String(bos.toByteArray(), encoding);
    }

    public Properties getProperties(InputStream is) throws Exception {
        return new Properties();
    }
}

