/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.NodeDataReader;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDataPersister {
    public static Log log = ExoLogger.getLogger((String)"jcr.NamespaceDataPersister");
    private DataManager dataManager;
    private PlainChangesLog changesLog;
    private NodeData nsRoot;

    public NamespaceDataPersister(DataManager dataManager) {
        this.dataManager = dataManager;
        this.changesLog = new PlainChangesLogImpl();
        try {
            NodeData jcrSystem = (NodeData)dataManager.getItemData("00exo0jcr0system0uuid00000000000");
            if (jcrSystem != null) {
                this.nsRoot = (NodeData)dataManager.getItemData(jcrSystem, new QPathEntry(Constants.EXO_NAMESPACES, 1));
            }
        }
        catch (RepositoryException e) {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
        }
    }

    public void initStorage(NodeData nsSystem, boolean addACL, Map<String, String> namespaces) throws RepositoryException {
        TransientNodeData exoNamespaces = TransientNodeData.createNodeData(nsSystem, Constants.EXO_NAMESPACES, Constants.NT_UNSTRUCTURED);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData(exoNamespaces, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(exoNamespaces.getPrimaryTypeName()));
        this.changesLog.add(ItemState.createAddedState(exoNamespaces)).add(ItemState.createAddedState(primaryType));
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            exoNamespaces.setMixinTypeNames(mixins);
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            this.changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            this.changesLog.add(new ItemState(exoNamespaces, 16, false, null));
        }
        this.nsRoot = exoNamespaces;
        for (String nsKey : namespaces.keySet()) {
            if (nsKey != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Namespace " + nsKey + " " + namespaces.get(nsKey)));
                }
                this.addNamespace(nsKey, namespaces.get(nsKey));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Namespace " + nsKey + " is initialized."));
                continue;
            }
            log.warn((Object)("Namespace is " + nsKey + " " + namespaces.get(nsKey)));
        }
        this.saveChanges();
    }

    public void addNamespace(String prefix, String uri) throws RepositoryException {
        if (!this.isInialized()) {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
            return;
        }
        TransientNodeData nsNode = TransientNodeData.createNodeData(this.nsRoot, new InternalQName("", prefix), Constants.EXO_NAMESPACE);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData(nsNode, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(nsNode.getPrimaryTypeName()));
        TransientPropertyData exoUri = TransientPropertyData.createPropertyData(nsNode, Constants.EXO_URI_NAME, 1, false);
        exoUri.setValue(new TransientValueData(uri));
        TransientPropertyData exoPrefix = TransientPropertyData.createPropertyData(nsNode, Constants.EXO_PREFIX, 1, false);
        exoPrefix.setValue(new TransientValueData(prefix));
        this.changesLog.add(ItemState.createAddedState(nsNode)).add(ItemState.createAddedState(primaryType)).add(ItemState.createAddedState(exoUri)).add(ItemState.createAddedState(exoPrefix));
    }

    void removeNamespace(String prefix) throws IllegalNameException {
        if (!this.isInialized()) {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
            return;
        }
        TransientNodeData nsNode = TransientNodeData.createNodeData(this.nsRoot, InternalQName.parse(prefix), Constants.EXO_NAMESPACE);
        this.changesLog.add(ItemState.createDeletedState(nsNode));
    }

    @Deprecated
    Map<String, String> loadNamespaces() throws PathNotFoundException, RepositoryException {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        if (this.isInialized()) {
            NodeDataReader nsReader = new NodeDataReader(this.nsRoot, this.dataManager, null);
            nsReader.setRememberSkiped(true);
            nsReader.forNodesByType(Constants.EXO_NAMESPACE);
            nsReader.read();
            List<NodeDataReader> nsData = nsReader.getNodesByType(Constants.EXO_NAMESPACE);
            for (NodeDataReader nsr : nsData) {
                nsr.forProperty(Constants.EXO_URI_NAME, 1).forProperty(Constants.EXO_PREFIX, 1);
                nsr.read();
                String exoUri = nsr.getPropertyValue(Constants.EXO_URI_NAME).getString();
                String exoPrefix = nsr.getPropertyValue(Constants.EXO_PREFIX).getString();
                nsMap.put(exoPrefix, exoUri);
                log.info((Object)("Namespace " + exoPrefix + " is loaded"));
            }
            for (NodeData skipedNs : nsReader.getSkiped()) {
                log.warn((Object)("Namespace node " + skipedNs.getQPath().getName().getAsString() + " (primary type '" + skipedNs.getPrimaryTypeName().getAsString() + "') is not supported for loading. Nodes with 'exo:namespace' node type is supported only now."));
            }
        } else {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized. No namespaces loaded.");
        }
        return nsMap;
    }

    void loadNamespaces(Map<String, String> namespacesMap, Map<String, String> urisMap) throws RepositoryException {
        if (!this.isInialized()) {
            NodeData jcrSystem = (NodeData)this.dataManager.getItemData("00exo0jcr0system0uuid00000000000");
            if (jcrSystem != null) {
                this.nsRoot = (NodeData)this.dataManager.getItemData(jcrSystem, new QPathEntry(Constants.EXO_NAMESPACES, 1));
            } else {
                throw new RepositoryException("/jcr:system is not found. Possible the workspace is not initialized properly");
            }
        }
        if (this.isInialized()) {
            NodeDataReader nsReader = new NodeDataReader(this.nsRoot, this.dataManager, null);
            nsReader.setRememberSkiped(true);
            nsReader.forNodesByType(Constants.EXO_NAMESPACE);
            nsReader.read();
            List<NodeDataReader> nsData = nsReader.getNodesByType(Constants.EXO_NAMESPACE);
            for (NodeDataReader nsr : nsData) {
                nsr.forProperty(Constants.EXO_URI_NAME, 1).forProperty(Constants.EXO_PREFIX, 1);
                nsr.read();
                String exoUri = nsr.getPropertyValue(Constants.EXO_URI_NAME).getString();
                String exoPrefix = nsr.getPropertyValue(Constants.EXO_PREFIX).getString();
                namespacesMap.put(exoPrefix, exoUri);
                urisMap.put(exoUri, exoPrefix);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Namespace " + exoPrefix + " is loaded"));
            }
            for (NodeData skipedNs : nsReader.getSkiped()) {
                log.warn((Object)("Namespace node " + skipedNs.getQPath().getName().getAsString() + " (primary type '" + skipedNs.getPrimaryTypeName().getAsString() + "') is not supported for loading. Nodes with 'exo:namespace' node type is supported only now."));
            }
        } else {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized. No namespaces loaded.");
        }
    }

    void saveChanges() throws RepositoryException, InvalidItemStateException {
        this.dataManager.save(new TransactionChangesLog(this.changesLog));
        this.changesLog.clear();
    }

    private boolean isInialized() {
        return this.nsRoot != null;
    }
}

