/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.DefaultItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.log.ExoLogger;

public class ItemDataCopyIgnoredVisitor
extends DefaultItemDataCopyVisitor {
    private static Log log = ExoLogger.getLogger((String)"jcr.ItemDataCopyIgnoredVisitor");
    protected final SessionChangesLog restoredChanges;

    public ItemDataCopyIgnoredVisitor(NodeData context, InternalQName destNodeName, NodeTypeManagerImpl nodeTypeManager, SessionDataManager dataManager, SessionChangesLog changes) {
        super(context, destNodeName, nodeTypeManager, dataManager, true);
        this.restoredChanges = changes;
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (level == 1 && (property.getQPath().getName().equals((Object)Constants.JCR_BASEVERSION) || property.getQPath().getName().equals((Object)Constants.JCR_ISCHECKEDOUT))) {
            return;
        }
        if (this.curParent() == null) {
            ItemState contextState;
            NodeData existedParent = (NodeData)this.dataManager.getItemData(property.getParentIdentifier());
            PropertyDefinition pdef = this.ntManager.findPropertyDefinition(property.getQPath().getName(), existedParent.getPrimaryTypeName(), existedParent.getMixinTypeNames());
            if (pdef.getOnParentVersion() == 5 && (contextState = this.restoredChanges.getItemState(property.getParentIdentifier())) != null && !contextState.isDeleted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("A property " + property.getQPath().getAsString() + " is IGNOREd"));
                }
                this.parents.push((NodeData)contextState.getData());
                super.entering(property, level);
                this.parents.pop();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A property " + property.getQPath().getAsString() + " is IGNOREd node descendant"));
            }
            super.entering(property, level);
        }
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        if (level == 0) {
            this.parents.pop();
        } else if (level > 0) {
            if (this.curParent() == null) {
                ItemState contextState;
                NodeData existedParent = (NodeData)this.dataManager.getItemData(node.getParentIdentifier());
                NodeDefinitionImpl ndef = this.ntManager.findNodeDefinition(node.getQPath().getName(), existedParent.getPrimaryTypeName(), existedParent.getMixinTypeNames());
                if (ndef.getOnParentVersion() == 5 && (contextState = this.restoredChanges.getItemState(node.getParentIdentifier())) != null && !contextState.isDeleted()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A node " + node.getQPath().getAsString() + " is IGNOREd"));
                    }
                    this.parents.push((NodeData)contextState.getData());
                    super.entering(node, level);
                    NodeData thisNode = (NodeData)this.parents.pop();
                    this.parents.pop();
                    this.parents.push(thisNode);
                    return;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("A node " + node.getQPath().getAsString() + " is IGNOREd node descendant"));
                }
                super.entering(node, level);
                return;
            }
        }
        this.parents.push(null);
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        if (this.parents.size() > 0) {
            this.parents.pop();
        }
    }
}

