/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.Invokable;
import org.jmock.core.Stub;
import org.jmock.core.StubMatchersCollection;
import org.jmock.core.stub.VoidStub;

public class InvocationMocker
implements Invokable,
StubMatchersCollection {
    private String name = null;
    private List matchers = new ArrayList();
    private Stub stub = VoidStub.INSTANCE;
    private Describer describer;
    public static final Describer DEFAULT_DESCRIBER = new Describer(){

        public boolean hasDescription() {
            return true;
        }

        public void describeTo(StringBuffer stringBuffer, List list, Stub stub, String string) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                InvocationMatcher invocationMatcher = (InvocationMatcher)iterator.next();
                if (!invocationMatcher.hasDescription()) continue;
                invocationMatcher.describeTo(stringBuffer).append(", ");
            }
            stub.describeTo(stringBuffer);
            if (string != null) {
                stringBuffer.append(" [").append(string).append("]");
            }
        }
    };

    public InvocationMocker() {
        this(DEFAULT_DESCRIBER);
    }

    public InvocationMocker(Describer describer) {
        this.describer = describer;
    }

    public boolean matches(Invocation invocation) {
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            if (((InvocationMatcher)iterator.next()).matches(invocation)) continue;
            return false;
        }
        return true;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            ((InvocationMatcher)iterator.next()).invoked(invocation);
        }
        return this.stub.invoke(invocation);
    }

    public void verify() {
        try {
            Iterator iterator = this.matchers.iterator();
            while (iterator.hasNext()) {
                ((InvocationMatcher)iterator.next()).verify();
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            AssertionFailedError assertionFailedError2 = new AssertionFailedError(assertionFailedError.getMessage() + "\n" + this.toString());
            assertionFailedError2.fillInStackTrace();
            throw assertionFailedError2;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addMatcher(InvocationMatcher invocationMatcher) {
        this.matchers.add(invocationMatcher);
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public String toString() {
        return this.describeTo(new StringBuffer()).toString();
    }

    public boolean hasDescription() {
        return this.describer.hasDescription();
    }

    public StringBuffer describeTo(StringBuffer stringBuffer) {
        this.describer.describeTo(stringBuffer, Collections.unmodifiableList(this.matchers), this.stub, this.name);
        return stringBuffer;
    }

    public static interface Describer {
        public boolean hasDescription();

        public void describeTo(StringBuffer var1, List var2, Stub var3, String var4);
    }
}

