/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.util.PDFTextStripper;
import org.pdfbox.util.TextPosition;

public class PrintTextLocations
extends PDFTextStripper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            PrintTextLocations.usage();
        } else {
            PDDocument document = null;
            FileInputStream file = null;
            try {
                file = new FileInputStream(args[0]);
                PDFParser parser = new PDFParser(file);
                parser.parse();
                document = parser.getPDDocument();
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: Document is encrypted with a password.");
                        System.exit(1);
                    }
                }
                PrintTextLocations printer = new PrintTextLocations();
                List allPages = document.getDocumentCatalog().getAllPages();
                for (int i = 0; i < allPages.size(); ++i) {
                    PDPage page = (PDPage)allPages.get(i);
                    System.out.println("Processing page: " + i);
                    printer.processStream(page, page.findResources(), page.getContents().getStream());
                }
            }
            finally {
                if (file != null) {
                    file.close();
                }
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    protected void showCharacter(TextPosition text) {
        System.out.println("String[" + text.getX() + "," + text.getY() + "]" + text.getCharacter());
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.PrintTextLocations <input-pdf>");
    }
}

