/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.AssociationKey;
import org.hibernate.engine.BatchFetchQueue;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.CollectionLoadContext;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.util.IdentityMap;
import org.hibernate.util.MarkerObject;

public class StatefulPersistenceContext
implements Serializable,
PersistenceContext {
    private static final Log log = LogFactory.getLog((Class)StatefulPersistenceContext.class);
    private static final Log PROXY_WARN_LOG = LogFactory.getLog((String)(StatefulPersistenceContext.class.getName() + ".ProxyWarnLog"));
    public static final Object NO_ROW = new MarkerObject("NO_ROW");
    private SessionImplementor session;
    private final Map entitiesByKey;
    private final Map entitiesByUniqueKey;
    private transient Map entityEntries;
    private transient Map proxiesByKey;
    private final Map entitySnapshotsByKey;
    private transient Map arrayHolders;
    private transient Map collectionEntries;
    private final Map collectionsByKey;
    private HashSet nullifiableEntityKeys = new HashSet();
    private transient HashSet nullAssociations;
    private transient List nonlazyCollections;
    private transient Map unownedCollections;
    private transient int cascading = 0;
    private transient int loadCounter = 0;
    private transient boolean flushing = false;
    private boolean hasNonReadOnlyEntities = false;
    private transient CollectionLoadContext collectionLoadContext;
    private transient BatchFetchQueue batchFetchQueue;
    private static final int INIT_MAP_SIZE = 8;

    public boolean isStateless() {
        return false;
    }

    public SessionImplementor getSession() {
        return this.session;
    }

    public CollectionLoadContext getCollectionLoadContext() {
        if (this.collectionLoadContext == null) {
            this.collectionLoadContext = new CollectionLoadContext(this);
        }
        return this.collectionLoadContext;
    }

    public void addUnownedCollection(CollectionKey key, PersistentCollection collection) {
        if (this.unownedCollections == null) {
            this.unownedCollections = new HashMap(8);
        }
        this.unownedCollections.put(key, collection);
    }

    public PersistentCollection useUnownedCollection(CollectionKey key) {
        if (this.unownedCollections == null) {
            return null;
        }
        return (PersistentCollection)this.unownedCollections.remove(key);
    }

    public BatchFetchQueue getBatchFetchQueue() {
        if (this.batchFetchQueue == null) {
            this.batchFetchQueue = new BatchFetchQueue(this);
        }
        return this.batchFetchQueue;
    }

    public StatefulPersistenceContext(SessionImplementor session) {
        this.session = session;
        this.entitiesByKey = new HashMap(8);
        this.entitiesByUniqueKey = new HashMap(8);
        this.proxiesByKey = new ReferenceMap(0, 2);
        this.entitySnapshotsByKey = new HashMap(8);
        this.entityEntries = IdentityMap.instantiateSequenced(8);
        this.collectionEntries = IdentityMap.instantiateSequenced(8);
        this.collectionsByKey = new HashMap(8);
        this.arrayHolders = IdentityMap.instantiate(8);
        this.initTransientState();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing persistent-context");
        ois.defaultReadObject();
        this.entityEntries = IdentityMap.deserialize(ois.readObject());
        this.collectionEntries = IdentityMap.deserialize(ois.readObject());
        this.arrayHolders = IdentityMap.deserialize(ois.readObject());
        this.initTransientState();
        this.proxiesByKey = new ReferenceMap(0, 2);
        Map map = (Map)ois.readObject();
        this.proxiesByKey.putAll(map);
        try {
            Object e;
            Iterator iter = this.collectionEntries.entrySet().iterator();
            while (iter.hasNext()) {
                e = iter.next();
                ((PersistentCollection)e.getKey()).setCurrentSession(this.session);
                CollectionEntry ce = (CollectionEntry)e.getValue();
                if (ce.getRole() == null) continue;
                ce.afterDeserialize(this.session.getFactory());
            }
            iter = this.proxiesByKey.values().iterator();
            while (iter.hasNext()) {
                Map.Entry proxy = iter.next();
                if (proxy instanceof HibernateProxy) {
                    ((HibernateProxy)((Object)proxy)).getHibernateLazyInitializer().setSession(this.session);
                    continue;
                }
                iter.remove();
            }
            iter = this.entityEntries.entrySet().iterator();
            while (iter.hasNext()) {
                e = (EntityEntry)iter.next().getValue();
                ((EntityEntry)e).afterDeserialize(this.session.getFactory());
            }
        }
        catch (HibernateException he) {
            throw new InvalidObjectException(he.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        log.trace((Object)"serializing persistent-context");
        oos.defaultWriteObject();
        oos.writeObject(IdentityMap.serialize(this.entityEntries));
        oos.writeObject(IdentityMap.serialize(this.collectionEntries));
        oos.writeObject(IdentityMap.serialize(this.arrayHolders));
        HashMap map = new HashMap(8);
        map.putAll(this.proxiesByKey);
        oos.writeObject(map);
    }

    private void initTransientState() {
        this.nullAssociations = new HashSet(8);
        this.nonlazyCollections = new ArrayList(8);
    }

    public void clear() {
        this.arrayHolders.clear();
        this.entitiesByKey.clear();
        this.entitiesByUniqueKey.clear();
        this.entityEntries.clear();
        this.entitySnapshotsByKey.clear();
        this.collectionsByKey.clear();
        this.collectionEntries.clear();
        if (this.unownedCollections != null) {
            this.unownedCollections.clear();
        }
        this.proxiesByKey.clear();
        this.nullifiableEntityKeys.clear();
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.clear();
        }
        this.hasNonReadOnlyEntities = false;
    }

    public boolean hasNonReadOnlyEntities() {
        return this.hasNonReadOnlyEntities;
    }

    public void setEntryStatus(EntityEntry entry, Status status) {
        entry.setStatus(status);
        this.setHasNonReadOnlyEnties(status);
    }

    private void setHasNonReadOnlyEnties(Status status) {
        if (status == Status.DELETED || status == Status.MANAGED || status == Status.SAVING) {
            this.hasNonReadOnlyEntities = true;
        }
    }

    public void afterTransactionCompletion() {
        Iterator iter = this.entityEntries.values().iterator();
        while (iter.hasNext()) {
            ((EntityEntry)iter.next()).setLockMode(LockMode.NONE);
        }
    }

    public Object[] getDatabaseSnapshot(Serializable id, EntityPersister persister) throws HibernateException {
        EntityKey key = new EntityKey(id, persister, this.session.getEntityMode());
        Object cached = this.entitySnapshotsByKey.get(key);
        if (cached != null) {
            return cached == NO_ROW ? null : (Object[])cached;
        }
        Object[] snapshot = persister.getDatabaseSnapshot(id, this.session);
        this.entitySnapshotsByKey.put(key, snapshot == null ? NO_ROW : snapshot);
        return snapshot;
    }

    public Object[] getNaturalIdSnapshot(Serializable id, EntityPersister persister) throws HibernateException {
        if (!persister.hasNaturalIdentifier()) {
            return null;
        }
        int[] props = persister.getNaturalIdentifierProperties();
        boolean[] updateable = persister.getPropertyUpdateability();
        boolean allNatualIdPropsAreUpdateable = true;
        for (int i = 0; i < props.length; ++i) {
            if (updateable[props[i]]) continue;
            allNatualIdPropsAreUpdateable = false;
            break;
        }
        if (allNatualIdPropsAreUpdateable) {
            Object[] entitySnapshot = this.getDatabaseSnapshot(id, persister);
            if (entitySnapshot == NO_ROW) {
                return null;
            }
            Object[] naturalIdSnapshot = new Object[props.length];
            for (int i = 0; i < props.length; ++i) {
                naturalIdSnapshot[i] = entitySnapshot[props[i]];
            }
            return naturalIdSnapshot;
        }
        return persister.getNaturalIdentifierSnapshot(id, this.session);
    }

    public Object[] getCachedDatabaseSnapshot(EntityKey key) {
        return (Object[])this.entitySnapshotsByKey.get(key);
    }

    public void addEntity(EntityKey key, Object entity) {
        this.entitiesByKey.put(key, entity);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(key);
    }

    public Object getEntity(EntityKey key) {
        return this.entitiesByKey.get(key);
    }

    public boolean containsEntity(EntityKey key) {
        return this.entitiesByKey.containsKey(key);
    }

    public Object removeEntity(EntityKey key) {
        Object entity = this.entitiesByKey.remove(key);
        Iterator iter = this.entitiesByUniqueKey.values().iterator();
        while (iter.hasNext()) {
            if (iter.next() != entity) continue;
            iter.remove();
        }
        this.entitySnapshotsByKey.remove(key);
        this.nullifiableEntityKeys.remove(key);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(key);
        this.getBatchFetchQueue().removeSubselect(key);
        return entity;
    }

    public Object getEntity(EntityUniqueKey euk) {
        return this.entitiesByUniqueKey.get(euk);
    }

    public void addEntity(EntityUniqueKey euk, Object entity) {
        this.entitiesByUniqueKey.put(euk, entity);
    }

    public EntityEntry getEntry(Object entity) {
        return (EntityEntry)this.entityEntries.get(entity);
    }

    public EntityEntry removeEntry(Object entity) {
        return (EntityEntry)this.entityEntries.remove(entity);
    }

    public boolean isEntryFor(Object entity) {
        return this.entityEntries.containsKey(entity);
    }

    public CollectionEntry getCollectionEntry(PersistentCollection coll) {
        return (CollectionEntry)this.collectionEntries.get(coll);
    }

    public EntityEntry addEntity(Object entity, Status status, Object[] loadedState, EntityKey entityKey, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        this.addEntity(entityKey, entity);
        return this.addEntry(entity, status, loadedState, null, entityKey.getIdentifier(), version, lockMode, existsInDatabase, persister, disableVersionIncrement, lazyPropertiesAreUnfetched);
    }

    public EntityEntry addEntry(Object entity, Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        EntityEntry e = new EntityEntry(status, loadedState, rowId, id, version, lockMode, existsInDatabase, persister, this.session.getEntityMode(), disableVersionIncrement, lazyPropertiesAreUnfetched);
        this.entityEntries.put(entity, e);
        this.setHasNonReadOnlyEnties(status);
        return e;
    }

    public boolean containsCollection(PersistentCollection collection) {
        return this.collectionEntries.containsKey(collection);
    }

    public boolean containsProxy(Object entity) {
        return this.proxiesByKey.containsValue(entity);
    }

    public boolean reassociateIfUninitializedProxy(Object value) throws MappingException {
        if (value instanceof ElementWrapper) {
            value = ((ElementWrapper)value).getElement();
        }
        if (!Hibernate.isInitialized(value)) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return true;
        }
        return false;
    }

    public void reassociateProxy(Object value, Serializable id) throws MappingException {
        if (value instanceof ElementWrapper) {
            value = ((ElementWrapper)value).getElement();
        }
        if (value instanceof HibernateProxy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting proxy identifier: " + id));
            }
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            li.setIdentifier(id);
            this.reassociateProxy(li, proxy);
        }
    }

    private void reassociateProxy(LazyInitializer li, HibernateProxy proxy) throws HibernateException {
        if (li.getSession() != this) {
            EntityPersister persister = this.session.getFactory().getEntityPersister(li.getEntityName());
            EntityKey key = new EntityKey(li.getIdentifier(), persister, this.session.getEntityMode());
            if (!this.proxiesByKey.containsKey(key)) {
                this.proxiesByKey.put(key, proxy);
            }
            proxy.getHibernateLazyInitializer().setSession(this.session);
        }
    }

    public Object unproxy(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof ElementWrapper) {
            maybeProxy = ((ElementWrapper)maybeProxy).getElement();
        }
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                throw new PersistentObjectException("object was an uninitialized proxy for " + li.getEntityName());
            }
            return li.getImplementation();
        }
        return maybeProxy;
    }

    public Object unproxyAndReassociate(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof ElementWrapper) {
            maybeProxy = ((ElementWrapper)maybeProxy).getElement();
        }
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return li.getImplementation();
        }
        return maybeProxy;
    }

    public void checkUniqueness(EntityKey key, Object object) throws HibernateException {
        Object entity = this.getEntity(key);
        if (entity == object) {
            throw new AssertionFailure("object already associated, but no entry was found");
        }
        if (entity != null) {
            throw new NonUniqueObjectException(key.getIdentifier(), key.getEntityName());
        }
    }

    public Object narrowProxy(Object proxy, EntityPersister persister, EntityKey key, Object object) throws HibernateException {
        boolean alreadyNarrow = persister.getConcreteProxyClass(this.session.getEntityMode()).isAssignableFrom(proxy.getClass());
        if (!alreadyNarrow) {
            if (PROXY_WARN_LOG.isWarnEnabled()) {
                PROXY_WARN_LOG.warn((Object)("Narrowing proxy to " + persister.getConcreteProxyClass(this.session.getEntityMode()) + " - this operation breaks =="));
            }
            if (object != null) {
                this.proxiesByKey.remove(key);
                return object;
            }
            proxy = persister.createProxy(key.getIdentifier(), this.session);
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        if (object != null) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            li.setImplementation(object);
        }
        return proxy;
    }

    public Object proxyFor(EntityPersister persister, EntityKey key, Object impl) throws HibernateException {
        if (!persister.hasProxy()) {
            return impl;
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, impl);
        }
        return impl;
    }

    public Object proxyFor(Object impl) throws HibernateException {
        EntityEntry e = this.getEntry(impl);
        EntityPersister p = e.getPersister();
        return this.proxyFor(p, new EntityKey(e.getId(), p, this.session.getEntityMode()), impl);
    }

    public Object getCollectionOwner(Serializable key, CollectionPersister collectionPersister) throws MappingException {
        return this.getEntity(new EntityKey(key, collectionPersister.getOwnerEntityPersister(), this.session.getEntityMode()));
    }

    public void addUninitializedCollection(CollectionPersister persister, PersistentCollection collection, Serializable id) {
        CollectionEntry ce = new CollectionEntry(collection, persister, id, this.flushing);
        this.addCollection(collection, ce, id);
    }

    public void addUninitializedDetachedCollection(CollectionPersister persister, PersistentCollection collection) {
        CollectionEntry ce = new CollectionEntry(persister, collection.getKey());
        this.addCollection(collection, ce, collection.getKey());
    }

    public void addNewCollection(CollectionPersister persister, PersistentCollection collection) throws HibernateException {
        this.addCollection(collection, persister);
    }

    private void addCollection(PersistentCollection coll, CollectionEntry entry, Serializable key) {
        this.collectionEntries.put(coll, entry);
        CollectionKey collectionKey = new CollectionKey(entry.getLoadedPersister(), key, this.session.getEntityMode());
        PersistentCollection old = this.collectionsByKey.put(collectionKey, coll);
        if (old != null) {
            if (old == coll) {
                throw new AssertionFailure("bug adding collection twice");
            }
            old.unsetSession(this.session);
            this.collectionEntries.remove(old);
        }
    }

    private void addCollection(PersistentCollection collection, CollectionPersister persister) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(persister, collection);
        this.collectionEntries.put(collection, ce);
    }

    public void addInitializedDetachedCollection(CollectionPersister collectionPersister, PersistentCollection collection) throws HibernateException {
        if (collection.isUnreferenced()) {
            this.addCollection(collection, collectionPersister);
        } else {
            CollectionEntry ce = new CollectionEntry(collection, this.session.getFactory());
            this.addCollection(collection, ce, collection.getKey());
        }
    }

    public CollectionEntry addInitializedCollection(CollectionPersister persister, PersistentCollection collection, Serializable id) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(collection, persister, id, this.flushing);
        ce.postInitialize(collection);
        this.addCollection(collection, ce, id);
        return ce;
    }

    public PersistentCollection getCollection(CollectionKey collectionKey) {
        return (PersistentCollection)this.collectionsByKey.get(collectionKey);
    }

    public void addNonLazyCollection(PersistentCollection collection) {
        this.nonlazyCollections.add(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeNonLazyCollections() throws HibernateException {
        if (this.loadCounter == 0) {
            log.debug((Object)"initializing non-lazy collections");
            ++this.loadCounter;
            try {
                int size;
                while ((size = this.nonlazyCollections.size()) > 0) {
                    ((PersistentCollection)this.nonlazyCollections.remove(size - 1)).forceInitialization();
                }
            }
            finally {
                --this.loadCounter;
                this.clearNullProperties();
            }
        }
    }

    public PersistentCollection getCollectionHolder(Object array) {
        return (PersistentCollection)this.arrayHolders.get(array);
    }

    public void addCollectionHolder(PersistentCollection holder) {
        this.arrayHolders.put(holder.getValue(), holder);
    }

    public PersistentCollection removeCollectionHolder(Object array) {
        return (PersistentCollection)this.arrayHolders.remove(array);
    }

    public Serializable getSnapshot(PersistentCollection coll) {
        return this.getCollectionEntry(coll).getSnapshot();
    }

    public CollectionEntry getCollectionEntryOrNull(Object collection) {
        PersistentCollection coll;
        if (collection instanceof PersistentCollection) {
            coll = (PersistentCollection)collection;
        } else {
            coll = this.getCollectionHolder(collection);
            if (coll == null) {
                Iterator wrappers = IdentityMap.keyIterator(this.collectionEntries);
                while (wrappers.hasNext()) {
                    PersistentCollection pc = (PersistentCollection)wrappers.next();
                    if (!pc.isWrapper(collection)) continue;
                    coll = pc;
                    break;
                }
            }
        }
        return coll == null ? null : this.getCollectionEntry(coll);
    }

    public Object getProxy(EntityKey key) {
        return this.proxiesByKey.get(key);
    }

    public void addProxy(EntityKey key, Object proxy) {
        this.proxiesByKey.put(key, proxy);
    }

    public Object removeProxy(EntityKey key) {
        return this.proxiesByKey.remove(key);
    }

    public HashSet getNullifiableEntityKeys() {
        return this.nullifiableEntityKeys;
    }

    public Map getEntitiesByKey() {
        return this.entitiesByKey;
    }

    public Map getEntityEntries() {
        return this.entityEntries;
    }

    public Map getCollectionEntries() {
        return this.collectionEntries;
    }

    public Map getCollectionsByKey() {
        return this.collectionsByKey;
    }

    public int getCascadeLevel() {
        return this.cascading;
    }

    public int incrementCascadeLevel() {
        return ++this.cascading;
    }

    public int decrementCascadeLevel() {
        return --this.cascading;
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public void setFlushing(boolean flushing) {
        this.flushing = flushing;
    }

    public void beforeLoad() {
        ++this.loadCounter;
    }

    public void afterLoad() {
        --this.loadCounter;
    }

    public String toString() {
        return "PersistenceContext[entityKeys=" + this.entitiesByKey.keySet() + ",collectionKeys=" + this.collectionsByKey.keySet() + "]";
    }

    public Serializable getOwnerId(String entity, String property, Object childEntity, Map mergeMap) {
        EntityPersister persister = this.session.getFactory().getEntityPersister(entity);
        CollectionPersister collectionPersister = this.session.getFactory().getCollectionPersister(entity + '.' + property);
        Iterator entities = this.entityEntries.entrySet().iterator();
        while (entities.hasNext()) {
            Map.Entry me = entities.next();
            EntityEntry ee = (EntityEntry)me.getValue();
            if (!persister.isSubclassEntityName(ee.getEntityName())) continue;
            Object instance = me.getKey();
            boolean found = this.isFoundInParent(property, childEntity, persister, collectionPersister, instance);
            if (!found && mergeMap != null) {
                Object unmergedInstance = mergeMap.get(instance);
                Object unmergedChild = mergeMap.get(childEntity);
                if (unmergedInstance != null && unmergedChild != null) {
                    found = this.isFoundInParent(property, unmergedChild, persister, collectionPersister, unmergedInstance);
                }
            }
            if (!found) continue;
            return ee.getId();
        }
        return null;
    }

    private boolean isFoundInParent(String property, Object childEntity, EntityPersister persister, CollectionPersister collectionPersister, Object potentialParent) {
        Object collection = persister.getPropertyValue(potentialParent, property, this.session.getEntityMode());
        return collection != null && Hibernate.isInitialized(collection) && collectionPersister.getCollectionType().contains(collection, childEntity, this.session);
    }

    public Object getIndexInOwner(String entity, String property, Object childEntity, Map mergeMap) {
        EntityPersister persister = this.session.getFactory().getEntityPersister(entity);
        CollectionPersister cp = this.session.getFactory().getCollectionPersister(entity + '.' + property);
        Iterator entities = this.entityEntries.entrySet().iterator();
        while (entities.hasNext()) {
            Map.Entry me = entities.next();
            EntityEntry ee = (EntityEntry)me.getValue();
            if (!persister.isSubclassEntityName(ee.getEntityName())) continue;
            Object instance = me.getKey();
            Object index = this.getIndexInParent(property, childEntity, persister, cp, instance);
            if (index == null && mergeMap != null) {
                Object unmergedInstance = mergeMap.get(instance);
                Object unmergedChild = mergeMap.get(childEntity);
                if (unmergedInstance != null && unmergedChild != null) {
                    index = this.getIndexInParent(property, unmergedChild, persister, cp, unmergedInstance);
                }
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private Object getIndexInParent(String property, Object childEntity, EntityPersister persister, CollectionPersister collectionPersister, Object potentialParent) {
        Object collection = persister.getPropertyValue(potentialParent, property, this.session.getEntityMode());
        if (collection != null && Hibernate.isInitialized(collection)) {
            return collectionPersister.getCollectionType().indexOf(collection, childEntity);
        }
        return null;
    }

    public void addNullProperty(EntityKey ownerKey, String propertyName) {
        this.nullAssociations.add(new AssociationKey(ownerKey, propertyName));
    }

    public boolean isPropertyNull(EntityKey ownerKey, String propertyName) {
        return this.nullAssociations.contains(new AssociationKey(ownerKey, propertyName));
    }

    private void clearNullProperties() {
        this.nullAssociations.clear();
    }

    public void setReadOnly(Object entity, boolean readOnly) {
        EntityEntry entry = this.getEntry(entity);
        if (entry == null) {
            throw new TransientObjectException("Instance was not associated with the session");
        }
        entry.setReadOnly(readOnly, entity);
        this.hasNonReadOnlyEntities = this.hasNonReadOnlyEntities || !readOnly;
    }
}

