/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.TwoWayRangeIterator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocOrderNodeIteratorImpl
implements TwoWayRangeIterator,
ScoreNodeIterator {
    private static final Log log = ExoLogger.getLogger(DocOrderNodeIteratorImpl.class);
    private NodeIteratorImpl orderedNodes;
    private final List<ScoreNode> scoreNodes;
    protected final SessionDataManager itemMgr;
    private final AccessManager accessManager;
    private final String userId;

    DocOrderNodeIteratorImpl(SessionDataManager itemMgr, AccessManager accessManager, String userId, List<ScoreNode> scoreNodes) {
        this.itemMgr = itemMgr;
        this.accessManager = accessManager;
        this.userId = userId;
        this.scoreNodes = scoreNodes;
    }

    public Object next() {
        return this.nextNodeImpl();
    }

    public Node nextNode() {
        return this.nextNodeImpl();
    }

    @Override
    public NodeImpl nextNodeImpl() {
        this.initOrderedIterator();
        return this.orderedNodes.nextNodeImpl();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skip(skipNum);
    }

    @Override
    public void skipBack(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skipBack(skipNum);
    }

    public long getSize() {
        if (this.orderedNodes != null) {
            return this.orderedNodes.getSize();
        }
        return this.scoreNodes.size();
    }

    public long getPosition() {
        this.initOrderedIterator();
        return this.orderedNodes.getPosition();
    }

    public boolean hasNext() {
        this.initOrderedIterator();
        return this.orderedNodes.hasNext();
    }

    @Override
    public float getScore() {
        this.initOrderedIterator();
        return this.orderedNodes.getScore();
    }

    private void initOrderedIterator() {
        if (this.orderedNodes != null) {
            return;
        }
        long time = System.currentTimeMillis();
        ScoreNode[] nodes = this.scoreNodes.toArray(new ScoreNode[this.scoreNodes.size()]);
        final HashSet invalidIDs = new HashSet(2);
        final HashMap lcache = new HashMap();
        do {
            if (invalidIDs.size() > 0) {
                ArrayList<ScoreNode> tmp = new ArrayList<ScoreNode>();
                for (int i = 0; i < nodes.length; ++i) {
                    if (!invalidIDs.contains(nodes[i].getNodeId())) {
                        tmp.add(nodes[i]);
                        continue;
                    }
                    lcache.remove(nodes[i].getNodeId());
                }
                nodes = tmp.toArray(new ScoreNode[tmp.size()]);
                invalidIDs.clear();
            }
            try {
                Arrays.sort(nodes, new Comparator<ScoreNode>(){

                    private NodeData getNode(String id) throws RepositoryException {
                        NodeData node = (NodeData)lcache.get(id);
                        if (node == null && (node = (NodeData)DocOrderNodeIteratorImpl.this.itemMgr.getItemData(id)) != null) {
                            lcache.put(id, node);
                        }
                        return node;
                    }

                    @Override
                    public int compare(ScoreNode n1, ScoreNode n2) {
                        try {
                            int commonDepth;
                            NodeData ndata2;
                            NodeData ndata1;
                            try {
                                ndata1 = this.getNode(n1.getNodeId());
                                if (ndata1 == null) {
                                    throw new RepositoryException("Node not found for " + n1.getNodeId());
                                }
                            }
                            catch (RepositoryException e) {
                                invalidIDs.add(n1.getNodeId());
                                throw new SortFailedException();
                            }
                            try {
                                ndata2 = this.getNode(n2.getNodeId());
                                if (ndata2 == null) {
                                    throw new RepositoryException("Node not found for " + n2.getNodeId());
                                }
                            }
                            catch (RepositoryException e) {
                                invalidIDs.add(n2.getNodeId());
                                throw new SortFailedException();
                            }
                            QPath path1 = ndata1.getQPath();
                            QPath path2 = ndata2.getQPath();
                            QPathEntry[] pentries1 = path1.getEntries();
                            QPathEntry[] pentries2 = path2.getEntries();
                            for (commonDepth = 0; pentries1.length > commonDepth && pentries2.length > commonDepth && pentries1[commonDepth].equals(pentries2[commonDepth]); ++commonDepth) {
                            }
                            if (pentries1.length - 1 == --commonDepth) {
                                return -1;
                            }
                            if (pentries2.length - 1 == commonDepth) {
                                return 1;
                            }
                            return ndata1.getOrderNumber() - ndata2.getOrderNumber();
                        }
                        catch (SortFailedException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            log.error((Object)("Exception while sorting nodes in document order: " + e.toString()), (Throwable)e);
                            if (n1 != null) {
                                invalidIDs.add(n1.getNodeId());
                            } else {
                                log.warn((Object)"Null ScoreNode n1 will not be added into invalid identifiers set");
                            }
                            if (n2 != null) {
                                invalidIDs.add(n2.getNodeId());
                            } else {
                                log.warn((Object)"Null ScoreNode n2 will not be added into invalid identifiers set");
                            }
                            throw new SortFailedException();
                        }
                    }
                });
            }
            catch (SortFailedException e) {
                // empty catch block
            }
        } while (invalidIDs.size() > 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + nodes.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms"));
        }
        this.orderedNodes = new NodeIteratorImpl(this.itemMgr, nodes);
    }

    private static final class SortFailedException
    extends RuntimeException {
        private SortFailedException() {
        }
    }
}

