/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueueStore;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.log.ExoLogger;

class IndexingQueue {
    private static final Log log = ExoLogger.getLogger(IndexingQueue.class);
    private final IndexingQueueStore queueStore;
    private final Map pendingDocuments = new HashMap();

    IndexingQueue(IndexingQueueStore queueStore, MultiIndex index) {
        this.queueStore = queueStore;
        String[] uuids = queueStore.getPending();
        for (int i = 0; i < uuids.length; ++i) {
            try {
                Document doc = index.createDocument(uuids[i]);
                this.pendingDocuments.put(uuids[i], doc);
                continue;
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("Invalid UUID in indexing queue store: " + uuids[i]));
                continue;
            }
            catch (RepositoryException e) {
                log.debug((Object)("Node with uuid " + uuids[i] + " does not exist anymore"));
                try {
                    queueStore.removeUUID(uuids[i]);
                    continue;
                }
                catch (IOException ex) {
                    log.warn((Object)("Unable to remove node " + uuids[i] + " from indexing queue"), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document[] getFinishedDocuments() {
        ArrayList finished = new ArrayList();
        IndexingQueue indexingQueue = this;
        synchronized (indexingQueue) {
            finished.addAll(this.pendingDocuments.values());
        }
        Iterator it = finished.iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            if (Util.isDocumentReady(doc)) continue;
            it.remove();
        }
        return finished.toArray(new Document[finished.size()]);
    }

    public synchronized Document removeDocument(String uuid) throws IOException {
        Document doc = (Document)this.pendingDocuments.remove(uuid);
        if (doc != null) {
            this.queueStore.removeUUID(uuid);
            log.debug((Object)("removed node " + uuid + ". New size of indexing queue: " + this.pendingDocuments.size()));
        }
        return doc;
    }

    public synchronized Document addDocument(Document doc) throws IOException {
        String uuid = doc.get(FieldNames.UUID);
        Document existing = this.pendingDocuments.put(uuid, doc);
        log.debug((Object)("added node " + uuid + ". New size of indexing queue: " + this.pendingDocuments.size()));
        if (existing == null) {
            this.queueStore.addUUID(uuid);
        }
        return existing;
    }

    public synchronized void close() throws IOException {
        Iterator it = this.pendingDocuments.values().iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            Util.disposeDocument(doc);
            it.remove();
        }
        this.queueStore.close();
    }

    public synchronized void commit() throws IOException {
        this.queueStore.commit();
    }
}

