/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.util.ArrayList;
import java.util.Stack;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

public class FrozenNodeInitializer
extends ItemDataTraversingVisitor {
    private static Log log = ExoLogger.getLogger((String)"jcr.FrozenNodeInitializer");
    private final Stack<NodeData> contextNodes;
    private final NodeTypeManagerImpl ntManager;
    private final PlainChangesLog changesLog;
    private final SessionDataManager dataManager;

    public FrozenNodeInitializer(NodeData frozen, SessionDataManager dataManager, NodeTypeManagerImpl ntManager, PlainChangesLog changesLog) throws RepositoryException {
        super(dataManager);
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.changesLog = changesLog;
        this.contextNodes = new Stack();
        this.contextNodes.push(frozen);
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering property " + property.getQPath().getAsString()));
        }
        if (this.currentNode() == null) {
            return;
        }
        TransientPropertyData frozenProperty = null;
        InternalQName qname = property.getQPath().getName();
        ArrayList<ValueData> values = new ArrayList<ValueData>();
        for (ValueData valueData : property.getValues()) {
            values.add(((TransientValueData)valueData).createTransientCopy());
        }
        boolean mv = property.isMultiValued();
        if (qname.equals((Object)Constants.JCR_PRIMARYTYPE) && level == 1) {
            frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), Constants.JCR_FROZENPRIMARYTYPE, 7, mv, values);
        } else if (qname.equals((Object)Constants.JCR_UUID) && level == 1) {
            frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), Constants.JCR_FROZENUUID, 1, mv, values);
        } else if (qname.equals((Object)Constants.JCR_MIXINTYPES) && level == 1) {
            frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), Constants.JCR_FROZENMIXINTYPES, 7, mv, values);
        } else {
            NodeData parent = (NodeData)this.dataManager.getItemData(property.getParentIdentifier());
            PropertyDefinition pdef = this.ntManager.findPropertyDefinition(qname, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
            int action = pdef.getOnParentVersion();
            if (action == 5) {
                return;
            }
            if (action == 6) {
                throw new VersionException("Property is aborted " + property.getQPath().getAsString());
            }
            if (action == 1 || action == 2 || action == 4) {
                frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), qname, property.getType(), mv, values);
            } else if (action == 3) {
                if (pdef.isAutoCreated()) {
                    if (pdef.getDefaultValues() != null && pdef.getDefaultValues().length > 0) {
                        values.clear();
                        for (Value defValue : pdef.getDefaultValues()) {
                            TransientValueData defData = ((BaseValue)defValue).getInternalData();
                            values.add(defData.createTransientCopy());
                        }
                    } else if (this.ntManager.isNodeType(Constants.NT_HIERARCHYNODE, parent.getPrimaryTypeName(), parent.getMixinTypeNames()) && qname.equals((Object)Constants.JCR_CREATED)) {
                        values.clear();
                        values.add(new TransientValueData(this.dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
                    }
                }
                frozenProperty = TransientPropertyData.createPropertyData(this.currentNode(), qname, property.getType(), mv, values);
            } else {
                throw new RepositoryException("Unknown OnParentVersion value " + action);
            }
        }
        this.changesLog.add(ItemState.createAddedState(frozenProperty));
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        if (level == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entering node " + node.getQPath().getAsString() + ", level=0"));
            }
            return;
        }
        if (this.currentNode() == null) {
            this.contextNodes.push(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entering node " + node.getQPath().getAsString() + ", HAS NULL PARENT"));
            }
            return;
        }
        InternalQName qname = node.getQPath().getName();
        NodeData parent = (NodeData)this.dataManager.getItemData(node.getParentIdentifier());
        NodeDefinitionImpl pdef = this.ntManager.findNodeDefinition(qname, node.getPrimaryTypeName(), parent.getPrimaryTypeName(), parent.getMixinTypeNames());
        int action = pdef.getOnParentVersion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering node " + node.getQPath().getAsString() + ", " + OnParentVersionAction.nameFromValue((int)action)));
        }
        TransientNodeData frozenNode = null;
        if (action == 5) {
            this.contextNodes.push(null);
        } else {
            if (action == 6) {
                throw new VersionException("Node is aborted " + node.getQPath().getAsString());
            }
            if (action == 1) {
                QPath frozenPath = QPath.makeChildPath(this.currentNode().getQPath(), qname, node.getQPath().getIndex());
                frozenNode = new TransientNodeData(frozenPath, IdGenerator.generate(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), this.currentNode().getIdentifier(), node.getACL());
                this.contextNodes.push(frozenNode);
                this.changesLog.add(ItemState.createAddedState(frozenNode));
            } else if (action == 2) {
                if (this.ntManager.isNodeType(Constants.MIX_VERSIONABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
                    frozenNode = TransientNodeData.createNodeData(this.currentNode(), qname, Constants.NT_VERSIONEDCHILD, node.getQPath().getIndex());
                    TransientPropertyData pt = TransientPropertyData.createPropertyData((NodeData)frozenNode, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(Constants.NT_VERSIONEDCHILD));
                    ValueData vh = ((PropertyData)this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_VERSIONHISTORY, 0))).getValues().get(0);
                    TransientPropertyData pd = TransientPropertyData.createPropertyData((NodeData)frozenNode, Constants.JCR_CHILDVERSIONHISTORY, 9, false, vh);
                    this.contextNodes.push(null);
                    this.changesLog.add(ItemState.createAddedState(frozenNode));
                    this.changesLog.add(ItemState.createAddedState(pt));
                    this.changesLog.add(ItemState.createAddedState(pd));
                } else {
                    QPath frozenPath = QPath.makeChildPath(this.currentNode().getQPath(), qname, node.getQPath().getIndex());
                    frozenNode = new TransientNodeData(frozenPath, IdGenerator.generate(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), this.currentNode().getIdentifier(), node.getACL());
                    this.contextNodes.push(frozenNode);
                    this.changesLog.add(ItemState.createAddedState(frozenNode));
                }
            } else if (action == 3) {
                frozenNode = TransientNodeData.createNodeData(this.currentNode(), qname, node.getPrimaryTypeName(), node.getQPath().getIndex());
                this.contextNodes.push(null);
                this.changesLog.add(ItemState.createAddedState(frozenNode));
            } else if (action == 4) {
                frozenNode = TransientNodeData.createNodeData(this.currentNode(), qname, node.getPrimaryTypeName(), node.getQPath().getIndex());
                this.contextNodes.push(null);
                this.changesLog.add(ItemState.createAddedState(frozenNode));
            } else {
                throw new RepositoryException("Unknown onParentVersion type " + action);
            }
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.contextNodes.pop();
    }

    private NodeData currentNode() {
        return this.contextNodes.peek();
    }

    public SessionDataManager getDataManager() {
        return this.dataManager;
    }
}

