/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.persistence;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSString;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;

public class AppendAndFillDoc {
    public void appendDocument(COSDocument destination, COSDocument source) {
        COSDictionary pages2 = this.getPages(source);
        COSArray kids = (COSArray)pages2.getItem(COSName.getPDFName("Kids"));
        Iterator i = kids.iterator();
        while (i.hasNext()) {
            COSDictionary page = (COSDictionary)((COSObject)i.next()).getObject();
            this.appendPage(destination, page);
        }
    }

    public void appendPage(COSDocument destination, COSDictionary page) {
        COSDictionary pages = this.getPages(destination);
        page.setItem(COSName.PARENT, (COSBase)pages);
        COSArray kids = (COSArray)pages.getItem(COSName.getPDFName("Kids"));
        kids.add(page);
        COSNumber count = (COSNumber)pages.getItem(COSName.COUNT);
        pages.setItem(COSName.COUNT, (COSBase)new COSInteger(count.intValue() + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in1, String in2, String out, String name1, String value1, String name2, String value2) throws IOException, COSVisitorException {
        COSDocument doc1 = null;
        COSDocument doc2 = null;
        InputStream is1 = null;
        InputStream is2 = null;
        PDFParser parser1 = null;
        PDFParser parser2 = null;
        OutputStream os = null;
        COSWriter writer = null;
        try {
            is1 = new FileInputStream(in1);
            parser1 = new PDFParser(is1);
            parser1.parse();
            doc1 = parser1.getDocument();
            is2 = new FileInputStream(in2);
            parser2 = new PDFParser(is2);
            parser2.parse();
            doc2 = parser2.getDocument();
            this.setField(doc1, "doc1", new COSString(name1), new COSString(value1));
            this.setField(doc2, "doc2", new COSString(name2), new COSString(value2));
            this.appendDocument(doc1, doc2);
            os = new FileOutputStream(out);
            writer = new COSWriter(os);
            writer.write(doc1);
        }
        finally {
            is1.close();
            doc1.close();
            is2.close();
            doc2.close();
            os.close();
            writer.close();
        }
    }

    public COSDictionary getPages(COSDocument doc) {
        for (COSObject obj : doc.getObjects()) {
            COSDictionary dict;
            COSBase type;
            COSBase base = obj.getObject();
            if (!(base instanceof COSDictionary) || (type = (dict = (COSDictionary)base).getItem(COSName.TYPE)) == null || !type.equals(COSName.getPDFName("Pages"))) continue;
            return dict;
        }
        return null;
    }

    public static void main(String[] args) {
        AppendAndFillDoc app = new AppendAndFillDoc();
        try {
            if (args.length != 7) {
                app.usage();
            } else {
                app.doIt(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setField(COSDocument doc, String prefix, COSString name, COSString value) {
        for (COSObject obj : doc.getObjects()) {
            COSBase fname;
            COSBase subtype;
            COSDictionary dict;
            COSBase type;
            COSBase base = obj.getObject();
            if (!(base instanceof COSDictionary) || (type = (dict = (COSDictionary)base).getItem(COSName.TYPE)) == null || !type.equals(COSName.getPDFName("Annot")) || (subtype = dict.getItem(COSName.getPDFName("Subtype"))) == null || !subtype.equals(COSName.getPDFName("Widget")) || (fname = dict.getItem(COSName.getPDFName("T"))) == null || !fname.equals(name)) continue;
            dict.setItem(COSName.getPDFName("V"), (COSBase)value);
            dict.setItem(COSName.getPDFName("T"), (COSBase)new COSString(prefix + name.getString()));
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file1> <input-file2> <output-file> <name1> <value1> <name2> <value2>");
    }
}

