/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.WrappedIOException;
import org.pdfbox.pdfparser.BaseParser;
import org.pdfbox.pdfparser.PDFXref;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.fdf.FDFDocument;
import org.pdfbox.persistence.util.COSObjectKey;

public class PDFParser
extends BaseParser {
    private static final int SPACE_BYTE = 32;
    private static final String PDF_HEADER = "%PDF-";
    private COSDocument document;
    private File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
    private RandomAccessFile raf = null;

    public PDFParser(InputStream input) throws IOException {
        this(input, null);
    }

    public PDFParser(InputStream input, RandomAccessFile rafi) throws IOException {
        super(input);
        this.raf = rafi;
    }

    public void setTempDirectory(File tmpDir) {
        this.tempDirectory = tmpDir;
    }

    public void parse() throws IOException {
        try {
            this.document = this.raf == null ? new COSDocument(this.tempDirectory) : new COSDocument(this.raf);
            this.setDocument(this.document);
            String header = this.readLine();
            this.document.setHeaderString(header);
            if (header.length() < PDF_HEADER.length() + 1) {
                throw new IOException("Error: Header is corrupt '" + header + "'");
            }
            int headerStart = header.indexOf(PDF_HEADER);
            if (headerStart > 0) {
                header = header.substring(headerStart, header.length());
            }
            try {
                float pdfVersion = Float.parseFloat(header.substring(PDF_HEADER.length(), Math.min(header.length(), PDF_HEADER.length() + 3)));
                this.document.setVersion(pdfVersion);
            }
            catch (NumberFormatException e) {
                throw new IOException("Error getting pdf version:" + e);
            }
            this.skipHeaderFillBytes();
            boolean wasLastParsedObjectEOF = false;
            try {
                while (!this.pdfSource.isEOF()) {
                    wasLastParsedObjectEOF = this.parseObject();
                    this.skipSpaces();
                }
                if (this.document.getTrailer() == null) {
                    COSDictionary trailer = new COSDictionary();
                    Iterator xrefIter = this.document.getObjectsByType("XRef").iterator();
                    while (xrefIter.hasNext()) {
                        COSStream next = (COSStream)((COSObject)xrefIter.next()).getObject();
                        trailer.addAll(next);
                    }
                    this.document.setTrailer(trailer);
                }
                if (!this.document.isEncrypted()) {
                    this.document.dereferenceObjectStreams();
                }
            }
            catch (IOException e) {
                if (!wasLastParsedObjectEOF) {
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            if (this.document != null) {
                this.document.close();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new WrappedIOException(t);
        }
        finally {
            this.pdfSource.close();
        }
    }

    protected void skipHeaderFillBytes() throws IOException {
        this.skipSpaces();
        int c = this.pdfSource.peek();
        if (!Character.isDigit((char)c)) {
            this.readLine();
        }
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument());
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private boolean parseObject() throws IOException {
        boolean isEndOfFile = false;
        char peekedChar = (char)this.pdfSource.peek();
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x') {
                this.parseXrefTable();
            } else if (peekedChar == 't' || peekedChar == 's') {
                if (peekedChar == 't') {
                    this.parseTrailer();
                    peekedChar = (char)this.pdfSource.peek();
                }
                if (peekedChar == 's') {
                    this.parseStartXref();
                    String eof = this.readExpectedString("%%EOF");
                    if (eof.indexOf("%%EOF") == -1 && !this.pdfSource.isEOF()) {
                        throw new IOException("expected='%%EOF' actual='" + eof + "' next=" + this.readString() + " next=" + this.readString());
                    }
                    isEndOfFile = true;
                }
            } else {
                block16: {
                    int number;
                    String objectKey = null;
                    try {
                        number = this.readInt();
                    }
                    catch (IOException e) {
                        number = this.readInt();
                    }
                    this.skipSpaces();
                    int genNum = this.readInt();
                    objectKey = this.readString(3);
                    if (!objectKey.equals("obj")) {
                        throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                    }
                    this.skipSpaces();
                    COSBase pb = this.parseDirObject();
                    String endObjectKey = this.readString();
                    if (endObjectKey.equals("stream")) {
                        this.pdfSource.unread(endObjectKey.getBytes());
                        this.pdfSource.unread(32);
                        if (!(pb instanceof COSDictionary)) {
                            throw new IOException("stream not preceded by dictionary");
                        }
                        pb = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                        endObjectKey = this.readString();
                    }
                    COSObjectKey key = new COSObjectKey(number, genNum);
                    COSObject pdfObject = this.document.getObjectFromPool(key);
                    pdfObject.setObject(pb);
                    if (!endObjectKey.equals("endobj") && !this.pdfSource.isEOF()) {
                        try {
                            Float.parseFloat(endObjectKey);
                            this.pdfSource.unread(32);
                            this.pdfSource.unread(endObjectKey.getBytes());
                        }
                        catch (NumberFormatException e) {
                            String secondEndObjectKey = this.readString();
                            if (secondEndObjectKey.equals("endobj")) break block16;
                            throw new IOException("expected='endobj' firstReadAttempt='" + endObjectKey + "' " + "secondReadAttempt='" + secondEndObjectKey + "' " + this.pdfSource);
                        }
                    }
                }
                this.skipSpaces();
            }
        }
        return isEndOfFile;
    }

    private boolean parseStartXref() throws IOException {
        if (this.pdfSource.peek() != 115) {
            return false;
        }
        String nextLine = this.readLine();
        if (!nextLine.equals("startxref")) {
            return false;
        }
        this.skipSpaces();
        this.readInt();
        return true;
    }

    private boolean parseXrefTable() throws IOException {
        char c;
        if (this.pdfSource.peek() != 120) {
            return false;
        }
        String nextLine = this.readLine();
        if (!nextLine.equals("xref")) {
            return false;
        }
        do {
            int start = this.readInt();
            int count = this.readInt();
            this.skipSpaces();
            for (int i = 0; i < count && !this.pdfSource.isEOF() && !this.isEndOfName((char)this.pdfSource.peek()) && this.pdfSource.peek() != 116; ++i) {
                this.readLine();
                this.skipSpaces();
            }
            this.addXref(new PDFXref(start, count));
            this.skipSpaces();
        } while ((c = (char)this.pdfSource.peek()) >= '0' && c <= '9');
        return true;
    }

    private boolean parseTrailer() throws IOException {
        if (this.pdfSource.peek() != 116) {
            return false;
        }
        String nextLine = this.readLine();
        if (!nextLine.equals("trailer")) {
            return false;
        }
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        COSDictionary docTrailer = this.document.getTrailer();
        if (docTrailer == null) {
            this.document.setTrailer(parsedTrailer);
        } else {
            docTrailer.addAll(parsedTrailer);
        }
        this.skipSpaces();
        return true;
    }
}

