/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.remote.group.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.services.remote.group.Message;
import org.exoplatform.services.remote.group.MessageHandler;
import org.exoplatform.services.remote.group.MessageHandlerMonitor;
import org.jgroups.blocks.RequestHandler;

public class RequestHandlerImpl
implements RequestHandler {
    private Map messageHandlers_ = new HashMap();
    private Log log_;

    public RequestHandlerImpl(Log log) {
        this.log_ = log;
    }

    public void registerMessageHandler(MessageHandler handler) {
        this.messageHandlers_.put(handler.getIdentifier(), handler);
    }

    public Object handle(org.jgroups.Message jmessage) {
        Message message = (Message)jmessage.getObject();
        String handlerId = message.getTargetHandler();
        MessageHandler handler = (MessageHandler)this.messageHandlers_.get(handlerId);
        MessageHandlerMonitor monitor = handler.getMonitor();
        if (handler != null) {
            try {
                monitor.addMessageCounter(1);
                return handler.handle(message);
            }
            catch (Exception ex) {
                monitor.setLastError(ex);
                this.log_.error((Object)"Error :", (Throwable)ex);
                return null;
            }
        }
        this.log_.info((Object)("Cannot finf the message handler for the request handler: " + handlerId));
        return null;
    }

    public List getMessageHandlerMonitors() {
        ArrayList<MessageHandlerMonitor> monitors = new ArrayList<MessageHandlerMonitor>();
        for (MessageHandler handler : this.messageHandlers_.values()) {
            monitors.add(handler.getMonitor());
        }
        return monitors;
    }
}

