/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import org.hibernate.QueryException;

public final class HolderInstantiator {
    private final Constructor constructor;
    private final boolean returnMaps;
    private final boolean returnLists;
    private final String[] queryReturnAliases;

    public HolderInstantiator(Constructor constructor, boolean returnMaps, boolean returnLists, String[] queryReturnAliases) {
        this.constructor = constructor;
        this.returnLists = returnLists;
        this.returnMaps = returnMaps;
        this.queryReturnAliases = queryReturnAliases;
    }

    public boolean isRequired() {
        return this.constructor != null || this.returnLists || this.returnMaps;
    }

    public Object instantiate(Object[] row) {
        if (this.constructor != null) {
            try {
                return this.constructor.newInstance(row);
            }
            catch (Exception e) {
                throw new QueryException("could not instantiate: " + this.constructor.getDeclaringClass().getName(), e);
            }
        }
        if (this.returnMaps) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int j = 0; j < row.length; ++j) {
                map.put(this.queryReturnAliases[j], row[j]);
            }
            return map;
        }
        if (this.returnLists) {
            return Arrays.asList(row);
        }
        return row;
    }
}

