/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.impl.CacheServiceImpl;

@Managed
@NameTemplate(value={@Property(key="service", value="cachemanager")})
@ManagedDescription(value="Cache manager")
public class CacheServiceManaged
implements ManagementAware {
    private ManagementContext context;
    private CacheServiceImpl cacheService;

    public CacheServiceManaged(CacheServiceImpl cacheService) {
        this.cacheService = cacheService;
        cacheService.managed = this;
    }

    @Managed
    @ManagedDescription(value="Clear all registered cache instances")
    public void clearCaches() {
        for (Object o : this.cacheService.getAllCacheInstances()) {
            try {
                ((ExoCache)o).clearCache();
            }
            catch (Exception exception) {}
        }
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    void registerCache(ExoCache cache) {
        if (this.context != null) {
            this.context.register((Object)cache);
        }
    }
}

