/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.TwoWayRangeIterator;
import org.exoplatform.services.log.ExoLogger;

class NodeIteratorImpl
implements TwoWayRangeIterator,
ScoreNodeIterator {
    private static final Log log = ExoLogger.getLogger(NodeIteratorImpl.class);
    protected final ScoreNode[] scoreNodes;
    protected final SessionDataManager itemMgr;
    protected int pos = -1;
    protected int invalid = 0;
    private NodeImpl next;

    NodeIteratorImpl(SessionDataManager itemMgr, ScoreNode[] scoreNodes) {
        this.itemMgr = itemMgr;
        this.scoreNodes = scoreNodes;
        this.fetchNext();
    }

    public Node nextNode() throws NoSuchElementException {
        return this.nextNodeImpl();
    }

    public Object next() throws NoSuchElementException {
        return this.nextNode();
    }

    public NodeImpl nextNodeImpl() throws NoSuchElementException {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.next;
        this.fetchNext();
        return n;
    }

    public void skip(long skipNum) throws NoSuchElementException {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if ((long)this.pos + skipNum > (long)this.scoreNodes.length) {
            throw new NoSuchElementException();
        }
        if (skipNum != 0L) {
            this.pos = (int)((long)this.pos + (skipNum - 1L));
            this.fetchNext();
        }
    }

    public void skipBack(long skipNum) {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if ((long)this.pos - skipNum < 0L) {
            throw new NoSuchElementException();
        }
        if (skipNum > 0L) {
            this.pos = (int)((long)this.pos - (skipNum + 1L));
            this.fetchNext();
        }
    }

    public long getSize() {
        return this.scoreNodes.length - this.invalid;
    }

    public long getPosition() {
        return this.pos - this.invalid;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public float getScore() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.scoreNodes[this.pos].getScore();
    }

    protected void fetchNext() {
        this.next = null;
        while (this.next == null && this.pos + 1 < this.scoreNodes.length) {
            try {
                this.next = (NodeImpl)this.itemMgr.getItemByIdentifier(this.scoreNodes[this.pos + 1].getNodeId(), true);
                if (this.next != null) continue;
                ++this.invalid;
                ++this.pos;
            }
            catch (RepositoryException e) {
                log.warn((Object)("Exception retrieving Node with UUID: " + this.scoreNodes[this.pos + 1].getNodeId() + ": " + e.toString()));
                ++this.invalid;
                ++this.pos;
            }
        }
        ++this.pos;
    }
}

