/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FileStreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;

public class CleanableFileStreamValueData
extends FileStreamPersistedValueData {
    protected final FileCleaner cleaner;

    public CleanableFileStreamValueData(SwapFile file, int orderNumber, FileCleaner cleaner) throws FileNotFoundException {
        super(file, orderNumber);
        this.cleaner = cleaner;
        file.acquire(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            ((SwapFile)this.file).release(this);
            if (!this.file.delete()) {
                this.cleaner.addFile(this.file);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u00d1ould not remove temporary file on finalize: inUse=" + ((SwapFile)this.file).inUse() + ", " + this.file.getAbsolutePath()));
                }
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        try {
            return new TransientValueData(this.orderNumber, null, null, this.file, this.cleaner, -1, null, true);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

