/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class SetterInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient InstantiatingComponentAdapter.Guard instantiationGuard;
    private transient List setters;
    private transient List setterNames;
    private transient Class[] setterTypes;

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses);
    }

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, false);
    }

    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor = this.getConstructor();
        this.getMatchingParameterListForSetters(container);
        return constructor;
    }

    private Constructor getConstructor() throws PicoInvocationTargetInitializationException {
        Constructor constructor;
        try {
            constructor = this.getComponentImplementation().getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        catch (SecurityException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        return constructor;
    }

    private Parameter[] getMatchingParameterListForSetters(PicoContainer container) throws PicoInitializationException, UnsatisfiableDependenciesException {
        if (this.setters == null) {
            this.initializeSetterAndTypeLists();
        }
        ArrayList<Object> matchingParameterList = new ArrayList<Object>(Collections.nCopies(this.setters.size(), null));
        HashSet<Integer> nonMatchingParameterPositions = new HashSet<Integer>();
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(this.setterTypes);
        int i = 0;
        while (i < currentParameters.length) {
            Parameter parameter = currentParameters[i];
            boolean failedDependency = true;
            int j = 0;
            while (j < this.setterTypes.length) {
                if (matchingParameterList.get(j) == null && parameter.isResolvable(container, this, this.setterTypes[j])) {
                    matchingParameterList.set(j, parameter);
                    failedDependency = false;
                    break;
                }
                ++j;
            }
            if (failedDependency) {
                nonMatchingParameterPositions.add(new Integer(i));
            }
            ++i;
        }
        HashSet<Class> unsatisfiableDependencyTypes = new HashSet<Class>();
        int i2 = 0;
        while (i2 < matchingParameterList.size()) {
            if (matchingParameterList.get(i2) == null) {
                unsatisfiableDependencyTypes.add(this.setterTypes[i2]);
            }
            ++i2;
        }
        if (unsatisfiableDependencyTypes.size() > 0) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiableDependencyTypes);
        }
        if (nonMatchingParameterPositions.size() > 0) {
            throw new PicoInitializationException("Following parameters do not match any of the setters for " + this.getComponentImplementation() + ": " + ((Object)nonMatchingParameterPositions).toString());
        }
        return matchingParameterList.toArray(new Parameter[matchingParameterList.size()]);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        final Constructor constructor = this.getConstructor();
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new InstantiatingComponentAdapter.Guard(){

                public Object run() {
                    Parameter[] matchingParameters = SetterInjectionComponentAdapter.this.getMatchingParameterListForSetters(this.guardedContainer);
                    try {
                        Object componentInstance = SetterInjectionComponentAdapter.this.newInstance(constructor, null);
                        int i = 0;
                        while (i < SetterInjectionComponentAdapter.this.setters.size()) {
                            Method setter = (Method)SetterInjectionComponentAdapter.this.setters.get(i);
                            setter.invoke(componentInstance, matchingParameters[i].resolveInstance(this.guardedContainer, SetterInjectionComponentAdapter.this, SetterInjectionComponentAdapter.this.setterTypes[i]));
                            ++i;
                        }
                        return componentInstance;
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(e.getTargetException());
                    }
                    catch (InstantiationException e) {
                        throw new PicoInvocationTargetInitializationException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PicoInvocationTargetInitializationException(e);
                    }
                }
            };
        }
        this.instantiationGuard.setArguments(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    public void verify(final PicoContainer container) throws PicoIntrospectionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new InstantiatingComponentAdapter.Guard(){

                public Object run() {
                    Parameter[] currentParameters = SetterInjectionComponentAdapter.this.getMatchingParameterListForSetters(this.guardedContainer);
                    int i = 0;
                    while (i < currentParameters.length) {
                        currentParameters[i].verify(container, SetterInjectionComponentAdapter.this, SetterInjectionComponentAdapter.this.setterTypes[i]);
                        ++i;
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setArguments(container);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    private void initializeSetterAndTypeLists() {
        this.setters = new ArrayList();
        this.setterNames = new ArrayList();
        ArrayList typeList = new ArrayList();
        Method[] methods = this.getComponentImplementation().getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1) {
                boolean isBeanStyle;
                String methodName = method.getName();
                boolean bl = isBeanStyle = methodName.length() >= 4 && methodName.startsWith("set") && Character.isUpperCase(methodName.charAt(3));
                if (isBeanStyle) {
                    String attribute = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
                    this.setters.add(method);
                    this.setterNames.add(attribute);
                    typeList.add(parameterTypes[0]);
                }
            }
            ++i;
        }
        this.setterTypes = typeList.toArray(new Class[0]);
    }
}

