/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class SetterIntrospector {
    public Map getSetters(Class clazz) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (this.isSetter(method)) {
                result.put(this.getPropertyName(method), method);
            }
            ++i;
        }
        return result;
    }

    private String getPropertyName(Method method) {
        String name = method.getName();
        String result = name.substring(3);
        if (result.length() > 1 && !Character.isUpperCase(result.charAt(1))) {
            result = Character.toLowerCase(result.charAt(0)) + result.substring(1);
        } else if (result.length() == 1) {
            result = result.toLowerCase();
        }
        return result;
    }

    private boolean isSetter(Method method) {
        String name = method.getName();
        return name.length() > 3 && name.startsWith("set") && method.getParameterTypes().length == 1;
    }
}

