/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.htmlparser.Parser;
import org.htmlparser.beans.StringBean;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class HTMLDocumentReader
extends BaseDocumentReader {
    public HTMLDocumentReader(InitParams params) {
    }

    public String[] getMimeTypes() {
        return new String[]{"text/html"};
    }

    public String getContentAsText(InputStream is) throws Exception {
        String refined_text = new String();
        try {
            int len;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((len = is.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bos.close();
            String html = new String(bos.toByteArray());
            Parser parser = Parser.createParser((String)html, null);
            StringBean sb = new StringBean();
            parser.visitAllNodesWith((NodeVisitor)sb);
            String text = sb.getStrings();
            refined_text = text != null ? text : "";
        }
        catch (IOException e) {
            return new String("");
        }
        catch (ParserException e) {
            return new String("");
        }
        return refined_text;
    }

    public String getContentAsText(InputStream is, String encoding) throws Exception {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws Exception {
        return new Properties();
    }

    private String delete(String str) {
        try {
            StringBuffer input = new StringBuffer(str);
            String patternString = "<+[^>]*>+";
            Pattern pattern = Pattern.compile(patternString, 34);
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                input.delete(start, end);
                matcher = pattern.matcher(input);
            }
            return input.substring(0, input.length());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return "";
        }
    }
}

