/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class MSExcelDocumentReader
extends BaseDocumentReader {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");

    public String[] getMimeTypes() {
        return new String[]{"application/excel", "application/xls"};
    }

    public String getContentAsText(InputStream is) throws Exception {
        String text = "";
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            for (int sheetNum = 0; sheetNum < wb.getNumberOfSheets(); ++sheetNum) {
                HSSFSheet sheet = wb.getSheetAt(sheetNum);
                if (sheet == null) continue;
                for (int rowNum = sheet.getFirstRowNum(); rowNum <= sheet.getLastRowNum(); ++rowNum) {
                    HSSFRow row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    int lastcell = row.getLastCellNum();
                    block11: for (int k = 0; k < lastcell; ++k) {
                        HSSFCell cell = row.getCell((short)k);
                        if (cell == null) continue;
                        switch (cell.getCellType()) {
                            case 0: {
                                double d = cell.getNumericCellValue();
                                if (MSExcelDocumentReader.isCellDateFormatted(cell)) {
                                    Date date = HSSFDateUtil.getJavaDate((double)d);
                                    String cellText = DATE_FORMAT.format(date);
                                    text = text + cellText + " ";
                                    continue block11;
                                }
                                text = text + d + " ";
                                continue block11;
                            }
                            case 2: {
                                text = text + cell.getCellFormula().toString() + " ";
                                continue block11;
                            }
                            case 4: {
                                text = text + cell.getBooleanCellValue() + " ";
                                continue block11;
                            }
                            case 5: {
                                text = text + cell.getErrorCellValue() + " ";
                                continue block11;
                            }
                            case 1: {
                                text = text + cell.getStringCellValue().toString() + " ";
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public String getContentAsText(InputStream is, String encoding) throws Exception {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws Exception {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties(is);
        return reader.getProperties();
    }

    public static boolean isCellDateFormatted(HSSFCell cell) {
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate((double)d)) {
            HSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            switch (i) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 45: 
                case 46: 
                case 47: 
                case 165: 
                case 167: 
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: {
                    bDate = true;
                    break;
                }
                default: {
                    bDate = false;
                }
            }
        }
        return bDate;
    }
}

