/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Array;

public class Utils {
    public static Class loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("null");
        }
        if ((name = name.trim()).equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("java.lang.String")) {
            return String.class;
        }
        if (name.equals("java.lang.Object")) {
            return Object.class;
        }
        if (name.startsWith("[")) {
            int dimension = 0;
            while (name.charAt(dimension) == '[') {
                ++dimension;
            }
            char type = name.charAt(dimension);
            Class cls = null;
            switch (type) {
                case 'Z': {
                    cls = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    cls = Byte.TYPE;
                    break;
                }
                case 'C': {
                    cls = Character.TYPE;
                    break;
                }
                case 'S': {
                    cls = Short.TYPE;
                    break;
                }
                case 'I': {
                    cls = Integer.TYPE;
                    break;
                }
                case 'J': {
                    cls = Long.TYPE;
                    break;
                }
                case 'F': {
                    cls = Float.TYPE;
                    break;
                }
                case 'D': {
                    cls = Double.TYPE;
                    break;
                }
                case 'L': {
                    String n = name.substring(dimension + 1, name.length() - 1);
                    cls = Utils.loadClass(loader, n);
                }
            }
            if (cls == null) {
                throw new ClassNotFoundException(name);
            }
            int[] dim = new int[dimension];
            return Array.newInstance(cls, dim).getClass();
        }
        if (loader != null) {
            return loader.loadClass(name);
        }
        return Class.forName(name, false, null);
    }

    public static Class[] loadClasses(ClassLoader loader, String[] names) throws ClassNotFoundException {
        int n = names.length;
        Class[] cls = new Class[n];
        for (int i = 0; i < n; ++i) {
            String name = names[i];
            cls[i] = Utils.loadClass(loader, name);
        }
        return cls;
    }

    public static boolean arrayEquals(Object[] arr1, Object[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null ^ arr2 == null) {
            return false;
        }
        if (!arr1.getClass().equals(arr2.getClass())) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            Object obj2;
            Object obj1 = arr1[i];
            if (obj1 == null ^ (obj2 = arr2[i]) == null) {
                return false;
            }
            if (obj1 == null || obj1.equals(obj2)) continue;
            return false;
        }
        return true;
    }
}

