/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomReader
implements HierarchicalStreamReader {
    private Element currentElement;
    private StringBuffer textBuffer;
    private NodeList childNodes;
    private LinkedList pointers = new LinkedList();
    private List childElements;

    public DomReader(Element element) {
        this.textBuffer = new StringBuffer(180);
        this.pointers.addLast(new Pointer());
        this.setCurrent(element);
    }

    public DomReader(Document document) {
        this.textBuffer = new StringBuffer(180);
        this.pointers.addLast(new Pointer());
        this.setCurrent(document.getDocumentElement());
    }

    public String getNodeName() {
        return this.currentElement.getTagName();
    }

    public String getValue() {
        NodeList nodeList = this.currentElement.getChildNodes();
        this.textBuffer.setLength(0);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            this.textBuffer.append(text.getData());
        }
        return this.textBuffer.toString();
    }

    public String getAttribute(String string) {
        Attr attr = this.currentElement.getAttributeNode(string);
        return attr == null ? null : attr.getValue();
    }

    public Object peekUnderlyingNode() {
        return this.currentElement;
    }

    private void setCurrent(Object object) {
        this.currentElement = (Element)object;
        this.childNodes = this.currentElement.getChildNodes();
        this.childElements = new ArrayList();
        for (int i = 0; i < this.childNodes.getLength(); ++i) {
            Node node = this.childNodes.item(i);
            if (!(node instanceof Element)) continue;
            this.childElements.add(node);
        }
    }

    public boolean hasMoreChildren() {
        Pointer pointer = (Pointer)this.pointers.getLast();
        return pointer.v < this.childElements.size();
    }

    public void moveUp() {
        this.setCurrent(this.currentElement.getParentNode());
        this.pointers.removeLast();
    }

    public void moveDown() {
        Pointer pointer = (Pointer)this.pointers.getLast();
        this.pointers.addLast(new Pointer());
        this.setCurrent(this.childElements.get(pointer.v));
        ++pointer.v;
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    private class Pointer {
        public int v;

        private Pointer() {
        }
    }
}

