/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.intercept;

import java.io.Serializable;
import java.util.Set;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class FieldInterceptor
implements InterceptFieldCallback,
Serializable {
    private transient SessionImplementor session;
    private Set uninitializedFields;
    private final String entityName;
    private transient boolean initializing;
    private boolean dirty;

    private FieldInterceptor(SessionImplementor session, String entityName, Set uninitializedFields) {
        this.session = session;
        this.entityName = entityName;
        this.uninitializedFields = uninitializedFields;
    }

    public void setSession(SessionImplementor session) {
        this.session = session;
    }

    public boolean isInitialized() {
        return this.uninitializedFields == null || this.uninitializedFields.size() == 0;
    }

    public boolean isInitialized(String field) {
        return this.uninitializedFields == null || !this.uninitializedFields.contains(field);
    }

    public void dirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object intercept(Object target, String fieldName, Object value) {
        if (this.initializing) {
            return value;
        }
        if (this.uninitializedFields != null && this.uninitializedFields.contains(fieldName)) {
            Object result;
            if (this.session == null) {
                throw new LazyInitializationException("entity with lazy properties is not associated with a session");
            }
            if (!this.session.isOpen() || !this.session.isConnected()) {
                throw new LazyInitializationException("session is not connected");
            }
            this.initializing = true;
            try {
                result = ((LazyPropertyInitializer)((Object)this.session.getFactory().getEntityPersister(this.entityName))).initializeLazyProperty(fieldName, target, this.session);
            }
            finally {
                this.initializing = false;
            }
            this.uninitializedFields = null;
            return result;
        }
        return value;
    }

    public boolean readBoolean(Object target, String name, boolean oldValue) {
        return (Boolean)this.intercept(target, name, oldValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public byte readByte(Object target, String name, byte oldValue) {
        return (Byte)this.intercept(target, name, new Byte(oldValue));
    }

    public char readChar(Object target, String name, char oldValue) {
        return ((Character)this.intercept(target, name, new Character(oldValue))).charValue();
    }

    public double readDouble(Object target, String name, double oldValue) {
        return (Double)this.intercept(target, name, new Double(oldValue));
    }

    public float readFloat(Object target, String name, float oldValue) {
        return ((Float)this.intercept(target, name, new Float(oldValue))).floatValue();
    }

    public int readInt(Object target, String name, int oldValue) {
        return (Integer)this.intercept(target, name, new Integer(oldValue));
    }

    public long readLong(Object target, String name, long oldValue) {
        return (Long)this.intercept(target, name, new Long(oldValue));
    }

    public short readShort(Object target, String name, short oldValue) {
        return (Short)this.intercept(target, name, new Short(oldValue));
    }

    public Object readObject(Object target, String name, Object oldValue) {
        LazyInitializer li;
        Object value = this.intercept(target, name, oldValue);
        if (value instanceof HibernateProxy && (li = ((HibernateProxy)value).getHibernateLazyInitializer()).isUnwrap()) {
            value = li.getImplementation();
        }
        return value;
    }

    public boolean writeBoolean(Object target, String name, boolean oldValue, boolean newValue) {
        this.dirty();
        this.intercept(target, name, oldValue ? Boolean.TRUE : Boolean.FALSE);
        return newValue;
    }

    public byte writeByte(Object target, String name, byte oldValue, byte newValue) {
        this.dirty();
        this.intercept(target, name, new Byte(oldValue));
        return newValue;
    }

    public char writeChar(Object target, String name, char oldValue, char newValue) {
        this.dirty();
        this.intercept(target, name, new Character(oldValue));
        return newValue;
    }

    public double writeDouble(Object target, String name, double oldValue, double newValue) {
        this.dirty();
        this.intercept(target, name, new Double(oldValue));
        return newValue;
    }

    public float writeFloat(Object target, String name, float oldValue, float newValue) {
        this.dirty();
        this.intercept(target, name, new Float(oldValue));
        return newValue;
    }

    public int writeInt(Object target, String name, int oldValue, int newValue) {
        this.dirty();
        this.intercept(target, name, new Integer(oldValue));
        return newValue;
    }

    public long writeLong(Object target, String name, long oldValue, long newValue) {
        this.dirty();
        this.intercept(target, name, new Long(oldValue));
        return newValue;
    }

    public short writeShort(Object target, String name, short oldValue, short newValue) {
        this.dirty();
        this.intercept(target, name, new Short(oldValue));
        return newValue;
    }

    public Object writeObject(Object target, String name, Object oldValue, Object newValue) {
        this.dirty();
        this.intercept(target, name, oldValue);
        return newValue;
    }

    public String toString() {
        return "FieldInterceptor(entityName=" + this.entityName + ",dirty=" + this.dirty + ",uninitializedFields=" + this.uninitializedFields + ')';
    }

    public static void clearDirty(Object entity) {
        if (FieldInterceptor.hasInterceptor(entity)) {
            FieldInterceptor.getFieldInterceptor(entity).clearDirty();
        }
    }

    public static boolean hasInterceptor(Object entity) {
        return entity instanceof InterceptFieldEnabled && ((InterceptFieldEnabled)entity).getInterceptFieldCallback() != null;
    }

    public static FieldInterceptor getFieldInterceptor(Object entity) {
        return (FieldInterceptor)((InterceptFieldEnabled)entity).getInterceptFieldCallback();
    }

    public static FieldInterceptor initFieldInterceptor(Object entity, String entityName, SessionImplementor session, Set lazyProps) {
        FieldInterceptor fieldInterceptor = new FieldInterceptor(session, entityName, lazyProps);
        ((InterceptFieldEnabled)entity).setInterceptFieldCallback((InterceptFieldCallback)fieldInterceptor);
        return fieldInterceptor;
    }
}

