/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ObjectQuery {
    private static SimpleDateFormat ft_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Class type_;
    private String orderBy_;
    private String groupBy_;
    private List<Parameter> parameters_;
    private List<Parameter> selectParameter_;

    public ObjectQuery(Class type) {
        this.type_ = type;
        this.parameters_ = new ArrayList<Parameter>(3);
        this.selectParameter_ = new ArrayList<Parameter>(10);
    }

    public ObjectQuery addEQ(String field, Object value) {
        if (value != null) {
            this.parameters_.add(new Parameter(" = ", field, value));
        }
        return this;
    }

    public ObjectQuery addGT(String field, Object value) {
        if (value != null) {
            this.parameters_.add(new Parameter(" > ", field, value));
        }
        return this;
    }

    public ObjectQuery addLT(String field, Object value) {
        if (value != null) {
            this.parameters_.add(new Parameter(" < ", field, value));
        }
        return this;
    }

    public ObjectQuery addLIKE(String field, String value) {
        if (value != null && value.length() > 0) {
            this.parameters_.add(new Parameter(" LIKE ", field, this.optimizeInputString(value)));
        }
        return this;
    }

    public String optimizeInputString(String value) {
        value = value.replace('*', '%');
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("<", "&#60;");
        value = value.replaceAll(">", "&#62;");
        return value;
    }

    public ObjectQuery addSUM(String field) {
        this.selectParameter_.add(new Parameter("SUM", field));
        return this;
    }

    public ObjectQuery addSelect(String field) {
        this.selectParameter_.add(new Parameter("FIELDSELECT", field));
        return this;
    }

    public ObjectQuery addSelectCount(String type) {
        this.selectParameter_.add(new Parameter("COUNTSELECT", type));
        return this;
    }

    public ObjectQuery addSelectMaxMin(String op, String field) {
        this.selectParameter_.add(new Parameter(op, field));
        return this;
    }

    public ObjectQuery setGroupBy(String field) {
        this.groupBy_ = " GROUP BY o." + field;
        return this;
    }

    public ObjectQuery setAscOrderBy(String field) {
        this.orderBy_ = " ORDER BY o." + field + " asc";
        return this;
    }

    public ObjectQuery setDescOrderBy(String field) {
        this.orderBy_ = " ORDER BY o." + field + " desc";
        return this;
    }

    public String getHibernateQuery() {
        StringBuffer b = new StringBuffer();
        b.append("from o in class ").append(this.type_.getName());
        if (this.parameters_.size() > 0) {
            b.append(" WHERE ");
            for (int i = 0; i < this.parameters_.size(); ++i) {
                if (i > 0) {
                    b.append(" AND ");
                }
                Parameter p = this.parameters_.get(i);
                if (p.value_ instanceof String) {
                    if (p.field_.startsWith("UPPER") || p.field_.startsWith("LOWER")) {
                        b.append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                        continue;
                    }
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                    continue;
                }
                if (p.value_ instanceof Date) {
                    String value = ft_.format((Date)p.value_);
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(value).append("'");
                    continue;
                }
                b.append(" o.").append(p.field_).append(p.op_).append(p.value_);
            }
        }
        if (this.orderBy_ != null) {
            b.append(this.orderBy_);
        }
        return b.toString();
    }

    public String getHibernateGroupByQuery() {
        Parameter p;
        int i;
        StringBuffer b = new StringBuffer();
        b.append("select ");
        if (this.selectParameter_.size() > 0) {
            for (i = 0; i < this.selectParameter_.size(); ++i) {
                p = this.selectParameter_.get(i);
                if (p.op_.equals("fieldselect")) {
                    b.append("o.").append(p.field_);
                } else if (p.op_.equals("countselect")) {
                    b.append("COUNT");
                    if (p.field_ != "" || p.field_.length() > 0) {
                        b.append("(").append(p.field_).append(" o)");
                    } else {
                        b.append("(o)");
                    }
                } else {
                    b.append(p.op_).append("(").append("o.").append(p.field_).append(") ");
                }
                if (i >= this.selectParameter_.size() - 1) continue;
                b.append(" , ");
            }
        }
        b.append(" from o in class ").append(this.type_.getName());
        if (this.parameters_.size() > 0) {
            b.append(" where ");
            for (i = 0; i < this.parameters_.size(); ++i) {
                if (i > 0) {
                    b.append(" and ");
                }
                p = this.parameters_.get(i);
                if (p.value_ instanceof String) {
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                    continue;
                }
                if (p.value_ instanceof Date) {
                    String value = ft_.format((Date)p.value_);
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(value).append("'");
                    continue;
                }
                if (p.op_.equals("MAX") || p.op_.equals("MIN")) {
                    b.append(p.op_).append("(").append("o.").append(p.field_).append(") ");
                    continue;
                }
                b.append(" o.").append(p.field_).append(p.op_).append(p.value_);
            }
        }
        if (this.groupBy_ != null) {
            b.append(this.groupBy_);
        }
        if (this.orderBy_ != null) {
            b.append(this.orderBy_);
        }
        return b.toString();
    }

    public String getHibernateCountQuery() {
        StringBuffer b = new StringBuffer();
        b.append("SELECT COUNT(o) FROM o IN CLASS ").append(this.type_.getName());
        if (this.parameters_.size() > 0) {
            b.append(" WHERE ");
            for (int i = 0; i < this.parameters_.size(); ++i) {
                if (i > 0) {
                    b.append(" AND ");
                }
                Parameter p = this.parameters_.get(i);
                if (p.value_ instanceof String) {
                    if (p.field_.startsWith("UPPER") || p.field_.startsWith("LOWER")) {
                        b.append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                        continue;
                    }
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                    continue;
                }
                if (p.value_ instanceof Date) {
                    String value = ft_.format((Date)p.value_);
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(value).append("'");
                    continue;
                }
                b.append(" o.").append(p.field_).append(p.op_).append(p.value_);
            }
        }
        return b.toString();
    }

    static class Parameter {
        String op_;
        String field_;
        String label_;
        Object value_;

        Parameter(String op, String field, Object value) {
            this.op_ = op;
            this.field_ = field;
            this.value_ = value;
        }

        Parameter(String op, String field) {
            this.op_ = op;
            this.field_ = field;
        }
    }
}

