/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.util.StringNumberParser;
import org.exoplatform.services.log.ExoLogger;

public abstract class MappedParametrizedObjectEntry {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.MappedParametrizedObjectEntry");
    protected String type;
    protected List parameters;

    public MappedParametrizedObjectEntry() {
        this.parameters = new ArrayList();
    }

    public MappedParametrizedObjectEntry(String type, List params) {
        this.type = type;
        this.parameters = params;
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String name) throws RepositoryConfigurationException {
        String value = this.getParameterValue(name, null);
        if (value == null) {
            throw new RepositoryConfigurationException("Parameter " + name + " not found ");
        }
        return value;
    }

    public String getParameterValue(String name, String defaultValue) {
        String value = defaultValue;
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = (SimpleParameterEntry)this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            value = p.getValue();
            break;
        }
        return value;
    }

    public Integer getParameterInteger(String name, Integer defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = (SimpleParameterEntry)this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            try {
                return StringNumberParser.parseInt(p.getValue());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)(name + ": unparseable Integer. " + e));
            }
        }
        return defaultValue;
    }

    public Integer getParameterInteger(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseInt(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable Integer. " + e, e);
        }
    }

    public Long getParameterLong(String name, Long defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = (SimpleParameterEntry)this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            try {
                return StringNumberParser.parseLong(p.getValue());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)(name + ": unparseable Long. " + e));
            }
        }
        return defaultValue;
    }

    public Long getParameterLong(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseLong(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable Long. " + e, e);
        }
    }

    public Long getParameterTime(String name, Long defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = (SimpleParameterEntry)this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            try {
                return StringNumberParser.parseTime(p.getValue());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)(name + ": unparseable time (as Long). " + e));
            }
        }
        return defaultValue;
    }

    public Long getParameterTime(String name) throws RepositoryConfigurationException {
        try {
            return StringNumberParser.parseTime(this.getParameterValue(name));
        }
        catch (NumberFormatException e) {
            throw new RepositoryConfigurationException(name + ": unparseable time (as Long). " + e, e);
        }
    }

    public Boolean getParameterBoolean(String name, Boolean defaultValue) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            SimpleParameterEntry p = (SimpleParameterEntry)this.parameters.get(i);
            if (!p.getName().equals(name)) continue;
            return new Boolean(p.getValue());
        }
        return defaultValue;
    }

    public Boolean getParameterBoolean(String name) throws RepositoryConfigurationException {
        return new Boolean(this.getParameterValue(name));
    }

    public String getType() {
        return this.type;
    }

    public void setParameters(List parameters) {
        this.parameters = parameters;
    }

    public void setType(String type) {
        this.type = type;
    }
}

