/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.config.ConfigurationPersister;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;

public class JDBCConfigurationPersister
implements ConfigurationPersister {
    public static final String PARAM_SOURCE_NAME = "source-name";
    public static final String PARAM_DIALECT = "dialect";
    protected static final String CONFIGNAME = "REPOSITORY-SERVICE-WORKING-CONFIG";
    protected static final String C_DATA = "CONFIGDATA";
    protected String configTableName = "JCR_CONFIG";
    protected String sourceName;
    protected String initSQL;

    public void init(PropertiesParam params) throws RepositoryConfigurationException {
        String sourceNameParam = params.getProperty(PARAM_SOURCE_NAME);
        if (sourceNameParam == null && (sourceNameParam = params.getProperty("sourceName")) == null) {
            throw new RepositoryConfigurationException("Repository service configuration. Source name (source-name) is expected");
        }
        String dialectParam = params.getProperty(PARAM_DIALECT);
        this.sourceName = sourceNameParam;
        String binType = "BLOB";
        if (dialectParam != null) {
            if (dialectParam.equalsIgnoreCase(DBConstants.DB_DIALECT_GENERIC) || dialectParam.equalsIgnoreCase(DBConstants.DB_DIALECT_HSQLDB)) {
                binType = "VARBINARY(102400)";
            } else if (dialectParam.equalsIgnoreCase(DBConstants.DB_DIALECT_PGSQL)) {
                this.configTableName = this.configTableName.toUpperCase().toLowerCase();
                binType = "BYTEA";
            } else if (dialectParam.equalsIgnoreCase(DBConstants.DB_DIALECT_MSSQL)) {
                binType = "VARBINARY(max)";
            } else if (dialectParam.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) {
                binType = "VARBINARY(255)";
            }
        }
        this.initSQL = "CREATE TABLE " + this.configTableName + " (" + "NAME VARCHAR(64) NOT NULL, " + "CONFIG " + binType + " NOT NULL, " + "CONSTRAINT JCR_CONFIG_PK PRIMARY KEY(NAME))";
    }

    protected void checkInitialized() throws RepositoryConfigurationException {
        if (this.sourceName == null) {
            throw new RepositoryConfigurationException("Repository service configuration persister isn not initialized. Call init() before.");
        }
    }

    protected Connection openConnection() throws NamingException, SQLException {
        DataSource ds = (DataSource)new InitialContext().lookup(this.sourceName);
        return ds.getConnection();
    }

    protected boolean isDbInitialized(Connection con) {
        try {
            ResultSet trs = con.getMetaData().getTables(null, null, this.configTableName, null);
            return trs.next();
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasConfig() throws RepositoryConfigurationException {
        this.checkInitialized();
        try {
            Connection con;
            block5: {
                boolean bl;
                con = this.openConnection();
                if (!this.isDbInitialized(con)) return false;
                PreparedStatement ps = con.prepareStatement("SELECT COUNT(*) FROM " + this.configTableName + " WHERE NAME=?");
                try {
                    ps.setString(1, CONFIGNAME);
                    ResultSet res = ps.executeQuery();
                    if (!res.next()) break block5;
                    bl = res.getInt(1) > 0;
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    con.close();
                    throw throwable;
                }
                con.close();
                return bl;
            }
            Object var6_8 = null;
            con.close();
            return false;
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream read() throws RepositoryConfigurationException {
        this.checkInitialized();
        try {
            InputStream inputStream;
            Connection con = this.openConnection();
            try {
                if (!this.isDbInitialized(con)) {
                    throw new ConfigurationNotInitializedException("Configuration table not is found in database. Source name " + this.sourceName);
                }
                PreparedStatement ps = con.prepareStatement("SELECT * FROM " + this.configTableName + " WHERE name=?");
                ps.setString(1, CONFIGNAME);
                ResultSet res = ps.executeQuery();
                if (!res.next()) {
                    throw new ConfigurationNotFoundException("No configuration data is found in database. Source name " + this.sourceName);
                }
                ConfigDataHolder config = new ConfigDataHolder(res.getBinaryStream("config"));
                inputStream = config.getStream();
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                con.close();
                throw throwable;
            }
            con.close();
            return inputStream;
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Configuration read exception. " + e, e);
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream confData) throws RepositoryConfigurationException {
        this.checkInitialized();
        String sql = null;
        try {
            Connection con = this.openConnection();
            try {
                con.setAutoCommit(false);
                if (!this.isDbInitialized(con)) {
                    sql = this.initSQL;
                    con.createStatement().executeUpdate(sql);
                    con.commit();
                    con.close();
                    con = this.openConnection();
                    con.setAutoCommit(false);
                }
                if (this.isDbInitialized(con)) {
                    PreparedStatement ps = null;
                    ConfigDataHolder config = new ConfigDataHolder(confData);
                    if (this.hasConfig()) {
                        sql = "UPDATE " + this.configTableName + " SET CONFIG=? WHERE NAME=?";
                        ps = con.prepareStatement(sql);
                        ps.setBinaryStream(1, config.getStream(), config.getLength());
                        ps.setString(2, CONFIGNAME);
                    } else {
                        sql = "INSERT INTO " + this.configTableName + " (NAME, CONFIG) VALUES (?,?)";
                        ps = con.prepareStatement(sql);
                        ps.setString(1, CONFIGNAME);
                        ps.setBinaryStream(2, config.getStream(), config.getLength());
                    }
                    if (ps.executeUpdate() <= 0) {
                        System.out.println(this.getClass().getCanonicalName() + " [WARN] Repository service configuration doesn't stored ok. No rows was affected in JDBC operation. Datasource " + this.sourceName + ". SQL: " + sql);
                    }
                } else {
                    throw new ConfigurationNotInitializedException("Configuration table can not be created in database. Source name " + this.sourceName + ". SQL: " + sql);
                }
                con.commit();
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                con.close();
                throw throwable;
            }
            con.close();
            {
            }
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Configuration read exception. " + e, e);
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e + ". SQL: " + sql, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    protected class ConfigDataHolder {
        private final byte[] config;

        ConfigDataHolder(InputStream source) throws IOException {
            ByteArrayOutputStream configOut = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int read = 0;
            while ((read = source.read(b)) > 0) {
                configOut.write(b, 0, read);
            }
            this.config = configOut.toByteArray();
        }

        InputStream getStream() {
            return new ByteArrayInputStream(this.config);
        }

        int getLength() {
            return this.config.length;
        }
    }

    public class ConfigurationNotInitializedException
    extends RepositoryConfigurationException {
        ConfigurationNotInitializedException(String m) {
            super(m);
        }
    }

    public class ConfigurationNotFoundException
    extends RepositoryConfigurationException {
        ConfigurationNotFoundException(String m) {
            super(m);
        }
    }
}

