/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.multi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.rmi.exception.NoSuchObjectExceptionHelper;
import org.objectweb.carol.rmi.exception.RemoteExceptionHelper;
import org.objectweb.carol.rmi.util.PortNumber;
import org.objectweb.carol.util.configuration.ConfigurationRepository;

public class JeremiePRODelegate
implements PortableRemoteObjectDelegate {
    private static final String JEREMIE_STUB_EXTENSION = "_OWStub";
    private int port;
    private static final String JEREMIE_UNICAST_CLASS = "org.objectweb.jeremie.binding.moa.UnicastRemoteObject";
    private static Class unicastClass = null;
    private static int nbProtocols = 0;
    static /* synthetic */ Class class$java$rmi$Remote;

    public JeremiePRODelegate() throws ClassNotFoundException {
        unicastClass = Thread.currentThread().getContextClassLoader().loadClass(JEREMIE_UNICAST_CLASS);
        Properties prop = ConfigurationRepository.getProperties();
        if (prop != null) {
            String propertyName = "carol.jeremie.server.port";
            this.port = PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
    }

    public void exportObject(Remote obj) throws RemoteException {
        if (!this.containsJeremieStub(obj)) {
            return;
        }
        try {
            Method exportO = unicastClass.getMethod("exportObject", class$java$rmi$Remote == null ? (class$java$rmi$Remote = JeremiePRODelegate.class$("java.rmi.Remote")) : class$java$rmi$Remote, Integer.TYPE);
            exportO.invoke((Object)unicastClass, obj, new Integer(this.port));
        }
        catch (InvocationTargetException e) {
            throw RemoteExceptionHelper.create(e.getTargetException());
        }
        catch (Exception e) {
            throw new RemoteException("exportObject() method fails on object '" + obj + "'", e);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (!this.containsJeremieStub(obj)) {
            return;
        }
        try {
            Method unexportO = unicastClass.getMethod("unexportObject", class$java$rmi$Remote == null ? (class$java$rmi$Remote = JeremiePRODelegate.class$("java.rmi.Remote")) : class$java$rmi$Remote, Boolean.TYPE);
            unexportO.invoke((Object)unicastClass, obj, Boolean.TRUE);
        }
        catch (InvocationTargetException e) {
            throw NoSuchObjectExceptionHelper.create(e.getTargetException());
        }
        catch (Exception e) {
            throw NoSuchObjectExceptionHelper.create("unexportObject() method fails on object '" + obj + "'", e);
        }
    }

    public void connect(Remote target, Remote source) throws RemoteException {
    }

    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        if (narrowTo.isAssignableFrom(narrowFrom.getClass())) {
            return narrowFrom;
        }
        throw new ClassCastException("Cannot cast '" + narrowFrom.getClass().getName() + "' in '" + narrowTo.getName() + "'.");
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        try {
            Method exportO = unicastClass.getMethod("toStub", class$java$rmi$Remote == null ? (class$java$rmi$Remote = JeremiePRODelegate.class$("java.rmi.Remote")) : class$java$rmi$Remote);
            return (Remote)exportO.invoke((Object)unicastClass, obj);
        }
        catch (InvocationTargetException e) {
            throw NoSuchObjectExceptionHelper.create(e.getTargetException());
        }
        catch (Exception e) {
            throw NoSuchObjectExceptionHelper.create("toStub() method fails on object '" + obj + "'", e);
        }
    }

    private boolean containsJeremieStub(Remote r) {
        if (nbProtocols == 0) {
            nbProtocols = ConfigurationRepository.getActiveConfigurationsNumber();
        }
        if (nbProtocols == 1) {
            return true;
        }
        String stubName = r.getClass().getName() + JEREMIE_STUB_EXTENSION;
        String resourceName = stubName.replace('.', '/');
        resourceName = resourceName + ".class";
        return Thread.currentThread().getContextClassLoader().getResource(resourceName) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

