/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.multi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.Properties;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorStore;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.server.JUnicastRemoteObject;
import org.objectweb.carol.rmi.util.PortNumber;
import org.objectweb.carol.util.configuration.ConfigurationRepository;

public class JrmpPRODelegate
implements PortableRemoteObjectDelegate {
    private int port;
    private JServerRequestInterceptor[] sis = JInterceptorStore.getLocalServerInterceptors();
    private JClientRequestInterceptor[] cis = JInterceptorStore.getLocalClientInterceptors();

    public JrmpPRODelegate(boolean usingCmi) {
        Properties prop = ConfigurationRepository.getProperties();
        if (!usingCmi && prop != null) {
            String propertyName = "carol.jrmp.server.port";
            this.port = PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
    }

    public JrmpPRODelegate() {
        this(false);
    }

    public void exportObject(Remote obj) throws RemoteException {
        JUnicastRemoteObject.exportObject(obj, this.port, this.sis, this.cis);
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        JUnicastRemoteObject.unexportObject(obj, true);
    }

    public void connect(Remote target, Remote source) throws RemoteException {
    }

    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        if (narrowTo.isAssignableFrom(narrowFrom.getClass())) {
            return narrowFrom;
        }
        throw new ClassCastException("Cannot cast '" + narrowFrom.getClass().getName() + "' in '" + narrowTo.getName() + "'.");
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        return RemoteObject.toStub(obj);
    }
}

