/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.AttributePSVImpl;
import org.apache.xerces.impl.xs.ElementPSVImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSModelImpl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IDValue;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLSchemaValidator
implements XMLComponent,
XMLDocumentFilter,
FieldActivator,
RevalidationHandler {
    private static final boolean DEBUG = false;
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/namespaces", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema-full-checking"};
    protected static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource"};
    protected boolean fSeenRoot = false;
    protected boolean fNamespaces = false;
    protected final ElementPSVImpl fElemPSVI = new ElementPSVImpl();
    protected ElementPSVImpl fCurrentPSVI = null;
    protected final AugmentationsImpl fAugmentations = new AugmentationsImpl();
    protected XMLString fDefaultValue;
    protected boolean fValidation = false;
    protected boolean fDynamicValidation = false;
    protected boolean fDoValidation = false;
    protected boolean fFullChecking = false;
    protected boolean fNormalizeData = true;
    protected boolean fSchemaElementDefault = true;
    protected boolean fEntityRef = false;
    protected boolean fInCDATA = false;
    protected SymbolTable fSymbolTable;
    protected XSIErrorReporter fXSIErrorReporter = new XSIErrorReporter();
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager = null;
    protected ValidationState fValidationState = new ValidationState();
    protected XMLGrammarPool fGrammarPool;
    protected String fExternalSchemas = null;
    protected String fExternalNoNamespaceSchema = null;
    protected Object fJaxpSchemaSource = null;
    XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    protected final XSDDescription fXSDDescription = new XSDDescription();
    protected final Hashtable fLocationPairs = new Hashtable();
    protected final XMLSchemaLoader.LocationArray fNoNamespaceLocationArray = new XMLSchemaLoader.LocationArray();
    protected String fBaseURI = null;
    protected XMLDocumentHandler fDocumentHandler;
    static final int INITIAL_STACK_SIZE = 8;
    static final int INC_STACK_SIZE = 8;
    String XMLNS;
    String URI_XSI;
    String XSI_SCHEMALOCATION;
    String XSI_NONAMESPACESCHEMALOCATION;
    String XSI_TYPE;
    String XSI_NIL;
    String URI_SCHEMAFORSCHEMA;
    private static final boolean DEBUG_NORMALIZATION = false;
    private final XMLString fEmptyXMLStr = new XMLString(null, 0, -1);
    private static final int BUFFER_SIZE = 20;
    private char[] fCharBuffer = new char[20];
    private final StringBuffer fNormalizedStr = new StringBuffer();
    private final XMLString fXMLString = new XMLString(this.fCharBuffer, 0, -1);
    private boolean fFirstChunk = true;
    private boolean fTrailing = false;
    private short fWhiteSpace = (short)-1;
    private boolean fUnionType = false;
    final XSGrammarBucket fGrammarBucket;
    final SubstitutionGroupHandler fSubGroupHandler;
    final XMLSchemaLoader fSchemaLoader;
    final NamespaceSupport fNamespaceSupport = new NamespaceSupport();
    boolean fPushForNextBinding;
    final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    final CMBuilder fCMBuilder = new CMBuilder();
    String fValidationRoot;
    int fSkipValidationDepth;
    int fPartialValidationDepth;
    int fElementDepth;
    int fChildCount;
    int[] fChildCountStack = new int[8];
    XSElementDecl fCurrentElemDecl;
    XSElementDecl[] fElemDeclStack = new XSElementDecl[8];
    boolean fNil;
    boolean[] fNilStack = new boolean[8];
    XSTypeDecl fCurrentType;
    XSTypeDecl[] fTypeStack = new XSTypeDecl[8];
    XSCMValidator fCurrentCM;
    XSCMValidator[] fCMStack = new XSCMValidator[8];
    int[] fCurrCMState;
    int[][] fCMStateStack = new int[8][];
    final StringBuffer fBuffer = new StringBuffer();
    boolean fSawCharacters = false;
    boolean[] fStringContent = new boolean[8];
    boolean fSawChildren = false;
    boolean[] fSawChildrenStack = new boolean[8];
    final QName fTempQName = new QName();
    ValidatedInfo fValidatedInfo = new ValidatedInfo();
    private ValidationState fState4XsiType = new ValidationState();
    private ValidationState fState4ApplyDefault = new ValidationState();
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.handleStartDocument(xMLLocator, string);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(xMLLocator, string, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
        this.handleStartPrefix(string, string2);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startPrefixMapping(string, string2, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Augmentations augmentations2 = this.handleStartElement(qName, xMLAttributes, augmentations);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations2);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Augmentations augmentations2 = this.handleStartElement(qName, xMLAttributes, augmentations);
        XSElementDecl xSElementDecl = this.fCurrentPSVI.fDeclaration;
        XSTypeDecl xSTypeDecl = this.fCurrentPSVI.fTypeDecl;
        XSNotationDecl xSNotationDecl = this.fCurrentPSVI.fNotation;
        String string = this.fCurrentPSVI.fValidationContext;
        augmentations2 = this.handleEndElement(qName, augmentations2);
        if (this.fDocumentHandler != null) {
            this.fCurrentPSVI.fDeclaration = xSElementDecl;
            this.fCurrentPSVI.fTypeDecl = xSTypeDecl;
            this.fCurrentPSVI.fNotation = xSNotationDecl;
            this.fCurrentPSVI.fValidationContext = string;
            if (!this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations2);
            } else {
                this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations2);
                this.fDocumentHandler.characters(this.fDefaultValue, augmentations2);
                this.fDocumentHandler.endElement(qName, augmentations2);
            }
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        boolean bl = false;
        if (augmentations == null) {
            bl = true;
            augmentations = this.fAugmentations;
            augmentations.clear();
        }
        this.fCurrentPSVI = (ElementPSVImpl)augmentations.getItem("ELEMENT_PSVI");
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        } else {
            this.fCurrentPSVI.reset();
        }
        this.handleCharacters(xMLString);
        if (this.fDocumentHandler != null) {
            if (this.fUnionType) {
                if (!bl) {
                    this.fDocumentHandler.characters(this.fEmptyXMLStr, augmentations);
                }
            } else {
                this.fDocumentHandler.characters(xMLString, augmentations);
            }
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.handleIgnorableWhitespace(xMLString);
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        Augmentations augmentations2 = this.handleEndElement(qName, augmentations);
        if (this.fDocumentHandler != null) {
            if (this.fSchemaElementDefault || this.fDefaultValue == null) {
                this.fDocumentHandler.endElement(qName, augmentations2);
            } else {
                this.fDocumentHandler.characters(this.fDefaultValue, augmentations2);
                this.fDocumentHandler.endElement(qName, augmentations2);
            }
        }
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endPrefixMapping(string, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATA = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATA = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        this.handleEndDocument();
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void setBaseURI(String string) {
        this.fBaseURI = string;
    }

    public boolean characterData(String string, Augmentations augmentations) {
        Object object;
        int n;
        int n2;
        boolean bl = true;
        String string2 = null;
        if (augmentations == null) {
            augmentations = this.fAugmentations;
            augmentations.clear();
        }
        this.fCurrentPSVI = (ElementPSVImpl)augmentations.getItem("ELEMENT_PSVI");
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        } else {
            this.fCurrentPSVI.reset();
        }
        if (this.fNormalizeData && !this.fEntityRef && !this.fInCDATA && this.fWhiteSpace != -1 && this.fWhiteSpace != 0) {
            n2 = this.normalizeWhitespace(string, this.fWhiteSpace == 2);
            this.fCurrentPSVI.fNormalizedValue = string2 = this.fNormalizedStr.toString();
        }
        n2 = 0;
        if (this.fCurrentType != null && this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
            if (xSComplexTypeDecl.fContentType == 3) {
                n2 = 1;
            }
        }
        if (n2 == 0 && this.fWhiteSpace == -1 && !this.fUnionType) {
            int n3 = 0;
            while (n3 < string.length()) {
                if (!XMLChar.isSpace(string.charAt(n3))) {
                    bl = false;
                    break;
                }
                ++n3;
            }
        }
        this.fFirstChunk = false;
        if (this.fNil) {
            this.fCurrentPSVI.fNormalizedValue = null;
            this.fBuffer.append(string);
        }
        if (string2 != null) {
            this.fBuffer.append(string2);
        } else {
            this.fBuffer.append(string);
        }
        if (!bl) {
            this.fSawCharacters = true;
        }
        int n4 = this.fMatcherStack.getMatcherCount();
        XMLString xMLString = null;
        if (n4 > 0) {
            n = string.length();
            object = new char[n];
            string.getChars(0, n, (char[])object, 0);
            xMLString = new XMLString((char[])object, 0, n);
        }
        n = 0;
        while (n < n4) {
            object = this.fMatcherStack.getMatcherAt(n);
            ((XPathMatcher)object).characters(xMLString);
            ++n;
        }
        return bl;
    }

    public void elementDefault(String string) {
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.fEntityRef = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSawChildren = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        this.fEntityRef = false;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public XMLSchemaValidator() {
        this.fGrammarBucket = new XSGrammarBucket();
        this.fSubGroupHandler = new SubstitutionGroupHandler(this.fGrammarBucket);
        this.fSchemaLoader = new XMLSchemaLoader(this.fXSIErrorReporter.fErrorReporter, this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fXSIErrorReporter.reset((XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER));
        this.fSchemaLoader.setProperty(ERROR_REPORTER, this.fXSIErrorReporter.fErrorReporter);
        SymbolTable symbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        if (symbolTable != this.fSymbolTable) {
            this.XMLNS = symbolTable.addSymbol("xmlns");
            this.URI_XSI = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
            this.XSI_SCHEMALOCATION = symbolTable.addSymbol("schemaLocation");
            this.XSI_NONAMESPACESCHEMALOCATION = symbolTable.addSymbol("noNamespaceSchemaLocation");
            this.XSI_TYPE = symbolTable.addSymbol("type");
            this.XSI_NIL = symbolTable.addSymbol("nil");
            this.URI_SCHEMAFORSCHEMA = symbolTable.addSymbol("http://www.w3.org/2001/XMLSchema");
            this.fSchemaLoader.setProperty(SYMBOL_TABLE, symbolTable);
        }
        this.fSymbolTable = symbolTable;
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fValidation = this.fValidation && xMLComponentManager.getFeature(SCHEMA_VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fFullChecking = xMLComponentManager.getFeature(SCHEMA_FULL_CHECKING);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fFullChecking = false;
        }
        this.fSchemaLoader.setFeature(SCHEMA_FULL_CHECKING, false);
        try {
            this.fDynamicValidation = xMLComponentManager.getFeature(DYNAMIC_VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fDynamicValidation = false;
        }
        try {
            this.fNormalizeData = xMLComponentManager.getFeature(NORMALIZE_DATA);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNormalizeData = false;
        }
        try {
            this.fSchemaElementDefault = xMLComponentManager.getFeature(SCHEMA_ELEMENT_DEFAULT);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSchemaElementDefault = false;
        }
        this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_MANAGER);
        this.fSchemaLoader.setEntityResolver(this.fEntityResolver);
        this.fNamespaceSupport.reset(this.fSymbolTable);
        this.fPushForNextBinding = true;
        this.fValidationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        this.fValidationManager.addValidationState(this.fValidationState);
        this.fValidationState.setNamespaceSupport(this.fNamespaceSupport);
        this.fValidationState.setSymbolTable(this.fSymbolTable);
        try {
            this.fExternalSchemas = (String)xMLComponentManager.getProperty(SCHEMA_LOCATION);
            this.fExternalNoNamespaceSchema = (String)xMLComponentManager.getProperty(SCHEMA_NONS_LOCATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalSchemas = null;
            this.fExternalNoNamespaceSchema = null;
        }
        this.fSchemaLoader.setProperty(SCHEMA_LOCATION, this.fExternalSchemas);
        this.fSchemaLoader.setProperty(SCHEMA_NONS_LOCATION, this.fExternalNoNamespaceSchema);
        try {
            this.fJaxpSchemaSource = xMLComponentManager.getProperty(JAXP_SCHEMA_SOURCE);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fJaxpSchemaSource = null;
        }
        this.fSchemaLoader.setProperty(JAXP_SCHEMA_SOURCE, this.fJaxpSchemaSource);
        this.fResourceIdentifier.clear();
        try {
            this.fGrammarPool = (XMLGrammarPool)xMLComponentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fGrammarPool = null;
        }
        this.fSchemaLoader.setProperty(XMLGRAMMAR_POOL, this.fGrammarPool);
        this.fSchemaLoader.reset();
        this.fXSDDescription.reset();
        this.fLocationPairs.clear();
        this.fNoNamespaceLocationArray.resize(0, 2);
        this.fCurrentElemDecl = null;
        this.fNil = false;
        this.fCurrentPSVI = null;
        this.fCurrentType = null;
        this.fCurrentCM = null;
        this.fCurrCMState = null;
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        this.fSawChildren = false;
        this.fValidationRoot = null;
        this.fSkipValidationDepth = -1;
        this.fPartialValidationDepth = -1;
        this.fElementDepth = -1;
        this.fChildCount = 0;
        this.fFirstChunk = true;
        this.fTrailing = false;
        this.fNormalizedStr.setLength(0);
        this.fWhiteSpace = (short)-1;
        this.fUnionType = false;
        this.fWhiteSpace = (short)-1;
        this.fAugmentations.clear();
        this.fEntityRef = false;
        this.fInCDATA = false;
        this.fMatcherStack.clear();
        this.fBaseURI = null;
        this.fValueStoreCache = new ValueStoreCache();
        this.fState4XsiType.setExtraChecking(false);
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4XsiType.setSymbolTable(symbolTable);
        this.fState4XsiType.setNamespaceSupport(this.fNamespaceSupport);
        this.fState4ApplyDefault.setFacetChecking(false);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setSymbolTable(symbolTable);
        this.fState4ApplyDefault.setNamespaceSupport(this.fNamespaceSupport);
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        int n = 0;
        while (n < identityConstraint.getFieldCount()) {
            Field field = identityConstraint.getFieldAt(n);
            ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(field);
            valueStoreBase.startValueScope();
            ++n;
        }
    }

    public XPathMatcher activateField(Field field) throws XNIException {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(field);
        field.setMayMatch(true);
        XPathMatcher xPathMatcher = field.createMatcher(valueStoreBase);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fSymbolTable);
        return xPathMatcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint) throws XNIException {
        ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint);
        valueStoreBase.endValueScope();
    }

    private void activateSelectorFor(IdentityConstraint identityConstraint) throws XNIException {
        Selector selector = identityConstraint.getSelector();
        XMLSchemaValidator xMLSchemaValidator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher xPathMatcher = selector.createMatcher(xMLSchemaValidator);
        this.fMatcherStack.addMatcher(xPathMatcher);
        xPathMatcher.startDocumentFragment(this.fSymbolTable);
    }

    void ensureStackCapacity() {
        if (this.fElementDepth == this.fElemDeclStack.length) {
            int n = this.fElementDepth + 8;
            int[] nArray = new int[n];
            System.arraycopy(this.fChildCountStack, 0, nArray, 0, this.fElementDepth);
            this.fChildCountStack = nArray;
            XSElementDecl[] xSElementDeclArray = new XSElementDecl[n];
            System.arraycopy(this.fElemDeclStack, 0, xSElementDeclArray, 0, this.fElementDepth);
            this.fElemDeclStack = xSElementDeclArray;
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.fNilStack, 0, blArray, 0, this.fElementDepth);
            this.fNilStack = blArray;
            XSTypeDecl[] xSTypeDeclArray = new XSTypeDecl[n];
            System.arraycopy(this.fTypeStack, 0, xSTypeDeclArray, 0, this.fElementDepth);
            this.fTypeStack = xSTypeDeclArray;
            XSCMValidator[] xSCMValidatorArray = new XSCMValidator[n];
            System.arraycopy(this.fCMStack, 0, xSCMValidatorArray, 0, this.fElementDepth);
            this.fCMStack = xSCMValidatorArray;
            boolean[] blArray2 = new boolean[n];
            System.arraycopy(this.fStringContent, 0, blArray2, 0, this.fElementDepth);
            this.fStringContent = blArray2;
            blArray2 = new boolean[n];
            System.arraycopy(this.fSawChildrenStack, 0, blArray2, 0, this.fElementDepth);
            this.fSawChildrenStack = blArray2;
            int[][] nArrayArray = new int[n][];
            System.arraycopy(this.fCMStateStack, 0, nArrayArray, 0, this.fElementDepth);
            this.fCMStateStack = nArrayArray;
        }
    }

    void handleStartDocument(XMLLocator xMLLocator, String string) {
        if (this.fValidation) {
            this.fValueStoreCache.startDocument();
        }
    }

    void handleEndDocument() {
        if (this.fValidation) {
            this.fValueStoreCache.endDocument();
        }
    }

    void handleCharacters(XMLString xMLString) {
        int n;
        int n2;
        this.fCurrentPSVI.fNormalizedValue = null;
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        String string = null;
        boolean bl = true;
        if (this.fNormalizeData && !this.fEntityRef && !this.fInCDATA && this.fWhiteSpace != -1 && !this.fUnionType && this.fWhiteSpace != 0) {
            n2 = this.normalizeWhitespace(xMLString, this.fWhiteSpace == 2);
            n = this.fNormalizedStr.length();
            if (n > 0 && !this.fFirstChunk && this.fWhiteSpace == 2) {
                if (this.fTrailing) {
                    this.fNormalizedStr.insert(0, ' ');
                } else if (n2 == 1 || n2 == 3) {
                    this.fNormalizedStr.insert(0, ' ');
                }
            }
            this.fCurrentPSVI.fNormalizedValue = string = this.fNormalizedStr.toString();
            this.fTrailing = n2 > 1;
        }
        n2 = 0;
        if (this.fCurrentType != null && this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
            if (xSComplexTypeDecl.fContentType == 3) {
                n2 = 1;
            }
        }
        if (n2 == 0 && this.fWhiteSpace == -1 && !this.fUnionType) {
            n = xMLString.offset;
            while (n < xMLString.offset + xMLString.length) {
                if (!XMLChar.isSpace(xMLString.ch[n])) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        this.fFirstChunk = false;
        if (this.fNil) {
            this.fCurrentPSVI.fNormalizedValue = null;
            this.fBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        }
        if (string != null) {
            this.fBuffer.append(string);
        } else {
            this.fBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        }
        if (!bl) {
            this.fSawCharacters = true;
        }
        n = this.fMatcherStack.getMatcherCount();
        int n3 = 0;
        while (n3 < n) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n3);
            xPathMatcher.characters(xMLString);
            ++n3;
        }
    }

    private int normalizeWhitespace(XMLString xMLString, boolean bl) {
        int n;
        boolean bl2 = bl;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = xMLString.offset + xMLString.length;
        this.fNormalizedStr.setLength(0);
        int n5 = xMLString.offset;
        while (n5 < n4) {
            n = xMLString.ch[n5];
            if (n == 32 || n == 13 || n == 10 || n == 9) {
                if (!bl2) {
                    this.fNormalizedStr.append(' ');
                    bl2 = bl;
                }
                if (!bl3) {
                    n2 = 1;
                }
            } else {
                this.fNormalizedStr.append((char)n);
                bl2 = false;
                bl3 = true;
            }
            ++n5;
        }
        if (bl2) {
            n = this.fNormalizedStr.length();
            if (n != 0) {
                this.fNormalizedStr.setLength(--n);
                n3 = 2;
            } else if (n2 != 0 && !bl3) {
                n3 = 2;
            }
        }
        return bl ? n2 + n3 : 0;
    }

    private int normalizeWhitespace(String string, boolean bl) {
        int n;
        boolean bl2 = bl;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        this.fNormalizedStr.setLength(0);
        int n5 = 0;
        while (n5 < n4) {
            n = string.charAt(n5);
            if (n == 32 || n == 13 || n == 10 || n == 9) {
                if (!bl2) {
                    this.fNormalizedStr.append(' ');
                    bl2 = bl;
                }
                if (!bl3) {
                    n2 = 1;
                }
            } else {
                this.fNormalizedStr.append((char)n);
                bl2 = false;
                bl3 = true;
            }
            ++n5;
        }
        if (bl2) {
            n = this.fNormalizedStr.length();
            if (n != 0) {
                this.fNormalizedStr.setLength(--n);
                n3 = 2;
            } else if (n2 != 0 && !bl3) {
                n3 = 2;
            }
        }
        return bl ? n2 + n3 : 0;
    }

    void handleIgnorableWhitespace(XMLString xMLString) {
        if (this.fSkipValidationDepth >= 0) {
            return;
        }
        int n = this.fMatcherStack.getMatcherCount();
        int n2 = 0;
        while (n2 < n) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n2);
            xPathMatcher.characters(xMLString);
            ++n2;
        }
    }

    Augmentations handleStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
        Object object;
        String string;
        XSObject xSObject;
        if (augmentations == null) {
            augmentations = this.fAugmentations;
            augmentations.clear();
        }
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
        } else {
            this.fPushForNextBinding = true;
        }
        if (this.fElementDepth == -1) {
            this.fDoValidation = this.fValidation && !this.fValidationManager.isGrammarFound() && !this.fDynamicValidation;
            this.storeLocations(this.fExternalSchemas, this.fExternalNoNamespaceSchema);
        }
        this.fCurrentPSVI = (ElementPSVImpl)augmentations.getItem("ELEMENT_PSVI");
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        }
        this.fCurrentPSVI.reset();
        String string2 = xMLAttributes.getValue(this.URI_XSI, this.XSI_SCHEMALOCATION);
        String string3 = xMLAttributes.getValue(this.URI_XSI, this.XSI_NONAMESPACESCHEMALOCATION);
        this.storeLocations(string2, string3);
        if (string2 != null || string3 != null) {
            this.fDoValidation = this.fValidation;
        }
        if (this.fNormalizeData) {
            this.fFirstChunk = true;
            this.fUnionType = false;
            this.fWhiteSpace = (short)-1;
        }
        if (this.fSkipValidationDepth >= 0) {
            ++this.fElementDepth;
            return augmentations;
        }
        SchemaGrammar schemaGrammar = this.findSchemaGrammar((short)5, qName.uri, null, qName, xMLAttributes);
        Object object2 = null;
        if (this.fSkipValidationDepth < 0 && this.fCurrentCM != null) {
            object2 = this.fCurrentCM.oneTransition(qName, this.fCurrCMState, this.fSubGroupHandler);
            if (this.fCurrCMState[0] == -1 && this.fDoValidation) {
                xSObject = (XSComplexTypeDecl)this.fCurrentType;
                if (xSObject.fParticle != null) {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{qName.rawname, xSObject.fParticle.toString()});
                } else {
                    this.reportSchemaError("cvc-complex-type.2.4.a", new Object[]{qName.rawname, "mixed with no element content"});
                }
            }
        }
        this.fXSIErrorReporter.pushContext();
        if (this.fElementDepth != -1) {
            this.ensureStackCapacity();
            this.fChildCountStack[this.fElementDepth] = this.fChildCount + 1;
            this.fChildCount = 0;
            this.fElemDeclStack[this.fElementDepth] = this.fCurrentElemDecl;
            this.fNilStack[this.fElementDepth] = this.fNil;
            this.fTypeStack[this.fElementDepth] = this.fCurrentType;
            this.fCMStack[this.fElementDepth] = this.fCurrentCM;
            this.fCMStateStack[this.fElementDepth] = this.fCurrCMState;
            this.fStringContent[this.fElementDepth] = this.fSawCharacters;
            this.fSawChildrenStack[this.fElementDepth] = this.fSawChildren;
        }
        ++this.fElementDepth;
        this.fCurrentElemDecl = null;
        xSObject = null;
        this.fCurrentType = null;
        this.fNil = false;
        this.fBuffer.setLength(0);
        this.fSawCharacters = false;
        this.fSawChildren = false;
        if (object2 != null) {
            if (object2 instanceof XSElementDecl) {
                this.fCurrentElemDecl = (XSElementDecl)object2;
            } else {
                xSObject = (XSWildcardDecl)object2;
            }
        }
        if (xSObject != null && ((XSWildcardDecl)xSObject).fProcessContents == 2) {
            this.fSkipValidationDepth = this.fElementDepth;
            return augmentations;
        }
        if (this.fCurrentElemDecl == null && schemaGrammar != null) {
            this.fCurrentElemDecl = schemaGrammar.getGlobalElementDecl(qName.localpart);
        }
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getIsAbstract()) {
            this.reportSchemaError("cvc-elt.2", new Object[]{qName.rawname});
        }
        if (this.fCurrentElemDecl != null) {
            this.fCurrentType = this.fCurrentElemDecl.fType;
        }
        if ((string = xMLAttributes.getValue(this.URI_XSI, this.XSI_TYPE)) != null) {
            this.fCurrentType = this.getAndCheckXsiType(qName, string, xMLAttributes);
        }
        if (this.fCurrentType == null) {
            if (this.fDoValidation) {
                if (this.fElementDepth == 0) {
                    this.reportSchemaError("cvc-elt.1", new Object[]{qName.rawname});
                } else if (xSObject != null && ((XSWildcardDecl)xSObject).fProcessContents == 1) {
                    this.reportSchemaError("cvc-complex-type.2.4.c", new Object[]{qName.rawname});
                }
            }
            this.fCurrentType = SchemaGrammar.fAnyType;
        }
        if (this.fElementDepth == 0) {
            this.fValidationRoot = qName.rawname;
        }
        this.fCurrentPSVI.fValidationContext = this.fValidationRoot;
        this.fCurrentPSVI.fDeclaration = this.fCurrentElemDecl;
        this.fCurrentPSVI.fTypeDecl = this.fCurrentType;
        if (this.fCurrentType.getTypeCategory() == 13) {
            object = (XSComplexTypeDecl)this.fCurrentType;
            if (((XSComplexTypeDecl)object).getIsAbstract()) {
                this.reportSchemaError("cvc-type.2", new Object[]{"Element " + qName.rawname + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type"});
            }
            if (this.fNormalizeData && ((XSComplexTypeDecl)object).fContentType == 1) {
                if (((XSComplexTypeDecl)object).fXSSimpleType.getVariety() == 3) {
                    this.fUnionType = true;
                } else {
                    try {
                        this.fWhiteSpace = ((XSComplexTypeDecl)object).fXSSimpleType.getWhitespace();
                    }
                    catch (DatatypeException datatypeException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.fNormalizeData && this.fCurrentType.getTypeCategory() == 14) {
            object = (XSSimpleType)this.fCurrentType;
            if (object.getVariety() == 3) {
                this.fUnionType = true;
            } else {
                try {
                    this.fWhiteSpace = object.getWhitespace();
                }
                catch (DatatypeException datatypeException) {
                    // empty catch block
                }
            }
        }
        this.fCurrentCM = null;
        if (this.fCurrentType.getTypeCategory() == 13) {
            this.fCurrentCM = ((XSComplexTypeDecl)this.fCurrentType).getContentModel(this.fCMBuilder);
        }
        this.fCurrCMState = null;
        if (this.fCurrentCM != null) {
            this.fCurrCMState = this.fCurrentCM.startContentModel();
        }
        if ((object = xMLAttributes.getValue(this.URI_XSI, this.XSI_NIL)) != null && this.fCurrentElemDecl != null) {
            this.fNil = this.getXsiNil(qName, (String)object);
        }
        XSAttributeGroupDecl xSAttributeGroupDecl = null;
        if (this.fCurrentType.getTypeCategory() == 13) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
            xSAttributeGroupDecl = xSComplexTypeDecl.fAttrGrp;
        }
        this.processAttributes(qName, xMLAttributes, xSAttributeGroupDecl);
        if (this.fDoValidation) {
            int n;
            this.fValueStoreCache.startElement();
            this.fMatcherStack.pushContext();
            if (this.fCurrentElemDecl != null) {
                this.fValueStoreCache.initValueStoresFor(this.fCurrentElemDecl);
                int n2 = this.fCurrentElemDecl.fIDCPos;
                n = 0;
                while (n < n2) {
                    if (this.fCurrentElemDecl.fIDConstraints[n].getCategory() == 2) break;
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[n]);
                    ++n;
                }
                int n3 = n;
                while (n3 < n2) {
                    this.activateSelectorFor(this.fCurrentElemDecl.fIDConstraints[n3]);
                    ++n3;
                }
            }
            int n4 = this.fMatcherStack.getMatcherCount();
            n = 0;
            while (n < n4) {
                XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n);
                xPathMatcher.startElement(qName, xMLAttributes, this.fCurrentElemDecl);
                ++n;
            }
        }
        return augmentations;
    }

    Augmentations handleEndElement(QName qName, Augmentations augmentations) {
        Object object;
        if (augmentations == null) {
            augmentations = this.fAugmentations;
            augmentations.clear();
        }
        this.fCurrentPSVI = (ElementPSVImpl)augmentations.getItem("ELEMENT_PSVI");
        if (this.fCurrentPSVI == null) {
            this.fCurrentPSVI = this.fElemPSVI;
            augmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
        }
        this.fCurrentPSVI.reset();
        if (this.fSkipValidationDepth >= 0) {
            if (this.fSkipValidationDepth == this.fElementDepth && this.fSkipValidationDepth > 0) {
                this.fPartialValidationDepth = this.fSkipValidationDepth - 1;
                this.fSkipValidationDepth = -1;
                --this.fElementDepth;
                this.fChildCount = this.fChildCountStack[this.fElementDepth];
                this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
                this.fNil = this.fNilStack[this.fElementDepth];
                this.fCurrentType = this.fTypeStack[this.fElementDepth];
                this.fCurrentCM = this.fCMStack[this.fElementDepth];
                this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
                this.fSawCharacters = this.fStringContent[this.fElementDepth];
                this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
            } else {
                --this.fElementDepth;
            }
            this.fNamespaceSupport.popContext();
            if (this.fElementDepth == -1 && this.fDoValidation && this.fFullChecking) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
            }
            this.fDefaultValue = null;
            return augmentations;
        }
        XMLString xMLString = this.processElementContent(qName);
        int n = this.fMatcherStack.getMatcherCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n2);
            xPathMatcher.endElement(qName, this.fCurrentElemDecl);
            --n2;
        }
        if (this.fMatcherStack.size() > 0) {
            this.fMatcherStack.popContext();
        }
        int n3 = this.fMatcherStack.getMatcherCount();
        int n4 = n - 1;
        while (n4 >= n3) {
            XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n4);
            object = xPathMatcher.getIDConstraint();
            if (object != null && object.getCategory() != 2) {
                xPathMatcher.endDocumentFragment();
                this.fValueStoreCache.transplant((IdentityConstraint)object);
            } else if (object == null) {
                xPathMatcher.endDocumentFragment();
            }
            --n4;
        }
        int n5 = n - 1;
        while (n5 >= n3) {
            object = this.fMatcherStack.getMatcherAt(n5);
            IdentityConstraint identityConstraint = object.getIDConstraint();
            if (identityConstraint != null && identityConstraint.getCategory() == 2) {
                ValueStoreBase valueStoreBase = this.fValueStoreCache.getValueStoreFor(identityConstraint);
                if (valueStoreBase != null) {
                    valueStoreBase.endDocumentFragment();
                }
                object.endDocumentFragment();
            }
            --n5;
        }
        this.fValueStoreCache.endElement();
        if (this.fElementDepth <= this.fPartialValidationDepth) {
            this.fCurrentPSVI.fValidationAttempted = 1;
            if (this.fElementDepth == this.fPartialValidationDepth) {
                --this.fPartialValidationDepth;
            }
        } else {
            this.fCurrentPSVI.fValidationAttempted = (short)2;
        }
        --this.fElementDepth;
        if (this.fElementDepth == -1) {
            if (this.fDoValidation) {
                object = this.fValidationState.checkIDRefID();
                if (object != null) {
                    this.reportSchemaError("cvc-id.1", new Object[]{object});
                }
                if (this.fFullChecking) {
                    XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fXSIErrorReporter.fErrorReporter);
                }
            }
            this.fValidationState.resetIDTables();
            object = this.fGrammarBucket.getGrammars();
            if (this.fGrammarPool != null) {
                this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", (Grammar[])object);
            }
            this.fCurrentPSVI.fSchemaInformation = new XSModelImpl((SchemaGrammar[])object);
        } else {
            this.fChildCount = this.fChildCountStack[this.fElementDepth];
            this.fCurrentElemDecl = this.fElemDeclStack[this.fElementDepth];
            this.fNil = this.fNilStack[this.fElementDepth];
            this.fCurrentType = this.fTypeStack[this.fElementDepth];
            this.fCurrentCM = this.fCMStack[this.fElementDepth];
            this.fCurrCMState = this.fCMStateStack[this.fElementDepth];
            this.fSawCharacters = this.fStringContent[this.fElementDepth];
            this.fSawChildren = this.fSawChildrenStack[this.fElementDepth];
        }
        this.fNamespaceSupport.popContext();
        object = this.fXSIErrorReporter.popContext();
        this.fCurrentPSVI.fErrorCodes = object;
        this.fCurrentPSVI.fValidity = (short)(object == null ? 2 : 1);
        this.fDefaultValue = xMLString;
        if (this.fNormalizeData) {
            this.fTrailing = false;
            this.fUnionType = false;
            this.fWhiteSpace = (short)-1;
        }
        return augmentations;
    }

    void handleStartPrefix(String string, String string2) {
        if (this.fPushForNextBinding) {
            this.fNamespaceSupport.pushContext();
            this.fPushForNextBinding = false;
        }
        this.fNamespaceSupport.declarePrefix(string, string2.length() != 0 ? string2 : null);
    }

    void storeLocations(String string, String string2) {
        if (string != null && !XMLSchemaLoader.tokenizeSchemaLocationStr(string, this.fLocationPairs)) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{string}, (short)0);
        }
        if (string2 != null) {
            this.fNoNamespaceLocationArray.addLocation(string2);
            this.fLocationPairs.put("", this.fNoNamespaceLocationArray);
        }
    }

    SchemaGrammar findSchemaGrammar(short s, String string, QName qName, QName qName2, XMLAttributes xMLAttributes) {
        SchemaGrammar schemaGrammar = null;
        schemaGrammar = this.fGrammarBucket.getGrammar(string);
        if (schemaGrammar == null) {
            Object object;
            this.fXSDDescription.reset();
            this.fXSDDescription.fContextType = s;
            this.fXSDDescription.fTargetNamespace = string;
            this.fXSDDescription.fEnclosedElementName = qName;
            this.fXSDDescription.fTriggeringComponent = qName2;
            this.fXSDDescription.fAttributes = xMLAttributes;
            if (this.fBaseURI != null) {
                this.fXSDDescription.setBaseSystemId(this.fBaseURI);
            }
            String[] stringArray = null;
            if (string != null) {
                object = this.fLocationPairs.get(string);
                if (object != null) {
                    stringArray = ((XMLSchemaLoader.LocationArray)object).getLocationArray();
                }
            } else {
                stringArray = this.fNoNamespaceLocationArray.getLocationArray();
            }
            if (stringArray != null && stringArray.length != 0) {
                this.fXSDDescription.fLocationHints = new String[stringArray.length];
                System.arraycopy(stringArray, 0, this.fXSDDescription.fLocationHints, 0, stringArray.length);
            }
            if (this.fGrammarPool != null && (schemaGrammar = (SchemaGrammar)this.fGrammarPool.retrieveGrammar(this.fXSDDescription)) != null && !this.fGrammarBucket.putGrammar(schemaGrammar, true)) {
                this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                schemaGrammar = null;
            }
            if (schemaGrammar == null) {
                this.fLocationPairs.put("", this.fNoNamespaceLocationArray);
                try {
                    object = XMLSchemaLoader.resolveDocument(this.fXSDDescription, this.fLocationPairs, this.fEntityResolver);
                    schemaGrammar = this.fSchemaLoader.loadSchema(this.fXSDDescription, (XMLInputSource)object, this.fLocationPairs);
                }
                catch (IOException iOException) {
                    this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{this.fXSDDescription.getLocationHints()[0]}, (short)0);
                }
            }
        }
        return schemaGrammar;
    }

    XSTypeDecl getAndCheckXsiType(QName qName, String string, XMLAttributes xMLAttributes) {
        SchemaGrammar schemaGrammar;
        QName qName2 = null;
        try {
            qName2 = (QName)this.fQNameDV.validate(string, this.fValidationState, null);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
            this.reportSchemaError("cvc-elt.4.1", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_TYPE, string});
            return null;
        }
        XSTypeDecl xSTypeDecl = null;
        if (qName2.uri == this.URI_SCHEMAFORSCHEMA) {
            xSTypeDecl = SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(qName2.localpart);
        }
        if (xSTypeDecl == null && (schemaGrammar = this.findSchemaGrammar((short)7, qName2.uri, qName, qName2, xMLAttributes)) != null) {
            xSTypeDecl = schemaGrammar.getGlobalTypeDecl(qName2.localpart);
        }
        if (xSTypeDecl == null) {
            this.reportSchemaError("cvc-elt.4.2", new Object[]{qName.rawname, string});
            return null;
        }
        if (this.fCurrentType != null) {
            short s = this.fCurrentElemDecl.fBlock;
            if (this.fCurrentType.getTypeCategory() == 13) {
                s = (short)(s | ((XSComplexTypeDecl)this.fCurrentType).fBlock);
            }
            if (!XSConstraints.checkTypeDerivationOk(xSTypeDecl, this.fCurrentType, s)) {
                this.reportSchemaError("cvc-elt.4.3", new Object[]{qName.rawname, string});
            }
        }
        return xSTypeDecl;
    }

    boolean getXsiNil(QName qName, String string) {
        if (this.fCurrentElemDecl != null && !this.fCurrentElemDecl.getIsNillable()) {
            this.reportSchemaError("cvc-elt.3.1", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_NIL});
        } else {
            String string2 = string.trim();
            if (string2.equals("true") || string2.equals("1")) {
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2) {
                    this.reportSchemaError("cvc-elt.3.2.2", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_NIL});
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void processAttributes(QName var1_1, XMLAttributes var2_2, XSAttributeGroupDecl var3_3) {
        block37: {
            var4_4 = null;
            var5_5 = null;
            var6_6 = 0;
            while (var6_6 < var2_2.getLength()) {
                var4_4 = var2_2.getAugmentations(var6_6);
                var5_5 = (AttributePSVImpl)var4_4.getItem("ATTRIBUTE_PSVI");
                if (var5_5 != null) {
                    var5_5.reset();
                } else {
                    var5_5 = new AttributePSVImpl();
                    var4_4.putItem("ATTRIBUTE_PSVI", var5_5);
                }
                var5_5.fValidationContext = this.fValidationRoot;
                ++var6_6;
            }
            if (var3_3 != null) {
                this.addDefaultAttributes(var1_1, var2_2, var3_3);
            }
            if (!this.fDoValidation || var2_2.getLength() == 0) {
                return;
            }
            if (this.fCurrentType != null && this.fCurrentType.getTypeCategory() != 14) break block37;
            var7_7 = var2_2.getLength();
            var8_9 = 0;
            while (var8_9 < var7_7) {
                var2_2.getName(var8_9, this.fTempQName);
                var5_5 = (AttributePSVImpl)var2_2.getAugmentations(var8_9).getItem("ATTRIBUTE_PSVI");
                if (this.fTempQName.uri != this.URI_XSI) ** GOTO lbl-1000
                var9_11 = null;
                if (this.fTempQName.localpart == this.XSI_SCHEMALOCATION) {
                    var9_11 = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_SCHEMALOCATION);
                } else if (this.fTempQName.localpart == this.XSI_NONAMESPACESCHEMALOCATION) {
                    var9_11 = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_NONAMESPACESCHEMALOCATION);
                } else if (this.fTempQName.localpart == this.XSI_NIL) {
                    var9_11 = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_NIL);
                } else if (this.fTempQName.localpart == this.XSI_TYPE) {
                    var9_11 = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_TYPE);
                }
                if (var9_11 != null) {
                    this.processOneAttribute(var1_1, var2_2.getValue(var8_9), var9_11, null, var5_5);
                } else if (this.fTempQName.rawname != this.XMLNS && !this.fTempQName.rawname.startsWith("xmlns:")) {
                    this.reportSchemaError("cvc-type.3.1.1", new Object[]{var1_1.rawname});
                }
                ++var8_9;
            }
            return;
        }
        var7_8 = var3_3.getAttributeUses();
        var8_10 = var7_8.getLength();
        var9_12 = var3_3.fAttributeWC;
        var10_13 = null;
        var11_14 = var2_2.getLength();
        var12_15 = 0;
        while (var12_15 < var11_14) {
            block39: {
                block41: {
                    block40: {
                        block38: {
                            var2_2.getName(var12_15, this.fTempQName);
                            var5_5 = (AttributePSVImpl)var2_2.getAugmentations(var12_15).getItem("ATTRIBUTE_PSVI");
                            if (this.fTempQName.uri != this.URI_XSI) break block38;
                            var13_16 /* !! */  = null;
                            if (this.fTempQName.localpart == this.XSI_SCHEMALOCATION) {
                                var13_16 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_SCHEMALOCATION);
                            } else if (this.fTempQName.localpart == this.XSI_NONAMESPACESCHEMALOCATION) {
                                var13_16 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_NONAMESPACESCHEMALOCATION);
                            } else if (this.fTempQName.localpart == this.XSI_NIL) {
                                var13_16 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_NIL);
                            } else if (this.fTempQName.localpart == this.XSI_TYPE) {
                                var13_16 /* !! */  = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(this.XSI_TYPE);
                            }
                            if (var13_16 /* !! */  == null) break block38;
                            this.processOneAttribute(var1_1, var2_2.getValue(var12_15), var13_16 /* !! */ , null, var5_5);
                            break block39;
                        }
                        if (this.fTempQName.rawname == this.XMLNS || this.fTempQName.rawname.startsWith("xmlns:")) break block39;
                        var13_16 /* !! */  = null;
                        var15_18 = 0;
                        while (var15_18 < var8_10) {
                            var14_17 = (XSAttributeUseImpl)var7_8.getItem(var15_18);
                            if (var14_17.fAttrDecl.fName == this.fTempQName.localpart && var14_17.fAttrDecl.fTargetNamespace == this.fTempQName.uri) {
                                var13_16 /* !! */  = var14_17;
                                break;
                            }
                            ++var15_18;
                        }
                        if (var13_16 /* !! */  != null || var9_12 != null && var9_12.allowNamespace(this.fTempQName.uri)) break block40;
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{var1_1.rawname, this.fTempQName.rawname});
                        break block39;
                    }
                    var16_19 = null;
                    if (var13_16 /* !! */  == null) break block41;
                    var16_19 = var13_16 /* !! */ .fAttrDecl;
                    ** GOTO lbl108
                }
                if (var9_12.fProcessContents == 2) break block39;
                var17_20 = this.findSchemaGrammar((short)6, this.fTempQName.uri, var1_1, this.fTempQName, var2_2);
                if (var17_20 != null) {
                    var16_19 = var17_20.getGlobalAttributeDecl(this.fTempQName.localpart);
                }
                if (var16_19 == null) {
                    if (var9_12.fProcessContents == 1) {
                        this.reportSchemaError("cvc-complex-type.3.2.2", new Object[]{var1_1.rawname, this.fTempQName.rawname});
                    }
                } else {
                    if (var16_19.fType.getTypeCategory() == 14 && var16_19.fType.isIDType()) {
                        if (var10_13 != null) {
                            this.reportSchemaError("cvc-complex-type.5.1", new Object[]{var1_1.rawname, var16_19.fName, var10_13});
                            var5_5.fValidity = 1;
                            var5_5.addErrorCode("cvc-complex-type.5.1");
                        } else {
                            var10_13 = var16_19.fName;
                        }
                    }
lbl108:
                    // 5 sources

                    this.processOneAttribute(var1_1, var2_2.getValue(var12_15), var16_19, (XSAttributeUseImpl)var13_16 /* !! */ , var5_5);
                }
            }
            ++var12_15;
        }
        if (var3_3.fIDAttrName != null && var10_13 != null) {
            this.reportSchemaError("cvc-complex-type.5.2", new Object[]{var1_1.rawname, var10_13, var3_3.fIDAttrName});
        }
    }

    void processOneAttribute(QName qName, String string, XSAttributeDecl xSAttributeDecl, XSAttributeUseImpl xSAttributeUseImpl, AttributePSVImpl attributePSVImpl) {
        XSSimpleType xSSimpleType = xSAttributeDecl.fType;
        attributePSVImpl.fDeclaration = xSAttributeDecl;
        attributePSVImpl.fTypeDecl = xSSimpleType;
        attributePSVImpl.fValidationAttempted = (short)2;
        attributePSVImpl.fValidity = (short)2;
        Object object = null;
        try {
            object = xSSimpleType.validate(string, this.fValidationState, this.fValidatedInfo);
            attributePSVImpl.fMemberType = this.fValidatedInfo.memberType;
            if (xSSimpleType.getVariety() == 1 && xSSimpleType.getPrimitiveKind() == 19) {
                QName qName2 = (QName)object;
                SchemaGrammar schemaGrammar = this.fGrammarBucket.getGrammar(qName2.uri);
                if (schemaGrammar != null) {
                    this.fCurrentPSVI.fNotation = schemaGrammar.getGlobalNotationDecl(qName2.localpart);
                }
            }
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            attributePSVImpl.fValidity = 1;
            attributePSVImpl.addErrorCode("cvc-attribute.3");
            this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
            this.reportSchemaError("cvc-attribute.3", new Object[]{qName.rawname, this.fTempQName.rawname, string});
        }
        attributePSVImpl.fNormalizedValue = this.fValidatedInfo.normalizedValue;
        if (object != null && xSAttributeDecl.getConstraintType() == 2 && !xSSimpleType.isEqual(object, xSAttributeDecl.fDefault.actualValue)) {
            attributePSVImpl.fValidity = 1;
            attributePSVImpl.addErrorCode("cvc-attribute.4");
            this.reportSchemaError("cvc-attribute.4", new Object[]{qName.rawname, this.fTempQName.rawname, string});
        }
        if (object != null && xSAttributeUseImpl != null && xSAttributeUseImpl.fConstraintType == 2 && !xSSimpleType.isEqual(object, xSAttributeUseImpl.fDefault.actualValue)) {
            attributePSVImpl.fValidity = 1;
            attributePSVImpl.addErrorCode("cvc-complex-type.3.1");
            this.reportSchemaError("cvc-complex-type.3.1", new Object[]{qName.rawname, this.fTempQName.rawname, string});
        }
    }

    void addDefaultAttributes(QName qName, XMLAttributes xMLAttributes, XSAttributeGroupDecl xSAttributeGroupDecl) {
        XSObjectList xSObjectList = xSAttributeGroupDecl.getAttributeUses();
        int n = xSObjectList.getLength();
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            XSAttributeUseImpl xSAttributeUseImpl = (XSAttributeUseImpl)xSObjectList.getItem(n2);
            XSAttributeDecl xSAttributeDecl = xSAttributeUseImpl.fAttrDecl;
            short s = xSAttributeUseImpl.fConstraintType;
            ValidatedInfo validatedInfo = xSAttributeUseImpl.fDefault;
            if (s == 0) {
                s = xSAttributeDecl.getConstraintType();
                validatedInfo = xSAttributeDecl.fDefault;
            }
            boolean bl2 = bl = xMLAttributes.getValue(xSAttributeDecl.fTargetNamespace, xSAttributeDecl.fName) != null;
            if (xSAttributeUseImpl.fUse == 1 && !bl) {
                this.reportSchemaError("cvc-complex-type.4", new Object[]{qName.rawname, xSAttributeDecl.fName});
            }
            if (!bl && s != 0) {
                QName qName2 = new QName(null, xSAttributeDecl.fName, xSAttributeDecl.fName, xSAttributeDecl.fTargetNamespace);
                int n3 = xMLAttributes.addAttribute(qName2, "CDATA", validatedInfo != null ? validatedInfo.normalizedValue : "");
                Augmentations augmentations = xMLAttributes.getAugmentations(n3);
                AttributePSVImpl attributePSVImpl = (AttributePSVImpl)augmentations.getItem("ATTRIBUTE_PSVI");
                if (attributePSVImpl != null) {
                    attributePSVImpl.reset();
                } else {
                    attributePSVImpl = new AttributePSVImpl();
                    augmentations.putItem("ATTRIBUTE_PSVI", attributePSVImpl);
                }
                attributePSVImpl.fSpecified = false;
                attributePSVImpl.fValidationContext = this.fValidationRoot;
            }
            ++n2;
        }
    }

    XMLString processElementContent(QName qName) {
        Object object;
        XMLString xMLString = null;
        if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.fDefault != null && this.fBuffer.toString().length() == 0 && this.fChildCount == 0 && !this.fNil) {
            this.fCurrentPSVI.fSpecified = false;
            int n = this.fCurrentElemDecl.fDefault.normalizedValue.length();
            object = new char[n];
            this.fCurrentElemDecl.fDefault.normalizedValue.getChars(0, n, (char[])object, 0);
            xMLString = new XMLString((char[])object, 0, n);
            int n2 = this.fMatcherStack.getMatcherCount();
            int n3 = 0;
            while (n3 < n2) {
                XPathMatcher xPathMatcher = this.fMatcherStack.getMatcherAt(n3);
                xPathMatcher.characters(xMLString);
                ++n3;
            }
        }
        if (this.fCurrentElemDecl == null || this.fCurrentElemDecl.getConstraintType() == 1) {
            // empty if block
        }
        if (this.fDoValidation) {
            String string = this.fBuffer.toString();
            if (this.fNil) {
                if (this.fChildCount != 0 || string.length() != 0) {
                    this.reportSchemaError("cvc-elt.3.2.1", new Object[]{qName.rawname, this.URI_XSI + "," + this.XSI_NIL});
                    this.fCurrentPSVI.fNil = false;
                } else {
                    this.fCurrentPSVI.fNil = true;
                }
            }
            if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() != 0 && this.fChildCount == 0 && string.length() == 0 && !this.fNil) {
                if (this.fCurrentType != this.fCurrentElemDecl.fType && XSConstraints.ElementDefaultValidImmediate(this.fCurrentType, this.fCurrentElemDecl.fDefault.normalizedValue, this.fState4XsiType, null) == null) {
                    this.reportSchemaError("cvc-elt.5.1.1", new Object[]{qName.rawname, this.fCurrentType.getName(), this.fCurrentElemDecl.fDefault.normalizedValue});
                }
                this.elementLocallyValidType(qName, this.fCurrentElemDecl.fDefault.normalizedValue);
            } else {
                object = this.elementLocallyValidType(qName, string);
                if (this.fCurrentElemDecl != null && this.fCurrentElemDecl.getConstraintType() == 2 && !this.fNil) {
                    if (this.fChildCount != 0) {
                        this.reportSchemaError("cvc-elt.5.2.2.1", new Object[]{qName.rawname});
                    }
                    if (this.fCurrentType.getTypeCategory() == 13) {
                        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
                        if (xSComplexTypeDecl.fContentType == 3) {
                            if (!this.fCurrentElemDecl.fDefault.normalizedValue.equals(string)) {
                                this.reportSchemaError("cvc-elt.5.2.2.2.1", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.normalizedValue});
                            }
                        } else if (xSComplexTypeDecl.fContentType == 1 && object != null && !xSComplexTypeDecl.fXSSimpleType.isEqual(object, this.fCurrentElemDecl.fDefault.actualValue)) {
                            this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.normalizedValue});
                        }
                    } else if (this.fCurrentType.getTypeCategory() == 14) {
                        XSSimpleType xSSimpleType = (XSSimpleType)this.fCurrentType;
                        if (object != null && !xSSimpleType.isEqual(object, this.fCurrentElemDecl.fDefault.actualValue)) {
                            this.reportSchemaError("cvc-elt.5.2.2.2.2", new Object[]{qName.rawname, string, this.fCurrentElemDecl.fDefault.normalizedValue});
                        }
                    }
                }
            }
        }
        return xMLString;
    }

    Object elementLocallyValidType(QName qName, String string) {
        if (this.fCurrentType == null) {
            return null;
        }
        if (this.fUnionType) {
            int n = string.length();
            if (n >= 20) {
                this.fCharBuffer = new char[n * 2];
            }
            string.getChars(0, n, this.fCharBuffer, 0);
            this.fXMLString.setValues(this.fCharBuffer, 0, n);
        }
        Object object = null;
        if (this.fCurrentType.getTypeCategory() == 14) {
            if (this.fChildCount != 0) {
                this.reportSchemaError("cvc-type.3.1.2", new Object[]{qName.rawname});
            }
            if (!this.fNil) {
                XSSimpleType xSSimpleType = (XSSimpleType)this.fCurrentType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    object = xSSimpleType.validate(string, this.fValidationState, this.fValidatedInfo);
                    this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                    this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fAugmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fCurrentPSVI.fNormalizedValue = null;
                        this.fAugmentations.putItem("ELEMENT_PSVI", this.fCurrentPSVI);
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                    this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
                    this.reportSchemaError("cvc-type.3.1.3", new Object[]{qName.rawname, string});
                }
            }
        } else {
            object = this.elementLocallyValidComplexType(qName, string);
        }
        return object;
    }

    Object elementLocallyValidComplexType(QName qName, String string) {
        Object object = null;
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)this.fCurrentType;
        if (!this.fNil) {
            if (xSComplexTypeDecl.fContentType == 0 && (this.fChildCount != 0 || string.length() != 0 || this.fSawChildren)) {
                this.reportSchemaError("cvc-complex-type.2.1", new Object[]{qName.rawname});
            } else if (xSComplexTypeDecl.fContentType == 1) {
                if (this.fChildCount != 0) {
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{qName.rawname});
                }
                XSSimpleType xSSimpleType = xSComplexTypeDecl.fXSSimpleType;
                try {
                    if (!this.fNormalizeData || this.fUnionType) {
                        this.fValidationState.setNormalizationRequired(true);
                    }
                    object = xSSimpleType.validate(string, this.fValidationState, this.fValidatedInfo);
                    this.fCurrentPSVI.fNormalizedValue = this.fValidatedInfo.normalizedValue;
                    this.fCurrentPSVI.fMemberType = this.fValidatedInfo.memberType;
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    if (this.fDocumentHandler != null && this.fUnionType) {
                        this.fCurrentPSVI.fNormalizedValue = null;
                        this.fDocumentHandler.characters(this.fXMLString, this.fAugmentations);
                    }
                    this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs());
                    this.reportSchemaError("cvc-complex-type.2.2", new Object[]{qName.rawname});
                }
            } else if (xSComplexTypeDecl.fContentType == 2 && this.fSawCharacters) {
                this.reportSchemaError("cvc-complex-type.2.3", new Object[]{qName.rawname});
            }
            if (!(xSComplexTypeDecl.fContentType != 2 && xSComplexTypeDecl.fContentType != 3 || this.fCurrCMState[0] < 0 || this.fCurrentCM.endContentModel(this.fCurrCMState))) {
                this.reportSchemaError("cvc-complex-type.2.4.b", new Object[]{qName.rawname, xSComplexTypeDecl.fParticle.toString()});
            }
        }
        return object;
    }

    void reportSchemaError(String string, Object[] objectArray) {
        if (this.fDoValidation) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field field, IDValue iDValue) {
            int n = this.indexOf(field);
            if (n == -1) {
                this.ensureCapacity(this.fSize);
                n = this.fSize++;
                this.fEntries[n].key = field;
            }
            this.fEntries[n].value = iDValue;
        }

        public IDValue get(Field field) {
            return this.fEntries[this.indexOf((Field)field)].value;
        }

        public int indexOf(Field field) {
            int n = 0;
            while (n < this.fSize) {
                if (this.fEntries[n].key == field) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public Field keyAt(int n) {
            return this.fEntries[n].key;
        }

        public IDValue valueAt(int n) {
            return this.fEntries[n].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int n) {
            int n2 = -1;
            int n3 = -1;
            if (this.fEntries == null) {
                n2 = 0;
                n3 = 2;
                this.fEntries = new Entry[n3];
            } else if (this.fEntries.length <= n) {
                n2 = this.fEntries.length;
                n3 = 2 * n2;
                Entry[] entryArray = new Entry[n3];
                System.arraycopy(this.fEntries, 0, entryArray, 0, n2);
                this.fEntries = entryArray;
            }
            int n4 = n2;
            while (n4 < n3) {
                this.fEntries[n4] = new Entry();
                ++n4;
            }
        }

        public Object clone() {
            OrderedHashtable orderedHashtable = new OrderedHashtable();
            int n = 0;
            while (n < this.fSize) {
                orderedHashtable.put(this.fEntries[n].key, this.fEntries[n].value);
                ++n;
            }
            return orderedHashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            int n = 0;
            while (n < this.fSize) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('{');
                stringBuffer.append(this.fEntries[n].key);
                stringBuffer.append(',');
                stringBuffer.append(this.fEntries[n].value);
                stringBuffer.append('}');
                ++n;
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws XNIException {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable hashtable = (Hashtable)this.fGlobalMapStack.pop();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                IdentityConstraint identityConstraint = (IdentityConstraint)enumeration.nextElement();
                ValueStoreBase valueStoreBase = (ValueStoreBase)hashtable.get(identityConstraint);
                if (valueStoreBase == null) continue;
                ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
                if (valueStoreBase2 == null) {
                    this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
                    continue;
                }
                valueStoreBase2.append(valueStoreBase);
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase2);
            }
        }

        public void initValueStoresFor(XSElementDecl xSElementDecl) throws XNIException {
            IdentityConstraint[] identityConstraintArray = xSElementDecl.fIDConstraints;
            int n = xSElementDecl.fIDCPos;
            int n2 = 0;
            while (n2 < n) {
                switch (identityConstraintArray[n2].getCategory()) {
                    case 3: {
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)identityConstraintArray[n2];
                        UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(uniqueOrKey);
                        if (uniqueValueStore != null) break;
                        uniqueValueStore = new UniqueValueStore(uniqueOrKey);
                        this.fValueStores.addElement(uniqueValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(uniqueOrKey, uniqueValueStore);
                        break;
                    }
                    case 1: {
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)identityConstraintArray[n2];
                        KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(uniqueOrKey);
                        if (keyValueStore != null) break;
                        keyValueStore = new KeyValueStore(uniqueOrKey);
                        this.fValueStores.addElement(keyValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(uniqueOrKey, keyValueStore);
                        break;
                    }
                    case 2: {
                        KeyRef keyRef = (KeyRef)identityConstraintArray[n2];
                        KeyRefValueStore keyRefValueStore = (KeyRefValueStore)this.fIdentityConstraint2ValueStoreMap.get(keyRef);
                        if (keyRefValueStore != null) break;
                        keyRefValueStore = new KeyRefValueStore(keyRef, null);
                        this.fValueStores.addElement(keyRefValueStore);
                        this.fIdentityConstraint2ValueStoreMap.put(keyRef, keyRefValueStore);
                    }
                }
                ++n2;
            }
        }

        public ValueStoreBase getValueStoreFor(Field field) {
            IdentityConstraint identityConstraint = field.getIdentityConstraint();
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint identityConstraint) {
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint identityConstraint) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
        }

        public void transplant(IdentityConstraint identityConstraint) {
            if (identityConstraint.getCategory() == 2) {
                return;
            }
            ValueStoreBase valueStoreBase = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
            this.fIdentityConstraint2ValueStoreMap.remove(identityConstraint);
            ValueStoreBase valueStoreBase2 = (ValueStoreBase)this.fGlobalIDConstraintMap.get(identityConstraint);
            if (valueStoreBase2 != null) {
                valueStoreBase2.append(valueStoreBase);
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase2);
            } else {
                this.fGlobalIDConstraintMap.put(identityConstraint, valueStoreBase);
            }
        }

        public void endDocument() throws XNIException {
            int n = this.fValueStores.size();
            int n2 = 0;
            while (n2 < n) {
                ValueStoreBase valueStoreBase = (ValueStoreBase)this.fValueStores.elementAt(n2);
                valueStoreBase.endDocument();
                ++n2;
            }
        }

        public String toString() {
            String string = super.toString();
            int n = string.lastIndexOf(36);
            if (n != -1) {
                return string.substring(n + 1);
            }
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                return string.substring(n2 + 1);
            }
            return string;
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws XNIException {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLSchemaValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                String string = "KeyRefOutOfScope";
                String string2 = this.fIdentityConstraint.toString();
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2});
                return;
            }
            int n = this.fValueTuples.size();
            int n2 = 0;
            while (n2 < n) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValueTuples.elementAt(n2);
                if (!this.fKeyValueStore.contains(orderedHashtable)) {
                    String string = "KeyNotFound";
                    String string3 = this.toString(orderedHashtable);
                    String string4 = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string3, string4});
                }
                ++n2;
            }
        }

        public void endDocument() throws XNIException {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(UniqueOrKey uniqueOrKey) {
            super(uniqueOrKey);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
            String string = "DuplicateKey";
            String string2 = this.toString(orderedHashtable);
            String string3 = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2, string3});
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(UniqueOrKey uniqueOrKey) {
            super(uniqueOrKey);
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
            String string = "DuplicateUnique";
            String string2 = this.toString(orderedHashtable);
            String string3 = this.fIdentityConstraint.getElementName();
            XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2, string3});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void destroy() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase valueStoreBase) {
            int n = 0;
            while (n < valueStoreBase.fValueTuples.size()) {
                OrderedHashtable orderedHashtable = (OrderedHashtable)valueStoreBase.fValueTuples.elementAt(n);
                if (!this.contains(orderedHashtable)) {
                    this.fValueTuples.addElement(orderedHashtable);
                }
                ++n;
            }
        }

        public void startValueScope() throws XNIException {
            this.fValuesCount = 0;
            int n = this.fIdentityConstraint.getFieldCount();
            int n2 = 0;
            while (n2 < n) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(n2), this.NOT_AN_IDVALUE);
                ++n2;
            }
        }

        public void endValueScope() throws XNIException {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getCategory() == 1) {
                    String string = "AbsentKeyValue";
                    String string2 = this.fIdentityConstraint.getElementName();
                    XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string2});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getCategory()) {
                    case 3: {
                        String string = "UniqueNotEnoughValues";
                        String string3 = this.fIdentityConstraint.getElementName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string3});
                        break;
                    }
                    case 1: {
                        String string = "KeyNotEnoughValues";
                        UniqueOrKey uniqueOrKey = (UniqueOrKey)this.fIdentityConstraint;
                        String string4 = this.fIdentityConstraint.getElementName();
                        String string5 = uniqueOrKey.getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string4, string5});
                        break;
                    }
                    case 2: {
                        String string = "KeyRefNotEnoughValues";
                        KeyRef keyRef = (KeyRef)this.fIdentityConstraint;
                        String string6 = this.fIdentityConstraint.getElementName();
                        String string7 = keyRef.getKey().getIdentityConstraintName();
                        XMLSchemaValidator.this.reportSchemaError(string, new Object[]{string6, string7});
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws XNIException {
        }

        public void endDocument() throws XNIException {
        }

        public void reportNilError(IdentityConstraint identityConstraint) {
            if (identityConstraint.getCategory() == 1) {
                String string = "KeyMatchesNillable";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{identityConstraint.getElementName()});
            }
        }

        public void addValue(Field field, IDValue iDValue) {
            int n;
            if (!field.mayMatch()) {
                String string = "FieldMultipleMatch";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{field.toString()});
            }
            if ((n = this.fValues.indexOf(field)) == -1) {
                String string = "UnknownField";
                XMLSchemaValidator.this.reportSchemaError(string, new Object[]{field.toString()});
                return;
            }
            IDValue iDValue2 = this.fValues.valueAt(n);
            if (iDValue2.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, iDValue);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable orderedHashtable = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(orderedHashtable);
            }
        }

        public boolean contains(OrderedHashtable orderedHashtable) {
            int n = orderedHashtable.size();
            int n2 = this.fValueTuples.size();
            int n3 = 0;
            while (n3 < n2) {
                block3: {
                    OrderedHashtable orderedHashtable2 = (OrderedHashtable)this.fValueTuples.elementAt(n3);
                    int n4 = 0;
                    while (n4 < n) {
                        IDValue iDValue;
                        IDValue iDValue2 = orderedHashtable2.valueAt(n4);
                        if (iDValue2.isDuplicateOf(iDValue = orderedHashtable.valueAt(n4))) {
                            ++n4;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++n3;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable orderedHashtable) throws XNIException {
        }

        protected String toString(OrderedHashtable orderedHashtable) {
            int n = orderedHashtable.size();
            if (n == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(orderedHashtable.valueAt(n2));
                ++n2;
            }
            return stringBuffer.toString();
        }

        public String toString() {
            int n;
            String string = super.toString();
            int n2 = string.lastIndexOf(36);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if ((n = string.lastIndexOf(46)) != -1) {
                string = string.substring(n + 1);
            }
            return string + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int n = 0;
            while (n < this.fMatchersCount) {
                this.fMatchers[n] = null;
                ++n;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher xPathMatcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = xPathMatcher;
        }

        public XPathMatcher getMatcherAt(int n) {
            return this.fMatchers[n];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] xPathMatcherArray = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, xPathMatcherArray, 0, this.fMatchers.length);
                this.fMatchers = xPathMatcherArray;
            }
        }
    }

    class XSIErrorReporter {
        XMLErrorReporter fErrorReporter;
        Vector fErrors = new Vector(8, 8);
        int[] fContext = new int[8];
        int fContextCount;

        XSIErrorReporter() {
        }

        public void reset(XMLErrorReporter xMLErrorReporter) {
            this.fErrorReporter = xMLErrorReporter;
            this.fErrors.removeAllElements();
            this.fContextCount = 0;
        }

        public void pushContext() {
            if (this.fContextCount == this.fContext.length) {
                int n = this.fContextCount + 8;
                int[] nArray = new int[n];
                System.arraycopy(this.fContext, 0, nArray, 0, this.fContextCount);
                this.fContext = nArray;
            }
            this.fContext[this.fContextCount++] = this.fErrors.size();
        }

        public String[] popContext() {
            int n = this.fContext[--this.fContextCount];
            int n2 = this.fErrors.size() - n;
            if (n2 == 0) {
                return null;
            }
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = (String)this.fErrors.elementAt(n + n3);
                ++n3;
            }
            this.fErrors.setSize(n);
            return stringArray;
        }

        public void reportError(String string, String string2, Object[] objectArray, short s) throws XNIException {
            this.fErrorReporter.reportError(string, string2, objectArray, s);
            this.fErrors.addElement(string2);
        }

        public void reportError(XMLLocator xMLLocator, String string, String string2, Object[] objectArray, short s) throws XNIException {
            this.fErrorReporter.reportError(xMLLocator, string, string2, objectArray, s);
            this.fErrors.addElement(string2);
        }
    }
}

