/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.Transport;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcher
extends MessageDispatcher
implements ChannelListener {
    protected Object server_obj = null;
    protected Marshaller req_marshaller = null;
    protected Marshaller rsp_marshaller = null;
    protected final List additionalChannelListeners = new ArrayList();
    protected MethodLookup method_lookup = null;

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection) {
        super(channel, l, l2, deadlock_detection);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection, boolean concurrent_processing) {
        super(channel, l, l2, deadlock_detection, concurrent_processing);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, Object server_obj) {
        super(adapter, id, l, l2);
        Transport t;
        if (this.adapter != null && (t = this.adapter.getTransport()) != null && t instanceof Channel) {
            ((Channel)t).addChannelListener(this);
        }
        this.server_obj = server_obj;
    }

    public String getName() {
        return "RpcDispatcher";
    }

    public Marshaller getRequestMarshaller() {
        return this.req_marshaller;
    }

    public void setRequestMarshaller(Marshaller m) {
        this.req_marshaller = m;
    }

    public Marshaller getResponseMarshaller() {
        return this.rsp_marshaller;
    }

    public void setResponseMarshaller(Marshaller m) {
        this.rsp_marshaller = m;
        if (this.corr != null) {
            this.corr.setMarshaller(m);
        }
    }

    public Marshaller getMarshaller() {
        return this.req_marshaller;
    }

    public void setMarshaller(Marshaller m) {
        this.req_marshaller = m;
    }

    public Object getServerObject() {
        return this.server_obj;
    }

    public void setServerObject(Object server_obj) {
        this.server_obj = server_obj;
    }

    public MethodLookup getMethodLookup() {
        return this.method_lookup;
    }

    public void setMethodLookup(MethodLookup method_lookup) {
        this.method_lookup = method_lookup;
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)"this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)"this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        return this.callRemoteMethods(dests, method_name, args, types, mode, timeout, false);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout, boolean use_anycasting) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        return this.callRemoteMethods(dests, method_name, args, signature, mode, timeout, false);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout, boolean use_anycasting) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        return this.callRemoteMethods(dests, method_call, mode, timeout, false);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout, boolean use_anycasting) {
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting, false);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout, boolean use_anycasting, boolean oob) {
        byte[] buf;
        if (dests != null && dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)new StringBuffer("destination list of ").append(method_call.getName()).append("() is empty: no need to send message"));
            }
            return new RspList();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuffer("dests=").append(dests).append(", method_call=").append(method_call).append(", mode=").append(mode).append(", timeout=").append(timeout));
        }
        try {
            buf = this.req_marshaller != null ? this.req_marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            throw new RuntimeException("failure to marshal argument(s)", e);
        }
        Message msg = new Message(null, null, buf);
        if (oob) {
            msg.setFlag((byte)1);
        }
        RspList retval = super.castMessage(dests, msg, mode, timeout, use_anycasting);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("responses: " + retval));
        }
        return retval;
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws Throwable {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws Throwable {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws Throwable {
        return this.callRemoteMethod(dest, method_call, mode, timeout, false);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout, boolean oob) throws Throwable {
        byte[] buf = null;
        Message msg = null;
        Object retval = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("dest=" + dest + ", method_call=" + method_call + ", mode=" + mode + ", timeout=" + timeout));
        }
        buf = this.req_marshaller != null ? this.req_marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        msg = new Message(dest, null, buf);
        if (oob) {
            msg.setFlag((byte)1);
        }
        retval = super.sendMessage(msg, mode, timeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("retval: " + retval));
        }
        if (retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        return retval;
    }

    protected void correlatorStarted() {
        if (this.corr != null) {
            this.corr.setMarshaller(this.rsp_marshaller);
        }
    }

    public Object handle(Message req) {
        Object body = null;
        if (this.server_obj == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"no method handler is registered. Discarding request.");
            }
            return null;
        }
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message or message buffer is null");
            }
            return null;
        }
        try {
            body = this.req_marshaller != null ? this.req_marshaller.objectFromByteBuffer(req.getBuffer()) : req.getObject();
        }
        catch (Throwable e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"exception marshalling object", e);
            }
            return e;
        }
        if (!(body instanceof MethodCall)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message does not contain a MethodCall object");
            }
            return null;
        }
        MethodCall method_call = (MethodCall)body;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[sender=" + req.getSrc() + "], method_call: " + method_call));
            }
            if (method_call.getMode() == 5) {
                if (this.method_lookup == null) {
                    throw new Exception("MethodCall uses ID=" + method_call.getId() + ", but method_lookup has not been set");
                }
                Method m = this.method_lookup.findMethod(method_call.getId());
                if (m == null) {
                    throw new Exception("no method foudn for " + method_call.getId());
                }
                method_call.setMethod(m);
            }
            return method_call.invoke(this.server_obj);
        }
        catch (Throwable x) {
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            if (this.additionalChannelListeners.contains(l)) {
                return false;
            }
            this.additionalChannelListeners.add(l);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            return this.additionalChannelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelConnected(Channel channel) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelConnected(channel);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelDisconnected(channel);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelClosed(channel);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelShunned() {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelShunned();
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelReconnected(Address new_addr) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("channel has been rejoined, old local_addr=" + this.local_addr + ", new local_addr=" + new_addr));
        }
        this.local_addr = new_addr;
        this.start();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelReconnected(new_addr);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    public static interface Marshaller {
        public byte[] objectToByteBuffer(Object var1) throws Exception;

        public Object objectFromByteBuffer(byte[] var1) throws Exception;
    }
}

