/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.LinkedList;
import org.dom4j.Document;
import org.dom4j.Element;

public class Dom4JReader
implements HierarchicalStreamReader {
    private Element currentElement;
    private LinkedList pointers = new LinkedList();

    public Dom4JReader(Element element) {
        this.currentElement = element;
        this.pointers.addLast(new Pointer());
    }

    public Dom4JReader(Document document) {
        this.currentElement = document.getRootElement();
        this.pointers.addLast(new Pointer());
    }

    public String getNodeName() {
        return this.currentElement.getName();
    }

    public String getValue() {
        return this.currentElement.getText();
    }

    public String getAttribute(String string) {
        return this.currentElement.attributeValue(string);
    }

    public Object peekUnderlyingNode() {
        return this.currentElement;
    }

    public boolean hasMoreChildren() {
        Pointer pointer = (Pointer)this.pointers.getLast();
        return pointer.v < this.currentElement.elements().size();
    }

    public void moveUp() {
        this.currentElement = this.currentElement.getParent();
        this.pointers.removeLast();
    }

    public void moveDown() {
        Pointer pointer = (Pointer)this.pointers.getLast();
        this.pointers.addLast(new Pointer());
        this.currentElement = (Element)this.currentElement.elements().get(pointer.v);
        ++pointer.v;
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("xpath", this.currentElement.getPath());
    }

    private class Pointer {
        public int v;

        private Pointer() {
        }
    }
}

