/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.InputStream;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public class RandomReadNtFileWithMetadataTest
extends JCRTestBase {
    private Random rand = new Random();
    private int level1 = 0;
    private int level2 = 0;
    private int level3 = 0;
    private int level4 = 0;
    private int startIndex = 0;
    private String rootPath = "download";

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.rootPath = tc.getParam("jcr.rootPath");
        this.startIndex = tc.getIntParam("jcr.startIndex");
        this.level1 = tc.getIntParam("jcr.level1NodesCount");
        this.level2 = tc.getIntParam("jcr.level2NodesCount");
        this.level3 = tc.getIntParam("jcr.level3NodesCount");
        this.level4 = tc.getIntParam("jcr.level4NodesCount");
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        int level1Index = this.rand.nextInt(this.level1);
        int level2Index = this.rand.nextInt(this.level2);
        int level3Index = this.rand.nextInt(this.level3);
        int level4Index = this.rand.nextInt(this.level4);
        String path = this.rootPath + "/node" + (this.startIndex + level1Index) + "/node" + level2Index + "/node" + level3Index + "/" + level1Index + "-" + level2Index + "-" + level3Index + "-" + level4Index + ".txt";
        Node node = context.getSession().getRootNode().getNode(path);
        try {
            int len;
            Node contentNode = node.getNode("jcr:content");
            contentNode.getProperty("jcr:mimeType").getString();
            contentNode.getProperty("jcr:lastModified").getDate();
            contentNode.getProperty("dc:title").getValues()[0].getString();
            contentNode.getProperty("dc:subject").getValues()[0].getString();
            contentNode.getProperty("dc:creator").getValues()[0].getString();
            InputStream stream = contentNode.getProperty("jcr:data").getStream();
            int length = 0;
            byte[] buf = new byte[1024];
            while ((len = stream.read(buf)) > 0) {
                length += len;
            }
        }
        catch (PathNotFoundException e) {
            System.out.println("[error] can not find property for node, parent is : " + node.getPath());
            e.printStackTrace();
        }
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
    }
}

