/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.organization;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.organization.AbstractOrganizationTest;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;

public abstract class AbstractMembershipTest
extends AbstractOrganizationTest {
    private List<Membership> memberships;
    private List<User> users;
    private List<Group> groups;
    private List<MembershipType> membershipTypes;
    private int indexUser = 0;
    private int indexGroup = 0;
    private int indexMembershipType = 0;
    private int indexMembership = 0;
    private int runIterations;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int warmUpIterations;
        super.doPrepare(tc, context);
        this.runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            this.runIterations += warmUpIterations;
        }
        this.users = new ArrayList<User>();
        this.groups = new ArrayList<Group>();
        this.membershipTypes = new ArrayList<MembershipType>();
        this.memberships = new ArrayList<Membership>();
        for (int i = 0; i < this.runIterations; ++i) {
            User user = this.uHandler.createUserInstance(context.generateUniqueName("UserName"));
            user.setFirstName(context.generateUniqueName("First"));
            user.setLastName(context.generateUniqueName("Last"));
            user.setPassword(context.generateUniqueName("Password"));
            user.setEmail(context.generateUniqueName("Email"));
            this.users.add(user);
            Group group = this.gHandler.createGroupInstance();
            group.setGroupName(context.generateUniqueName("group"));
            group.setLabel(context.generateUniqueName("label"));
            this.groups.add(group);
            MembershipType mt = this.mtHandler.createMembershipTypeInstance();
            mt.setName(context.generateUniqueName("membershiptype"));
            this.membershipTypes.add(mt);
        }
    }

    protected void createContent(boolean linkMembership) throws Exception {
        for (int i = 0; i < this.runIterations; ++i) {
            User user = this.users.get(i);
            this.uHandler.createUser(user, false);
            Group g = this.groups.get(i);
            this.gHandler.createGroup(g, false);
            MembershipType mt = this.membershipTypes.get(i);
            this.mtHandler.createMembershipType(mt, false);
            if (!linkMembership) continue;
            this.mHandler.linkMembership(user, g, mt, false);
            Membership m = this.mHandler.findMembershipByUserGroupAndType(user.getUserName(), "/" + g.getGroupName(), mt.getName());
            this.memberships.add(m);
        }
    }

    protected User nextUser() {
        return this.users.get(this.indexUser++);
    }

    protected Group nextGroup() {
        return this.groups.get(this.indexGroup++);
    }

    protected MembershipType nextMembershipType() {
        return this.membershipTypes.get(this.indexMembershipType++);
    }

    protected Membership nextMembership() {
        return this.memberships.get(this.indexMembership++);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        String name;
        for (User user : this.users) {
            name = user.getUserName();
            if ((user = this.uHandler.findUserByName(name)) == null) continue;
            this.uHandler.removeUser(name, false);
        }
        for (Group g : this.groups) {
            Group group = this.gHandler.findGroupById("/" + g.getGroupName());
            if (group == null) continue;
            this.gHandler.removeGroup(group, false);
        }
        for (MembershipType mt : this.membershipTypes) {
            name = mt.getName();
            if ((mt = this.mtHandler.findMembershipType(name)) == null) continue;
            this.mtHandler.removeMembershipType(name, false);
        }
        this.users.clear();
        this.users = null;
        this.membershipTypes.clear();
        this.membershipTypes = null;
        this.groups.clear();
        this.groups = null;
        super.doFinish(tc, context);
    }
}

