/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.item.write;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public abstract class AbstractGetNoSavedItemsTest
extends JCRTestBase {
    private List<Node> parents = new ArrayList<Node>();
    private List<Node> childs = new ArrayList<Node>();
    private Node testRoot = null;
    private volatile int iteration = 0;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        Node parent;
        int i;
        int warmUpIterations;
        int runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            runIterations += warmUpIterations;
        }
        this.testRoot = context.getSession().getRootNode().addNode(context.generateUniqueName("testRoot"));
        context.getSession().save();
        for (i = 0; i < runIterations; ++i) {
            parent = this.testRoot.addNode(context.generateUniqueName("parent"));
            context.getSession().save();
            this.parents.add(parent);
        }
        for (i = 0; i < runIterations; ++i) {
            parent = this.parents.get(i);
            Node child = parent.addNode(context.generateUniqueName("child"));
            child.setProperty(context.generateUniqueName("property"), "value");
            this.childs.add(child);
        }
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.testRoot.remove();
        context.getSession().save();
    }

    protected Node nextParent() {
        return this.parents.get(this.iteration++);
    }
}

