/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public class NodeGetSamePropertyTest
extends JCRTestBase {
    private Node testNode;
    private int propertyType1Count;
    private int propertyType2Count;
    private static final String PROPERTY_NAME = "prop";

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        super.doFinish(tc, context);
        this.testNode.remove();
        this.testNode.getSession().save();
    }

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        Random generator;
        byte[] binaryValue;
        int i;
        super.doPrepare(tc, context);
        this.testNode = context.getSession().getRootNode().addNode(context.generateUniqueName("testRoot"));
        this.propertyType1Count = tc.getIntParam("usecase.propertyType1Count");
        this.propertyType2Count = tc.getIntParam("usecase.propertyType1Count");
        Value[] values = new Value[this.propertyType1Count + this.propertyType2Count];
        for (i = 0; i < this.propertyType1Count; ++i) {
            int propertyType1Size = tc.getIntParam("usecase.propertyType1SizeInKb") * 1024;
            binaryValue = new byte[propertyType1Size];
            generator = new Random();
            generator.nextBytes(binaryValue);
            values[i] = this.testNode.getSession().getValueFactory().createValue((InputStream)new ByteArrayInputStream(binaryValue));
        }
        for (i = 0; i < this.propertyType2Count; ++i) {
            int propertyType2Size = tc.getIntParam("usecase.propertyType2SizeInKb") * 1024;
            binaryValue = new byte[propertyType2Size];
            generator = new Random();
            generator.nextBytes(binaryValue);
            values[this.propertyType1Count + i] = this.testNode.getSession().getValueFactory().createValue((InputStream)new ByteArrayInputStream(binaryValue));
        }
        if (values.length == 1) {
            this.testNode.setProperty(PROPERTY_NAME, values[0]);
        } else {
            this.testNode.setProperty(PROPERTY_NAME, values);
        }
        this.testNode.getSession().save();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        this.testNode.getProperty(PROPERTY_NAME);
    }
}

