/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class AddNtFileWithMetadataTestCleanDBOracle
extends JCRTestBase {
    public static WorkspaceStorageConnection workspaceStorageConnection = null;
    public static boolean dataBaseDropped = false;
    public static byte[] contentOfFile = null;
    private Node rootNode = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        if (contentOfFile == null) {
            int offset;
            contentOfFile = new byte[(int)new File("../resources/benchmark.pdf").length()];
            FileInputStream is = new FileInputStream("../resources/benchmark.pdf");
            int numRead = 0;
            for (offset = 0; offset < contentOfFile.length && (numRead = ((InputStream)is).read(contentOfFile, offset, contentOfFile.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < contentOfFile.length) {
                throw new IOException("Could not completely read file ");
            }
            ((InputStream)is).close();
        }
        this.rootNode = context.getSession().getRootNode().addNode(context.generateUniqueName("rootNode"), "nt:unstructured");
        context.getSession().save();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Node nodeToAdd = this.rootNode.addNode(context.generateUniqueName("node"), "nt:file");
        Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
        contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(contentOfFile));
        contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "application/pdf");
        contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
        context.getSession().save();
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.cleanDB(context);
    }

    private synchronized void cleanDB(JCRTestContext context) {
        try {
            if (!dataBaseDropped) {
                JDBCWorkspaceDataContainer workspaceDataContainer = (JDBCWorkspaceDataContainer)((SessionImpl)context.getSession()).getContainer().getComponentInstanceOfType(JDBCWorkspaceDataContainer.class);
                workspaceStorageConnection = workspaceStorageConnection == null ? workspaceDataContainer.openConnection() : workspaceDataContainer.reuseConnection(workspaceStorageConnection);
                JDBCStorageConnection storageConnection = (JDBCStorageConnection)workspaceStorageConnection;
                Connection dbConnection = storageConnection.getJdbcConnection();
                ArrayList<String> oracleQueryList = new ArrayList<String>();
                oracleQueryList.add("DROP TABLE jcr_config");
                oracleQueryList.add("DROP TABLE jcr_scontainer");
                oracleQueryList.add("DROP TABLE jcr_svalue");
                oracleQueryList.add("DROP TABLE jcr_sref");
                oracleQueryList.add("DROP TABLE jcr_sitem");
                oracleQueryList.add("DROP SEQUENCE JCR_SVALUE_SEQ");
                for (String query : oracleQueryList) {
                    try {
                        dbConnection.prepareStatement(query).execute();
                    }
                    catch (Exception e) {}
                }
                dbConnection.commit();
                dataBaseDropped = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

